/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contenttype;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contenttype.ByteReader;
import org.eclipse.jst.jsp.core.internal.contenttype.HeadParserToken;
import org.eclipse.jst.jsp.core.internal.contenttype.JSPHeadTokenizer;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;

public class JSPResourceEncodingDetector
implements IResourceCharsetDetector {
    private String fCharset;
    private String fContentType;
    private String fContentTypeValue;
    private String fLanguage;
    private String fPageEncodingValue;
    private JSPHeadTokenizer fTokenizer;
    private String fXMLDecEncodingName;
    private boolean unicodeCase;
    private EncodingMemento fEncodingMemento;
    private boolean fHeaderParsed;
    private Reader fReader;
    private boolean fXHTML;
    private boolean fWML;

    public String getContentType() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        return this.fContentType;
    }

    public String getEncoding() throws IOException {
        return this.getEncodingMemento().getDetectedCharsetName();
    }

    public EncodingMemento getEncodingMemento() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        if (this.fEncodingMemento == null) {
            this.handleSpecDefault();
        }
        if (this.fEncodingMemento == null) {
            this.fEncodingMemento = new NullMemento();
        }
        return this.fEncodingMemento;
    }

    public String getLanguage() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        return this.fLanguage;
    }

    public String getSpecDefaultEncoding() {
        return "ISO-8859-1";
    }

    public EncodingMemento getSpecDefaultEncodingMemento() {
        this.resetAll();
        EncodingMemento result = null;
        String enc = this.getSpecDefaultEncoding();
        if (enc != null) {
            this.createEncodingMemento(enc, "DefaultsAssumedForEmptyInput");
            this.fEncodingMemento.setAppropriateDefault(enc);
            result = this.fEncodingMemento;
        }
        return result;
    }

    public void set(InputStream inputStream) {
        this.resetAll();
        this.fReader = new ByteReader(inputStream);
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void set(IStorage iStorage) throws CoreException {
        this.resetAll();
        InputStream inputStream = iStorage.getContents();
        BufferedInputStream resettableStream = new BufferedInputStream(inputStream, 8192);
        ((InputStream)resettableStream).mark(8192);
        this.set(resettableStream);
    }

    public void set(Reader reader) {
        this.resetAll();
        this.fReader = reader;
        if (!this.fReader.markSupported()) {
            this.fReader = new BufferedReader(this.fReader);
        }
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicode = false;
        if (tokenType == "UTF83ByteBOM") {
            canHandleAsUnicode = true;
            String enc = "UTF-8";
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUTF83ByteBOMUsed(true);
        } else if (tokenType == "UTF16BE" || tokenType == "UTF16LE") {
            canHandleAsUnicode = true;
            String enc = "UTF-16";
            byte[] bom = tokenType == "UTF16BE" ? IContentDescription.BOM_UTF_16BE : IContentDescription.BOM_UTF_16LE;
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUnicodeStream(true);
            this.fEncodingMemento.setUnicodeBOM(bom);
        }
        return canHandleAsUnicode;
    }

    private void createEncodingMemento(String detectedCharsetName) {
        this.fEncodingMemento = new EncodingMemento();
        this.fEncodingMemento.setJavaCharsetName(this.getAppropriateJavaCharset(detectedCharsetName));
        this.fEncodingMemento.setDetectedCharsetName(detectedCharsetName);
        this.fEncodingMemento.setAppropriateDefault(this.getSpecDefaultEncoding());
    }

    private String getAppropriateEncoding() {
        String result = null;
        if (this.fXMLDecEncodingName != null) {
            result = this.fXMLDecEncodingName;
        } else if (this.fPageEncodingValue != null) {
            result = this.fPageEncodingValue;
        } else if (this.fCharset != null) {
            result = this.fCharset;
        }
        return result;
    }

    private String getAppropriateJavaCharset(String detectedCharsetName) {
        Charset javaCharset;
        String result;
        block5: {
            result = null;
            result = CodedIO.checkMappingOverrides((String)detectedCharsetName);
            javaCharset = null;
            try {
                javaCharset = Charset.forName(detectedCharsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                if (result != null && result.equals(detectedCharsetName)) {
                    this.fEncodingMemento.setInvalidEncoding(detectedCharsetName);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                if (result == null || !result.equals(detectedCharsetName)) break block5;
                this.fEncodingMemento.setInvalidEncoding(detectedCharsetName);
            }
        }
        if (javaCharset != null) {
            result = javaCharset.name();
            result = CodedIO.checkMappingOverrides((String)result);
        }
        return result;
    }

    private JSPHeadTokenizer getTokinizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new JSPHeadTokenizer();
        }
        return this.fTokenizer;
    }

    private void handleSpecDefault() {
        String encodingName = this.getSpecDefaultEncoding();
        if (encodingName != null) {
            this.fEncodingMemento = new EncodingMemento();
            this.fEncodingMemento.setJavaCharsetName(encodingName);
            this.fEncodingMemento.setAppropriateDefault(encodingName);
        }
    }

    private boolean isLegalString(String valueTokenType) {
        boolean result = false;
        if (valueTokenType != null) {
            result = valueTokenType.equals("strval") || valueTokenType.equals("UnDelimitedStringValue") || valueTokenType.equals("InvalidTerminatedStringValue") || valueTokenType.equals("InvalidTermintatedUnDelimitedStringValue");
        }
        return result;
    }

    private void parseContentTypeValue(String contentType) {
        Pattern pattern = Pattern.compile(";\\s*charset\\s*=\\s*");
        String[] parts = pattern.split(contentType);
        if (parts.length > 0) {
            if (parts.length == 1) {
                if (parts[0].length() > 6) {
                    String checkForCharset = parts[0].substring(0, 7);
                    if (checkForCharset.equalsIgnoreCase("charset")) {
                        int eqpos = parts[0].indexOf(61);
                        if (++eqpos < parts[0].length()) {
                            this.fCharset = parts[0].substring(eqpos);
                            this.fCharset = this.fCharset.trim();
                        }
                    } else {
                        this.fContentType = parts[0];
                    }
                }
            } else {
                this.fContentType = parts[0];
            }
        }
        if (parts.length > 1) {
            this.fCharset = parts[1];
        }
    }

    private void parseHeader(JSPHeadTokenizer tokenizer) throws Exception {
        this.fPageEncodingValue = null;
        this.fCharset = null;
        HeadParserToken token = null;
        do {
            HeadParserToken valueToken;
            String valueTokenType;
            String tokenType;
            if (this.canHandleAsUnicodeStream(tokenType = (token = tokenizer.getNextToken()).getType())) {
                this.unicodeCase = true;
                continue;
            }
            if (tokenType == "XMLDelEncoding") {
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                this.fXMLDecEncodingName = valueToken.getText();
                continue;
            }
            if (tokenType == "PageEncoding") {
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                this.fPageEncodingValue = valueToken.getText();
                continue;
            }
            if (tokenType == "PageContentType") {
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                this.fContentTypeValue = valueToken.getText();
                continue;
            }
            if (tokenType != "PageLanguage" || !tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
            this.fLanguage = valueToken.getText();
        } while (tokenizer.hasMoreTokens());
        if (this.fContentTypeValue != null) {
            this.parseContentTypeValue(this.fContentTypeValue);
        }
        if (tokenizer.isXHTML()) {
            this.fXHTML = true;
        }
        if (tokenizer.isWML()) {
            this.fWML = true;
        }
    }

    private void parseInput() throws IOException {
        JSPHeadTokenizer tokenizer = this.getTokinizer();
        this.fReader.reset();
        tokenizer.reset(this.fReader);
        try {
            String enc;
            this.parseHeader(tokenizer);
            if (!this.unicodeCase && (enc = this.getAppropriateEncoding()) != null && enc.length() > 0) {
                this.createEncodingMemento(enc, "foundEncodingInContent");
            }
        }
        catch (Exception e) {
            Logger.log(204, e.getMessage());
        }
    }

    private void resetAll() {
        this.fReader = null;
        this.fHeaderParsed = false;
        this.fEncodingMemento = null;
        this.fCharset = null;
        this.fContentTypeValue = null;
        this.fPageEncodingValue = null;
        this.fXMLDecEncodingName = null;
        this.unicodeCase = false;
        this.fXHTML = false;
        this.fWML = false;
    }

    private void createEncodingMemento(String detectedCharsetName, String reason) {
        this.createEncodingMemento(detectedCharsetName);
    }

    private void ensureInputSet() {
        if (this.fReader == null) {
            throw new IllegalStateException("input must be set before use");
        }
    }

    public boolean isWML() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        return this.fWML;
    }

    public boolean isXHTML() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        return this.fXHTML;
    }

    class NullMemento
    extends EncodingMemento {
        public NullMemento() {
            String defaultCharset = NonContentBasedEncodingRules.useDefaultNameRules(null);
            this.setJavaCharsetName(defaultCharset);
            this.setAppropriateDefault(defaultCharset);
            this.setDetectedCharsetName(null);
        }
    }
}

