/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Image;

public abstract class DesignElementHandleAdapter {
    private DesignElementHandle elementHandle;
    private IModelAdapterHelper helper;

    public DesignElementHandleAdapter(DesignElementHandle element, IModelAdapterHelper mark) {
        this.elementHandle = element;
        this.helper = mark;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public String getDisplayName() {
        return this.getHandle().getDisplayLabel();
    }

    public DesignElementHandle getHandle() {
        return this.elementHandle;
    }

    public ReportDesignHandle getReportDesignHandle() {
        return (ReportDesignHandle)this.elementHandle.getModuleHandle();
    }

    public ModuleHandle getModuleHandle() {
        if (this.elementHandle != null) {
            return this.elementHandle.getModuleHandle();
        }
        return null;
    }

    public void reload() {
    }

    public boolean checkDirty() {
        if (this.helper != null) {
            return this.helper.isDirty();
        }
        return true;
    }

    public IModelAdapterHelper getModelAdaptHelper() {
        return this.helper;
    }

    protected Dimension getDefaultSize() {
        return this.helper.getPreferredSize().shrink(this.helper.getInsets().getWidth(), this.helper.getInsets().getHeight());
    }

    public void setElementHandle(DesignElementHandle handle) {
        this.elementHandle = handle;
    }

    public void transStar(String name) {
        CommandStack stack = this.getModuleHandle().getCommandStack();
        stack.startTrans(name);
    }

    public void transEnd() {
        CommandStack stack = this.getModuleHandle().getCommandStack();
        stack.commit();
    }

    public void rollBack() {
        CommandStack stack = this.getModuleHandle().getCommandStack();
        stack.rollbackAll();
    }

    public Insets getPadding(Insets retValue) {
        return DEUtil.getPadding(this.getHandle(), retValue);
    }

    public Insets getMargin(Insets retValue) {
        retValue = retValue == null ? new Insets() : new Insets(retValue);
        int fontSize = DEUtil.getFontSizeIntValue(this.getHandle());
        double px = 0.0;
        Object prop = this.getHandle().getProperty("marginTop");
        if (!"auto".equals(prop)) {
            px = DEUtil.convertToPixel(prop, fontSize);
        }
        double py = 0.0;
        prop = this.getHandle().getProperty("marginBottom");
        if (!"auto".equals(prop)) {
            py = DEUtil.convertToPixel(prop, fontSize);
        }
        retValue.top = (int)px;
        retValue.bottom = (int)py;
        py = 0.0;
        px = 0.0;
        prop = this.getHandle().getProperty("marginLeft");
        if (!"auto".equals(prop)) {
            px = DEUtil.convertToPixel(prop, fontSize);
        }
        if (!"auto".equals(prop = this.getHandle().getProperty("marginRight"))) {
            py = DEUtil.convertToPixel(prop, fontSize);
        }
        retValue.left = (int)px;
        retValue.right = (int)py;
        return retValue;
    }

    public int getBackgroundImageWidth(DesignElementHandle handle, Dimension size, Image image) {
        DimensionHandle obj = handle.getDimensionProperty("backgroundSizeWidth");
        if (obj == null || obj.getUnits() == null || obj.getUnits().length() == 0) {
            if (image == null) {
                return 0;
            }
            String str = handle.getStringProperty("backgroundSizeWidth");
            if ("contain".equals(str)) {
                Dimension imageSize = new Dimension(image);
                if ((double)imageSize.width / (double)imageSize.height > (double)size.width / (double)size.height) {
                    return size.width;
                }
                double value = (double)imageSize.width * (double)size.height / (double)imageSize.height;
                return (int)value;
            }
            if ("cover".equals(str)) {
                Dimension imageSize = new Dimension(image);
                if ((double)imageSize.width / (double)imageSize.height > (double)size.width / (double)size.height) {
                    double value = (double)imageSize.width * (double)size.height / (double)imageSize.height;
                    return (int)value;
                }
                return size.width;
            }
            return 0;
        }
        int fontSize = DEUtil.getFontSizeIntValue(this.getHandle());
        double px = 0.0;
        px = DEUtil.convertToPixel(obj, fontSize);
        return (int)px;
    }

    public int getBackgroundImageHeight(DesignElementHandle handle, Dimension size, Image image) {
        DimensionHandle obj = handle.getDimensionProperty("backgroundSizeHeight");
        if (obj == null || obj.getUnits() == null || obj.getUnits().length() == 0) {
            if (image == null) {
                return 0;
            }
            String str = handle.getStringProperty("backgroundSizeWidth");
            if ("contain".equals(str)) {
                Dimension imageSize = new Dimension(image);
                if ((double)imageSize.width / (double)imageSize.height > (double)size.width / (double)size.height) {
                    double value = (double)imageSize.height * (double)size.width / (double)imageSize.width;
                    return (int)value;
                }
                return size.height;
            }
            if ("cover".equals(str)) {
                Dimension imageSize = new Dimension(image);
                if ((double)imageSize.width / (double)imageSize.height > (double)size.width / (double)size.height) {
                    return size.height;
                }
                double value = (double)imageSize.height * (double)size.width / (double)imageSize.width;
                return (int)value;
            }
            return 0;
        }
        int fontSize = DEUtil.getFontSizeIntValue(this.getHandle());
        double py = 0.0;
        py = DEUtil.convertToPixel(obj, fontSize);
        return (int)py;
    }

    public int getForegroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("color");
        if (obj == null) {
            return 24;
        }
        int color = handle.getPropertyHandle("color").getIntValue();
        return color;
    }

    public int getBackgroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("backgroundColor");
        if (obj == null) {
            return 25;
        }
        int color = handle.getPropertyHandle("backgroundColor").getIntValue();
        return color;
    }

    public String getBackgroundImage(DesignElementHandle handle) {
        return handle.getStringProperty("backgroundImage");
    }

    public Object[] getBackgroundPosition(DesignElementHandle handle) {
        Object x = null;
        Object y = null;
        if (handle != null) {
            Object px = handle.getProperty("backgroundPositionX");
            Object py = handle.getProperty("backgroundPositionY");
            if (px instanceof String) {
                x = px;
            } else if (px instanceof DimensionValue) {
                x = "%".equals(((DimensionValue)px).getUnits()) ? px : Integer.valueOf((int)DEUtil.convertoToPixel(px));
            }
            if (py instanceof String) {
                y = py;
            } else if (py instanceof DimensionValue) {
                y = "%".equals(((DimensionValue)py).getUnits()) ? py : Integer.valueOf((int)DEUtil.convertoToPixel(py));
            }
        }
        return new Object[]{x, y};
    }

    public int getBackgroundRepeat(DesignElementHandle handle) {
        return this.getRepeat(handle.getStringProperty("backgroundRepeat"));
    }

    public static int getPosition(String position) {
        if ("left".equals(position)) {
            return 8;
        }
        if ("right".equals(position)) {
            return 16;
        }
        if ("top".equals(position)) {
            return 1;
        }
        if ("bottom".equals(position)) {
            return 4;
        }
        return 2;
    }

    private int getRepeat(String repeat) {
        if ("repeat-x".equals(repeat)) {
            return 1;
        }
        if ("repeat-y".equals(repeat)) {
            return 2;
        }
        if ("repeat".equals(repeat)) {
            return 3;
        }
        return 0;
    }

    public boolean isChildren(DesignElementHandle handle) {
        while (handle != null) {
            if (handle.equals(this.elementHandle)) {
                return true;
            }
            handle = handle.getContainer();
        }
        return false;
    }
}

