/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.browser.BrowserDescriptor;
import org.eclipse.ui.internal.browser.BrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.SystemBrowserDescriptor;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class BrowserManager
extends Observable {
    protected List browsers;
    protected IBrowserDescriptor currentBrowser;
    private IEclipsePreferences.IPreferenceChangeListener pcl = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String property = event.getKey();
            if (!BrowserManager.this.ignorePreferenceChanges && property.equals("browsers")) {
                BrowserManager.this.loadBrowsers();
            }
            if (!property.equals("internalWebBrowserHistory")) {
                BrowserManager.this.setChanged();
                BrowserManager.this.notifyObservers();
            }
        }
    };
    protected boolean ignorePreferenceChanges = false;
    protected static BrowserManager instance;

    public static BrowserManager getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
        }
        return instance;
    }

    private BrowserManager() {
        InstanceScope instanceScope = new InstanceScope();
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.ui.browser");
        prefs.addPreferenceChangeListener(this.pcl);
    }

    protected static void safeDispose() {
        if (instance == null) {
            return;
        }
        instance.dispose();
    }

    protected void dispose() {
        InstanceScope instanceScope = new InstanceScope();
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.ui.browser");
        prefs.removePreferenceChangeListener(this.pcl);
    }

    public IBrowserDescriptorWorkingCopy createExternalWebBrowser() {
        return new BrowserDescriptorWorkingCopy();
    }

    public List getWebBrowsers() {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        return new ArrayList(this.browsers);
    }

    protected void loadBrowsers() {
        Trace.trace(Trace.FINEST, "Loading web browsers");
        String xmlString = Platform.getPreferencesService().getString("org.eclipse.ui.browser", "browsers", null, null);
        if (xmlString != null && xmlString.length() > 0) {
            this.browsers = new ArrayList();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
                InputStreamReader reader = new InputStreamReader(in);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento system = memento.getChild("system");
                if (system != null && WebBrowserUtil.canUseSystemBrowser()) {
                    this.browsers.add(new SystemBrowserDescriptor());
                }
                IMemento[] children = memento.getChildren("external");
                int size = children.length;
                int i = 0;
                while (i < size) {
                    BrowserDescriptor browser = new BrowserDescriptor();
                    browser.load(children[i]);
                    this.browsers.add(browser);
                    ++i;
                }
                Integer current = memento.getInteger("current");
                if (current != null) {
                    this.currentBrowser = (IBrowserDescriptor)this.browsers.get(current);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Could not load browsers: " + e.getMessage());
            }
            SystemBrowserDescriptor system = new SystemBrowserDescriptor();
            if (WebBrowserUtil.canUseSystemBrowser() && !this.browsers.contains(system)) {
                this.browsers.add(0, system);
                this.currentBrowser = system;
                this.saveBrowsers();
            }
        } else {
            this.setupDefaultBrowsers();
            this.saveBrowsers();
        }
        if (this.currentBrowser == null && this.browsers.size() > 0) {
            this.currentBrowser = (IBrowserDescriptor)this.browsers.get(0);
        }
        this.setChanged();
        this.notifyObservers();
    }

    protected void saveBrowsers() {
        try {
            this.ignorePreferenceChanges = true;
            XMLMemento memento = XMLMemento.createWriteRoot((String)"web-browsers");
            Iterator iterator = this.browsers.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof BrowserDescriptor) {
                    BrowserDescriptor browser = (BrowserDescriptor)obj;
                    IMemento child = memento.createChild("external");
                    browser.save(child);
                    continue;
                }
                if (!(obj instanceof SystemBrowserDescriptor)) continue;
                memento.createChild("system");
            }
            memento.putInteger("current", this.browsers.indexOf(this.currentBrowser));
            StringWriter writer = new StringWriter();
            memento.save((Writer)writer);
            String xmlString = writer.getBuffer().toString();
            InstanceScope instanceScope = new InstanceScope();
            IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.ui.browser");
            prefs.put("browsers", xmlString);
            prefs.flush();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save browsers", e);
        }
        this.ignorePreferenceChanges = false;
    }

    protected void setupDefaultBrowsers() {
        this.browsers = new ArrayList();
        if (WebBrowserUtil.canUseSystemBrowser()) {
            SystemBrowserDescriptor system = new SystemBrowserDescriptor();
            this.browsers.add(system);
        }
        WebBrowserUtil.addFoundBrowsers(this.browsers);
        if (!this.browsers.isEmpty() && this.currentBrowser == null) {
            this.currentBrowser = (IBrowserDescriptor)this.browsers.get(0);
        }
    }

    protected void addBrowser(IBrowserDescriptor browser) {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        if (!this.browsers.contains(browser)) {
            this.browsers.add(browser);
        }
        if (this.browsers.size() == 1) {
            this.setCurrentWebBrowser(browser);
        }
        this.saveBrowsers();
    }

    protected void removeWebBrowser(IBrowserDescriptor browser) {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        this.browsers.remove(browser);
        if (this.currentBrowser == null || this.currentBrowser.equals(browser)) {
            this.currentBrowser = null;
            if (this.browsers.size() > 0) {
                this.currentBrowser = (IBrowserDescriptor)this.browsers.get(0);
            }
        }
    }

    public IBrowserDescriptor getCurrentWebBrowser() {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        if (this.currentBrowser == null && this.browsers.size() > 0) {
            return (IBrowserDescriptor)this.browsers.get(0);
        }
        return this.currentBrowser;
    }

    public void setCurrentWebBrowser(IBrowserDescriptor wb) {
        if (wb == null) {
            throw new IllegalArgumentException();
        }
        if (!this.browsers.contains(wb)) {
            throw new IllegalArgumentException();
        }
        this.currentBrowser = wb;
        this.saveBrowsers();
    }
}

