/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.twiki.core.TWikiLanguage;

public class LinkReplacementToken
extends PatternBasedElement {
    private static final Pattern replacementPattern = Pattern.compile("\\W");
    private static final Pattern wordBoundaryPattern = Pattern.compile("\\W\\w");

    protected String getPattern(int groupOffset) {
        return "(!)?(\\[\\[([^\\]]+)(?:(\\]\\[)(.*))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 5;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new LinkProcessor();
    }

    private static class LinkProcessor
    extends PatternBasedElementProcessor {
        private LinkProcessor() {
        }

        public void emit() {
            String escaped = this.group(1);
            if (escaped != null) {
                String escapedText = this.group(2);
                this.builder.characters(escapedText);
            } else {
                boolean looksLikeEmail;
                String link = this.group(3);
                String text = this.group(5);
                if (text == null || text.trim().length() == 0) {
                    text = link;
                }
                boolean bl = looksLikeEmail = link.indexOf(64) != -1;
                if (link.indexOf(47) != -1 || link.indexOf(35) != -1 || looksLikeEmail) {
                    if (looksLikeEmail) {
                        text = text.replaceFirst("\\s*mailto:", "");
                    }
                    this.builder.link(link, text);
                } else {
                    link = this.camelCaseWordBoundaries(link);
                    String target = replacementPattern.matcher(link).replaceAll("");
                    TWikiLanguage twikiLanguage = (TWikiLanguage)this.markupLanguage;
                    boolean exists = twikiLanguage.computeInternalLinkExists(target);
                    String internalHref = twikiLanguage.toInternalHref(target);
                    if (!exists) {
                        this.builder.characters(text);
                        this.builder.link(internalHref, "?");
                    } else {
                        this.builder.link(internalHref, text);
                    }
                }
            }
        }

        private String camelCaseWordBoundaries(String text) {
            Matcher matcher = wordBoundaryPattern.matcher(text);
            String newText = Character.toString(Character.toUpperCase(text.charAt(0)));
            int start = 1;
            while (matcher.find()) {
                int offset = matcher.start();
                newText = String.valueOf(newText) + text.substring(start, offset);
                newText = String.valueOf(newText) + Character.toUpperCase(text.charAt(offset + 1));
                start = offset + 2;
            }
            if (start < text.length()) {
                newText = String.valueOf(newText) + text.substring(start);
            }
            return newText;
        }
    }
}

