/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLHistoryManager {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history.xml";
    private static SQLHistoryManager _instance = null;
    private static final Logger LOGGER = Logger.getLogger(SQLHistory.class.getName());
    private List<SQLHistory> sqlList = new ArrayList<SQLHistory>();
    private int listSize;
    private FileObject historyRoot;

    private SQLHistoryManager() {
    }

    public static SQLHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new SQLHistoryManager();
        }
        return _instance;
    }

    public int getListSize() {
        return this.listSize;
    }

    public FileObject getHistoryRoot() {
        return this.historyRoot;
    }

    public void setHistoryRoot(FileObject fileObject) {
        this.historyRoot = fileObject;
    }

    public void setListSize(int n) {
        this.listSize = n;
    }

    public void saveSQL(SQLHistory sQLHistory) {
        this.sqlList.add(sQLHistory);
    }

    public void save(FileObject fileObject) {
        try {
            this.setHistoryRoot(fileObject.getFileObject(SQL_HISTORY_FOLDER));
            if (null == this.historyRoot || !this.historyRoot.isValid()) {
                this.historyRoot = FileUtil.createFolder((FileObject)fileObject, (String)SQL_HISTORY_FOLDER);
            }
            SQLHistoryPersistenceManager.getInstance().create(this.historyRoot, this.sqlList);
            this.sqlList.clear();
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, exception.getMessage());
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLHistoryManager.class, (String)"MSG_ErrorParsingHistoryFile"));
        }
    }

    public List<SQLHistory> getSQLHistory() {
        return this.sqlList;
    }

    public List<SQLHistory> retrieve() {
        return new ArrayList<SQLHistory>();
    }

    public List<String> retrieve(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.getUrlsUsed().isEmpty()) {
            for (SQLHistory sQLHistory : this.sqlList) {
                String string2 = sQLHistory.getSql();
                if (!string.equals(sQLHistory.getUrl())) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private List<String> getUrlsUsed() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SQLHistory sQLHistory : this.sqlList) {
            String string = sQLHistory.getUrl();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int updateList(int n, String string, FileObject fileObject) throws SQLHistoryException {
        List<Object> list = new ArrayList();
        int n2 = 0;
        try {
            list = SQLHistoryPersistenceManager.getInstance().retrieve(string, fileObject);
            if (n >= list.size()) {
                return -1;
            }
            n2 = list.size() - n;
            for (int i = 0; i < n2; ++i) {
                list.remove(0);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLHistoryPanel.class, (String)"MSG_RuntimeErrorRetrievingHistory") + classNotFoundException);
        }
        this.sqlList = list;
        return n2;
    }
}

