/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    CharSequence inputSourceText;
    private TokenListText readText;
    private TokenListText readExistingText;
    private EmbeddedTokenList<T> activeTokenList;
    private int activeTokenListIndex;
    private int activeTokenListEndOffset;
    private int realTokenStartOffset;
    private boolean recognizedTokenJoined;
    private int skipTokenListCount;

    public JoinLexerInputOperation(JoinTokenList<T> joinTokenList, int n, Object object, int n2, int n3) {
        super(joinTokenList, n, object);
        this.inputSourceText = joinTokenList.inputSourceText();
        this.activeTokenListIndex = n2;
        this.tokenStartOffset = n3;
        this.readOffset = n3;
    }

    public final void init() {
        this.fetchActiveTokenList();
        this.readText = new TokenListText();
        this.readText.tokenListIndex = this.activeTokenListIndex;
        this.readText.tokenListStartOffset = this.realTokenStartOffset;
        this.readText.tokenListEndOffset = this.activeTokenListEndOffset;
        this.realTokenStartOffset = this.readOffset;
    }

    public EmbeddedTokenList<T> activeTokenList() {
        return this.activeTokenList;
    }

    public int activeTokenListIndex() {
        return this.activeTokenListIndex;
    }

    public int skipTokenListCount() {
        return this.skipTokenListCount;
    }

    public void clearSkipTokenListCount() {
        this.skipTokenListCount = 0;
    }

    public boolean recognizedTokenLastInTokenList() {
        return this.realTokenStartOffset == this.activeTokenListEndOffset;
    }

    @Override
    public int lastTokenEndOffset() {
        return this.realTokenStartOffset;
    }

    @Override
    public int read(int n) {
        return this.readText.read(n);
    }

    @Override
    public char readExisting(int n) {
        if (this.readText.isInBounds(n)) {
            return this.readText.inBoundsChar(n);
        }
        if (this.readExistingText == null) {
            this.readExistingText = new TokenListText();
            this.readExistingText.initFrom(this.readText);
        }
        return this.readExistingText.existingChar(n);
    }

    @Override
    public void assignTokenLength(int n) {
        super.assignTokenLength(n);
        if (this.recognizedTokenLastInTokenList()) {
            do {
                ++this.skipTokenListCount;
                ++this.activeTokenListIndex;
                this.fetchActiveTokenList();
            } while (this.realTokenStartOffset == this.activeTokenListEndOffset);
        }
        this.realTokenStartOffset += n;
        this.recognizedTokenJoined = this.realTokenStartOffset > this.activeTokenListEndOffset;
    }

    private void fetchActiveTokenList() {
        this.activeTokenList = this.tokenList(this.activeTokenListIndex);
        this.realTokenStartOffset = this.activeTokenList.startOffset();
        this.activeTokenListEndOffset = this.activeTokenList.endOffset();
    }

    public EmbeddedTokenList<T> tokenList(int n) {
        return ((JoinTokenList)this.tokenList).tokenList(n);
    }

    protected int tokenListCount() {
        return ((JoinTokenList)this.tokenList).tokenListCount();
    }

    @Override
    protected void fillTokenData(AbstractToken<T> abstractToken) {
        if (!this.recognizedTokenJoined) {
            abstractToken.setRawOffset(this.realTokenStartOffset - this.tokenLength);
        }
    }

    @Override
    protected boolean isFlyTokenAllowed() {
        return super.isFlyTokenAllowed() && !this.recognizedTokenJoined;
    }

    @Override
    protected AbstractToken<T> createDefaultTokenInstance(T t) {
        if (this.recognizedTokenJoined) {
            return this.createJoinToken(t, null, PartType.COMPLETE);
        }
        return super.createDefaultTokenInstance(t);
    }

    @Override
    protected AbstractToken<T> createPropertyTokenInstance(T t, TokenPropertyProvider<T> tokenPropertyProvider, PartType partType) {
        if (this.recognizedTokenJoined) {
            return this.createJoinToken(t, null, partType);
        }
        return super.createPropertyTokenInstance(t, tokenPropertyProvider, partType);
    }

    private AbstractToken<T> createJoinToken(T t, TokenPropertyProvider<T> tokenPropertyProvider, PartType partType) {
        Object object;
        this.realTokenStartOffset -= this.tokenLength;
        JoinToken<T> joinToken = new JoinToken<T>(t, this.tokenLength, tokenPropertyProvider, partType);
        int n = this.readText.tokenListIndex - this.activeTokenListIndex + 1;
        Object[] objectArray = new PartToken[n];
        int n2 = this.activeTokenListEndOffset - this.realTokenStartOffset;
        PartToken<T> partToken = new PartToken<T>(t, n2, tokenPropertyProvider, PartType.START, joinToken, 0, 0);
        partToken.setRawOffset(this.realTokenStartOffset);
        objectArray[0] = partToken;
        int n3 = 1;
        int n4 = n2;
        int n5 = this.activeTokenListIndex;
        do {
            ++this.activeTokenListIndex;
            this.fetchActiveTokenList();
            n2 = this.activeTokenListEndOffset - this.realTokenStartOffset;
            if (n2 == 0) continue;
            if (n4 + n2 >= this.tokenLength) {
                n2 = this.tokenLength - n4;
                object = partType == PartType.START ? PartType.MIDDLE : PartType.END;
            } else {
                object = PartType.MIDDLE;
            }
            partToken = new PartToken<T>(t, n2, tokenPropertyProvider, (PartType)((Object)object), joinToken, n3, n4);
            partToken.setRawOffset(this.realTokenStartOffset);
            n4 += n2;
            objectArray[n3++] = partToken;
        } while (n4 < this.tokenLength);
        this.realTokenStartOffset += n2;
        if (n3 < objectArray.length) {
            object = new PartToken[n3];
            System.arraycopy(objectArray, 0, object, 0, n3);
            objectArray = object;
        }
        object = ArrayUtilities.unmodifiableList((Object[])objectArray);
        joinToken.setJoinedParts((List<PartToken<T>>)object, this.activeTokenListIndex - n5);
        return joinToken;
    }

    @Override
    public String toString() {
        return super.toString() + ", realTokenStartOffset=" + this.realTokenStartOffset + ", activeTokenListIndex=" + this.activeTokenListIndex + ", activeTokenListEndOffset=" + this.activeTokenListEndOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class TokenListText {
        int tokenListIndex;
        int tokenListStartOffset;
        int tokenListEndOffset;
        int readOffsetShift;

        TokenListText() {
        }

        void init() {
            EmbeddedTokenList embeddedTokenList = JoinLexerInputOperation.this.tokenList(JoinLexerInputOperation.this.activeTokenListIndex);
            this.tokenListStartOffset = embeddedTokenList.startOffset();
            this.tokenListEndOffset = embeddedTokenList.endOffset();
        }

        void initFrom(TokenListText tokenListText) {
            this.tokenListIndex = tokenListText.tokenListIndex;
            this.tokenListStartOffset = tokenListText.tokenListStartOffset;
            this.tokenListEndOffset = tokenListText.tokenListEndOffset;
            this.readOffsetShift = tokenListText.readOffsetShift;
        }

        int read(int n) {
            if ((n += this.readOffsetShift) < this.tokenListEndOffset) {
                if (n >= this.tokenListStartOffset) {
                    return JoinLexerInputOperation.this.inputSourceText.charAt(n);
                }
                while ((n -= this.movePreviousTokenList()) < this.tokenListStartOffset) {
                }
                return JoinLexerInputOperation.this.inputSourceText.charAt(n);
            }
            while (this.tokenListIndex + 1 < JoinLexerInputOperation.this.tokenListCount()) {
                if ((n += this.moveNextTokenList()) >= this.tokenListEndOffset) continue;
                return JoinLexerInputOperation.this.inputSourceText.charAt(n);
            }
            return -1;
        }

        boolean isInBounds(int n) {
            return (n += this.readOffsetShift) >= this.tokenListStartOffset && n < this.tokenListEndOffset;
        }

        char inBoundsChar(int n) {
            return JoinLexerInputOperation.this.inputSourceText.charAt(n += this.readOffsetShift);
        }

        char existingChar(int n) {
            if ((n += this.readOffsetShift) < this.tokenListStartOffset) {
                while ((n -= this.movePreviousTokenList()) < this.tokenListStartOffset) {
                }
                return JoinLexerInputOperation.this.inputSourceText.charAt(n);
            }
            if (n >= this.tokenListEndOffset) {
                while ((n += this.moveNextTokenList()) >= this.tokenListEndOffset) {
                }
                return JoinLexerInputOperation.this.inputSourceText.charAt(n);
            }
            return JoinLexerInputOperation.this.inputSourceText.charAt(n);
        }

        private int movePreviousTokenList() {
            --this.tokenListIndex;
            EmbeddedTokenList embeddedTokenList = JoinLexerInputOperation.this.tokenList(this.tokenListIndex);
            this.tokenListEndOffset = embeddedTokenList.endOffset();
            int n = this.tokenListStartOffset - this.tokenListEndOffset;
            this.readOffsetShift -= n;
            this.tokenListStartOffset = embeddedTokenList.startOffset();
            return n;
        }

        private int moveNextTokenList() {
            ++this.tokenListIndex;
            EmbeddedTokenList embeddedTokenList = JoinLexerInputOperation.this.tokenList(this.tokenListIndex);
            this.tokenListStartOffset = embeddedTokenList.startOffset();
            int n = this.tokenListStartOffset - this.tokenListEndOffset;
            this.readOffsetShift += n;
            this.tokenListEndOffset = embeddedTokenList.endOffset();
            return n;
        }

        public String toString() {
            return "tlInd=" + this.tokenListIndex + ", <" + this.tokenListStartOffset + "," + this.tokenListEndOffset + ">";
        }
    }
}

