/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.nodes;

import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.actions.AdministerAction;
import org.netbeans.modules.db.mysql.actions.ConnectServerAction;
import org.netbeans.modules.db.mysql.actions.CreateDatabaseAction;
import org.netbeans.modules.db.mysql.actions.DisconnectServerAction;
import org.netbeans.modules.db.mysql.actions.PropertiesAction;
import org.netbeans.modules.db.mysql.actions.RefreshServerAction;
import org.netbeans.modules.db.mysql.actions.StartAction;
import org.netbeans.modules.db.mysql.actions.StopAction;
import org.netbeans.modules.db.mysql.impl.ServerNodeProvider;
import org.netbeans.modules.db.mysql.nodes.DatabaseNode;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class ServerNode
extends AbstractNode
implements ChangeListener,
Comparable {
    private final DatabaseServer server;
    private static final String ICON = "org/netbeans/modules/db/mysql/resources/catalog.gif";
    private static final HelpCtx HELP_CONTEXT = new HelpCtx(ServerNode.class.getName());

    public static ServerNode create(DatabaseServer databaseServer) {
        ChildFactory childFactory = new ChildFactory(databaseServer);
        return new ServerNode(childFactory, databaseServer);
    }

    private ServerNode(ChildFactory childFactory, DatabaseServer databaseServer) {
        super(Children.create((org.openide.nodes.ChildFactory)childFactory, (boolean)true));
        this.server = databaseServer;
        this.setName("");
        this.setDisplayName(databaseServer.getDisplayName());
        this.setShortDescription(databaseServer.getShortDescription());
        this.setIconBaseWithExtension(ICON);
        this.registerListeners();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == DatabaseServer.class) {
            return this.server;
        }
        return super.getCookie(clazz);
    }

    public HelpCtx getHelpCtx() {
        return HELP_CONTEXT;
    }

    private void registerListeners() {
        DatabaseServer databaseServer = DatabaseServerManager.getDatabaseServer();
        databaseServer.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)databaseServer));
        this.stateChanged(new ChangeEvent(databaseServer));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        String string = this.getDisplayName();
        String string2 = this.getShortDescription();
        this.setDisplayName(this.server.getDisplayName());
        this.fireNameChange(string, this.getDisplayName());
        this.setShortDescription(this.server.getShortDescription());
        this.fireShortDescriptionChange(string2, this.getShortDescription());
        this.fireIconChange();
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return super.getActions(bl);
        }
        return new SystemAction[]{SystemAction.get(CreateDatabaseAction.class), SystemAction.get(StartAction.class), SystemAction.get(StopAction.class), SystemAction.get(ConnectServerAction.class), SystemAction.get(DisconnectServerAction.class), SystemAction.get(DeleteAction.class), SystemAction.get(RefreshServerAction.class), SystemAction.get(AdministerAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public Image getIcon(int n) {
        return this.server.getIcon();
    }

    public void destroy() {
        ServerNodeProvider.getDefault().setRegistered(false);
    }

    public int compareTo(Object object) {
        Node node = (Node)object;
        return this.getDisplayName().compareTo(node.getDisplayName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceComparator
    implements Comparator<Database>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(Database database, Database database2) {
            return database.getDisplayName().compareTo(database2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<Database>
    implements ChangeListener {
        private static final Comparator<Database> COMPARATOR = new InstanceComparator();
        private final DatabaseServer server;

        public ChildFactory(DatabaseServer databaseServer) {
            this.server = databaseServer;
            databaseServer.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)databaseServer));
            this.stateChanged(new ChangeEvent(databaseServer));
        }

        protected Node createNodeForKey(Database database) {
            return new DatabaseNode(database);
        }

        protected boolean createKeys(List<Database> list) {
            ArrayList<Database> arrayList = new ArrayList<Database>();
            try {
                arrayList.addAll(this.server.getDatabases());
            }
            catch (DatabaseException databaseException) {
                Utils.displayError(Utils.getMessage("MSG_UnableToGetDatabaseList", new Object[0]), (Exception)((Object)databaseException));
                return true;
            }
            Collections.sort(arrayList, COMPARATOR);
            list.addAll(arrayList);
            return true;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh(false);
        }
    }
}

