/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nickyb.sqleonardo.common.gui.AbstractDialogModal;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.ContentChanges;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;
import nickyb.sqleonardo.environment.ctrl.content.TableMetaData;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class DialogPreview
extends AbstractDialogModal {
    private JTextArea syntaxes;
    private ContentView view;
    private TableMetaData tmd;

    public DialogPreview(ContentView view, TableMetaData tmd) {
        super((Component)Application.window, "changes");
        this.view = view;
        this.tmd = tmd;
        this.syntaxes = new JTextArea();
        this.getContentPane().add(new JScrollPane(this.syntaxes));
        this.syntaxes.setEditable(false);
    }

    protected void onOpen() {
        int i;
        int whereCols = this.tmd.getPrimaryKeys().size();
        String preparedWhere = new String(" WHERE ");
        ArrayList<Integer> whereColsIDX = new ArrayList<Integer>();
        for (i = 0; i < whereCols; ++i) {
            String colName = this.tmd.getPrimaryKeyProperty(i, 3);
            int idx = this.view.getColumnIndex(colName);
            if (idx >= 0) {
                preparedWhere = preparedWhere + colName + " = ? AND ";
                whereColsIDX.add(new Integer(idx));
                continue;
            }
            --whereCols;
        }
        preparedWhere = preparedWhere.substring(0, preparedWhere.length() - 5);
        for (i = 0; i < this.view.getChanges().count(); ++i) {
            ContentChanges.Handler handler = this.view.getChanges().getHandlerAt(i);
            Object[] rowdata = this.view.getValues(handler.rid);
            String sql = null;
            if (handler.type.equals(ContentChanges.INSERT)) {
                String columns = new String();
                String values = new String();
                for (int j = 0; j < rowdata.length; ++j) {
                    Object cell = rowdata[j];
                    if (rowdata[j] instanceof Object[]) {
                        cell = ((Object[])rowdata[j])[0];
                    }
                    columns = columns + this.view.getColumnName(j) + ",";
                    values = values + this.toJdbcValue(cell, j) + ",";
                }
                columns = columns.substring(0, columns.length() - 1);
                values = values.substring(0, values.length() - 1);
                sql = "INSERT INTO " + this.tmd.getIdentifier() + " (" + columns + ") VALUES (" + values + ")";
            } else {
                int j;
                String where = preparedWhere;
                for (j = 0; j < whereCols; ++j) {
                    int pos = where.indexOf("?");
                    int col = (Integer)whereColsIDX.get(j);
                    Object cell = rowdata[col];
                    if (cell instanceof Object[]) {
                        cell = ((Object[])cell)[1];
                    }
                    where = Text.replaceText(where, this.toJdbcValue(cell, col), pos, 1);
                }
                if (handler.type.equals(ContentChanges.DELETE)) {
                    sql = "DELETE FROM " + this.tmd.getIdentifier() + where;
                } else if (handler.type.equals(ContentChanges.UPDATE)) {
                    sql = "UPDATE " + this.tmd.getIdentifier() + " SET ";
                    for (j = 0; j < rowdata.length; ++j) {
                        if (!(rowdata[j] instanceof Object[])) continue;
                        Object cell = ((Object[])rowdata[j])[0];
                        sql = sql + this.view.getColumnName(j) + " = " + this.toJdbcValue(cell, j) + ",";
                    }
                    sql = sql.substring(0, sql.length() - 1) + where;
                }
            }
            this.syntaxes.append(sql.trim() + ";\n");
        }
    }

    private String toJdbcValue(Object value, int col) {
        return SQLFormatter.toJdbcValue(value, this.view.getColumnType(col));
    }
}

