/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.jdbc;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;

public class ConnectionAssistant {
    private static Hashtable drivers = new Hashtable();
    private static Hashtable connections = new Hashtable();

    public static ConnectionHandler open(String keycad, String keycah, String url, String uid, String pwd) throws Exception {
        Driver d = (Driver)drivers.get(keycad);
        Properties info = new Properties();
        if (uid != null) {
            info.put("user", uid);
        }
        if (pwd != null) {
            info.put("password", pwd);
        }
        ConnectionHandler ch = new ConnectionHandler(d.connect(url, info));
        connections.put(keycah, ch);
        return ch;
    }

    public static boolean hasHandler(String keycah) {
        return keycah == null ? false : connections.containsKey(keycah);
    }

    public static ConnectionHandler getHandler(String keycah) {
        return (ConnectionHandler)connections.get(keycah);
    }

    public static void removeHandler(String keycah) {
        connections.remove(keycah);
    }

    public static String declare(String library, String classname) throws Exception {
        return ConnectionAssistant.declare(library, classname, true);
    }

    public static String declare(String library, String classname, boolean classpath) throws Exception {
        String keycad = library + "$" + classname;
        if (!drivers.containsKey(keycad)) {
            if (classpath) {
                ConnectionAssistant.declare(keycad, Class.forName(classname));
            } else {
                File file = new File(library);
                URLClassLoader cl = new URLClassLoader(new URL[]{file.toURL()}, ClassLoader.getSystemClassLoader());
                ConnectionAssistant.declare(keycad, Class.forName(classname, true, cl));
            }
        }
        return new String(keycad);
    }

    private static void declare(String keycad, Class c) throws Exception {
        Driver d = (Driver)c.newInstance();
        ConnectionAssistant.declare(keycad, d);
    }

    public static void declare(String keycad, Driver d) throws Exception {
        drivers.put(keycad, d);
    }

    public static Set getDeclarations() {
        return drivers.keySet();
    }

    public static Set getHandlers() {
        return connections.keySet();
    }
}

