/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.MainImpl;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public abstract class CLIHandler {
    private static final int KEY_LENGTH = 10;
    private static final int REPLY_OK = 1;
    private static final int REPLY_EXIT = 2;
    private static final int REPLY_FAIL = 0;
    private static final int REPLY_DELAY = 3;
    private static final int REPLY_READ = 10;
    private static final int REPLY_WRITE = 11;
    private static final int REPLY_AVAILABLE = 12;
    private static final int REPLY_ERROR = 13;
    public static final int WHEN_BOOT = 1;
    public static final int WHEN_INIT = 2;
    public static final int WHEN_EXTRA = 3;
    private static Server server;
    private static final Logger OUTPUT;
    private int when;
    private static List<Execute> doLater;

    protected CLIHandler(int n) {
        this.when = n;
    }

    protected abstract int cli(Args var1);

    protected static void showHelp(PrintWriter printWriter, Collection collection, int n) {
        for (CLIHandler cLIHandler : collection) {
            if (n != -1 && n != cLIHandler.when) continue;
            cLIHandler.usage(printWriter);
        }
    }

    protected abstract void usage(PrintWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterState(int n, Integer n2) {
        Object object;
        if (OUTPUT.isLoggable(Level.FINEST)) {
            object = OUTPUT;
            synchronized (object) {
                OUTPUT.finest("state: " + n + " thread: " + Thread.currentThread());
            }
        }
        if (n2 == null) {
            return;
        }
        object = n2;
        synchronized (object) {
            if (n == n2) {
                if (OUTPUT.isLoggable(Level.FINEST)) {
                    OUTPUT.finest(n + " blocked");
                }
                n2.notifyAll();
                try {
                    n2.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException();
                }
            } else if (OUTPUT.isLoggable(Level.FINEST)) {
                OUTPUT.finest(n + " not blocked");
            }
        }
    }

    private static boolean checkHelp(Args args, Collection collection) {
        String[] stringArray = args.getArguments();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equals("-?") && !stringArray[i].equals("--help") && !stringArray[i].equals("-help")) continue;
            PrintWriter printWriter = new PrintWriter(args.getOutputStream());
            CLIHandler.showHelp(printWriter, collection, -1);
            printWriter.flush();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int notifyHandlers(Args args, Collection collection, int n, boolean bl, boolean bl2) {
        try {
            int n2;
            Object object2;
            int n3 = 0;
            for (Object object2 : collection) {
                if (((CLIHandler)object2).when != n) continue;
                n3 = ((CLIHandler)object2).cli(args);
                if (n3 == 0) continue;
                int n4 = n3;
                return n4;
            }
            object2 = args.getArguments();
            if (bl) {
                object2 = args.getArguments();
                for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                    if (object2[n2] == null) continue;
                    PrintWriter printWriter = new PrintWriter(args.getOutputStream());
                    printWriter.println("Ignored unknown option: " + (String)object2[n2]);
                    printWriter.flush();
                    int n5 = 2;
                    return n5;
                }
            }
            n2 = 0;
            return n2;
        }
        finally {
            args.reset(bl2);
        }
    }

    static Status initialize(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, MainImpl.BootClassLoader bootClassLoader, boolean bl, boolean bl2, Runnable runnable) {
        return CLIHandler.initialize(new Args(stringArray, inputStream, outputStream, outputStream2, System.getProperty("user.dir")), null, bootClassLoader.allCLIs(), bl, bl2, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int registerFinishInstallation(Execute execute) {
        Class<CLIHandler> clazz = CLIHandler.class;
        synchronized (CLIHandler.class) {
            boolean bl;
            if (doLater != null) {
                doLater.add(execute);
                bl = false;
            } else {
                bl = true;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl) {
                return execute.exec();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int finishInitialization(boolean bl) {
        OUTPUT.log(Level.FINER, "finishInitialization {0}", bl);
        Class<CLIHandler> clazz = CLIHandler.class;
        synchronized (CLIHandler.class) {
            List<Execute> list = doLater;
            ArrayList arrayList = doLater = bl ? new ArrayList() : null;
            if (OUTPUT.isLoggable(Level.FINER)) {
                OUTPUT.finer("Notify: " + list);
            }
            if (!bl) {
                CLIHandler.class.notifyAll();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (list != null) {
                for (Execute execute : list) {
                    int n = execute.exec();
                    if (n == 0) continue;
                    return n;
                }
            }
            return 0;
        }
    }

    private static synchronized boolean waitFinishInstallationIsOver(int n) {
        if (doLater != null) {
            try {
                CLIHandler.class.wait((long)n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return doLater == null;
    }

    public static synchronized void stopServer() {
        Server server = CLIHandler.server;
        if (server != null) {
            server.stopServer();
        }
    }

    private static InetAddress localHostAddress() throws IOException {
        NetworkInterface networkInterface = NetworkInterface.getByName("lo");
        if (networkInterface == null || !networkInterface.getInetAddresses().hasMoreElements()) {
            return InetAddress.getLocalHost();
        }
        return networkInterface.getInetAddresses().nextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Status initialize(final Args args, final Integer n, final Collection collection, final boolean bl, boolean bl2, Runnable runnable) {
        int n2 = CLIHandler.notifyHandlers(args, collection, 1, false, bl);
        if (n2 != 0) {
            return new Status(n2);
        }
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            string = System.getProperty("user.home");
            System.setProperty("netbeans.user", string);
        }
        if ("memory".equals(string)) {
            return new Status(0);
        }
        if (runnable != null) {
            runnable.run();
        }
        File file = new File(string, "lock");
        int n3 = 0;
        while (n3 < 5) {
            Object object;
            try {
                if (file.exists()) {
                    CLIHandler.enterState(5, n);
                    throw new IOException("EXISTS");
                }
                if (n3 == 0 && CLIHandler.checkHelp(args, collection)) {
                    return new Status(2);
                }
                file.getParentFile().mkdirs();
                file.createNewFile();
                file.deleteOnExit();
                CLIHandler.secureAccess(file);
                CLIHandler.enterState(10, n);
                final byte[] byArray = new byte[10];
                new Random().nextBytes(byArray);
                server = new Server(byArray, n, collection, bl);
                object = new DataOutputStream(new FileOutputStream(file));
                int n4 = server.getLocalPort();
                ((DataOutputStream)object).writeInt(n4);
                ((DataOutputStream)object).flush();
                CLIHandler.enterState(20, n);
                RequestProcessor.Task task = new RequestProcessor("Secure CLI Port").post(new Runnable((DataOutputStream)object){
                    final /* synthetic */ DataOutputStream val$os;
                    {
                        this.val$os = dataOutputStream;
                    }

                    public void run() {
                        SecureRandom secureRandom = null;
                        CLIHandler.enterState(95, n);
                        try {
                            secureRandom = SecureRandom.getInstance("SHA1PRNG");
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            try {
                                secureRandom = SecureRandom.getInstance("IBMSecureRandom");
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                                server.stopServer();
                            }
                        }
                        CLIHandler.enterState(96, n);
                        if (secureRandom != null) {
                            secureRandom.nextBytes(byArray);
                        }
                        CLIHandler.enterState(97, n);
                        try {
                            this.val$os.write(byArray);
                            this.val$os.flush();
                            CLIHandler.enterState(27, n);
                            byte[] byArray2 = InetAddress.getLocalHost().getAddress();
                            if (n != null && n == 667) {
                                throw new UnknownHostException("dhcppc0");
                            }
                            for (int i = 0; i < byArray2.length; ++i) {
                                this.val$os.write(byArray2[i]);
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            if (!"dhcppc0".equals(unknownHostException.getMessage())) {
                                unknownHostException.printStackTrace();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        try {
                            this.val$os.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                int n5 = CLIHandler.registerFinishInstallation(new Execute(){

                    public int exec() {
                        return CLIHandler.notifyHandlers(args, collection, 2, bl, bl);
                    }

                    public String toString() {
                        return collection.toString();
                    }
                });
                CLIHandler.enterState(0, n);
                return new Status(file, server.getLocalPort(), n5, (Task)task);
            }
            catch (IOException iOException) {
                block70: {
                    Closeable closeable;
                    Object object2;
                    int n6;
                    Object object3;
                    block72: {
                        FilterInputStream filterInputStream;
                        block69: {
                            if (!"EXISTS".equals(iOException.getMessage())) {
                                iOException.printStackTrace();
                            }
                            object = null;
                            object3 = null;
                            n6 = -1;
                            filterInputStream = null;
                            CLIHandler.enterState(21, n);
                            if (OUTPUT.isLoggable(Level.FINER)) {
                                OUTPUT.log(Level.FINER, "Reading lock file {0}", file);
                            }
                            filterInputStream = new DataInputStream(new FileInputStream(file));
                            n6 = ((DataInputStream)filterInputStream).readInt();
                            CLIHandler.enterState(22, n);
                            object = new byte[10];
                            ((DataInputStream)filterInputStream).readFully((byte[])object);
                            CLIHandler.enterState(23, n);
                            object2 = new byte[4];
                            ((DataInputStream)filterInputStream).readFully((byte[])object2);
                            CLIHandler.enterState(24, n);
                            object3 = object2;
                            if (filterInputStream == null) break block69;
                            try {
                                filterInputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        CLIHandler.enterState(25, n);
                        break block72;
                        catch (EOFException eOFException) {
                            block71: {
                                if (n6 != -1) {
                                    CLIHandler.enterState(94, n);
                                    try {
                                        closeable = new Socket(CLIHandler.localHostAddress(), n6);
                                        ((Socket)closeable).close();
                                    }
                                    catch (Exception exception) {
                                        file.delete();
                                        if (filterInputStream != null) {
                                            try {
                                                filterInputStream.close();
                                            }
                                            catch (IOException iOException3) {
                                                // empty catch block
                                            }
                                        }
                                        CLIHandler.enterState(25, n);
                                    }
                                    try {
                                        Thread.sleep(2000L);
                                        break block70;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                    break block70;
                                }
                                if (filterInputStream == null) break block71;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                try {
                                    filterInputStream.close();
                                }
                                catch (IOException iOException4) {
                                    // empty catch block
                                }
                            }
                            CLIHandler.enterState(25, n);
                            break block72;
                            catch (IOException iOException5) {
                                block73: {
                                    CLIHandler.enterState(26, n);
                                    if (filterInputStream == null) break block73;
                                    try {
                                        filterInputStream.close();
                                    }
                                    catch (IOException iOException6) {
                                        // empty catch block
                                    }
                                }
                                CLIHandler.enterState(25, n);
                                break block72;
                            }
                            finally {
                                if (filterInputStream != null) {
                                    try {
                                        filterInputStream.close();
                                    }
                                    catch (IOException iOException7) {}
                                }
                                CLIHandler.enterState(25, n);
                            }
                        }
                    }
                    if (object != null && n6 != -1) {
                        block74: {
                            try {
                                CLIHandler.enterState(28, n);
                                object2 = new Socket(CLIHandler.localHostAddress(), n6);
                                ((Socket)object2).setSoTimeout(5000);
                                closeable = new DataOutputStream(((Socket)object2).getOutputStream());
                                ((FilterOutputStream)closeable).write((byte[])object);
                                ((DataOutputStream)closeable).flush();
                                CLIHandler.enterState(30, n);
                                DataInputStream dataInputStream = new DataInputStream(((Socket)object2).getInputStream());
                                byte[] byArray = new byte[4096];
                                block47: while (true) {
                                    CLIHandler.enterState(32, n);
                                    int n7 = dataInputStream.read();
                                    CLIHandler.enterState(34, n);
                                    switch (n7) {
                                        case 0: {
                                            CLIHandler.enterState(36, n);
                                            break block74;
                                        }
                                        case 1: {
                                            int n8;
                                            CLIHandler.enterState(38, n);
                                            String[] stringArray = args.getArguments();
                                            ((DataOutputStream)closeable).writeInt(stringArray.length);
                                            for (n8 = 0; n8 < stringArray.length; ++n8) {
                                                ((DataOutputStream)closeable).writeUTF(stringArray[n8]);
                                            }
                                            ((DataOutputStream)closeable).writeUTF(args.getCurrentDirectory().toString());
                                            ((DataOutputStream)closeable).flush();
                                            break;
                                        }
                                        case 2: {
                                            int n8 = dataInputStream.readInt();
                                            if (n8 == 0) {
                                                n8 = -1;
                                            }
                                            ((FilterOutputStream)closeable).close();
                                            dataInputStream.close();
                                            CLIHandler.enterState(0, n);
                                            return new Status(file, n6, n8, null);
                                        }
                                        case 10: {
                                            CLIHandler.enterState(42, n);
                                            int n9 = dataInputStream.readInt();
                                            if (n9 > byArray.length) {
                                                byArray = new byte[n9];
                                            }
                                            int n10 = args.getInputStream().read(byArray, 0, n9);
                                            ((DataOutputStream)closeable).write(n10);
                                            if (n10 > 0) {
                                                ((DataOutputStream)closeable).write(byArray, 0, n10);
                                            }
                                            ((DataOutputStream)closeable).flush();
                                            break;
                                        }
                                        case 11: {
                                            CLIHandler.enterState(44, n);
                                            int n9 = dataInputStream.readInt();
                                            if (n9 > byArray.length) {
                                                byArray = new byte[n9];
                                            }
                                            dataInputStream.read(byArray, 0, n9);
                                            args.getOutputStream().write(byArray, 0, n9);
                                            break;
                                        }
                                        case 13: {
                                            CLIHandler.enterState(45, n);
                                            int n9 = dataInputStream.readInt();
                                            if (n9 > byArray.length) {
                                                byArray = new byte[n9];
                                            }
                                            dataInputStream.read(byArray, 0, n9);
                                            args.getErrorStream().write(byArray, 0, n9);
                                            break;
                                        }
                                        case 12: {
                                            CLIHandler.enterState(46, n);
                                            ((DataOutputStream)closeable).writeInt(args.getInputStream().available());
                                            ((DataOutputStream)closeable).flush();
                                            break;
                                        }
                                        case 3: {
                                            CLIHandler.enterState(47, n);
                                            break;
                                        }
                                        case -1: {
                                            CLIHandler.enterState(48, n);
                                            break;
                                        }
                                        default: {
                                            CLIHandler.enterState(49, n);
                                            assert (false) : n7;
                                            continue block47;
                                        }
                                    }
                                }
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                CLIHandler.enterState(33, n);
                            }
                            catch (ConnectException connectException) {
                                CLIHandler.enterState(33, n);
                            }
                            catch (IOException iOException8) {
                                iOException8.printStackTrace();
                                CLIHandler.enterState(33, n);
                            }
                        }
                        boolean bl3 = true;
                        if (object3 != null) {
                            try {
                                bl3 = Arrays.equals(InetAddress.getLocalHost().getAddress(), object3);
                            }
                            catch (UnknownHostException unknownHostException) {
                                CLIHandler.enterState(999, n);
                            }
                        }
                        if (!bl2) {
                            if (!bl3) return new Status(-255);
                        }
                        file.delete();
                    }
                    try {
                        CLIHandler.enterState(83, n);
                        Thread.sleep((int)(Math.random() * 1000.0));
                        CLIHandler.enterState(85, n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++n3;
            }
        }
        return new Status();
    }

    private static void secureAccess(File file) throws IOException {
        Object object;
        boolean bl = false;
        String string = System.getProperty("java.version");
        if (string != null && string.startsWith("1.6")) {
            try {
                object = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
                Object object2 = ((Method)object).invoke((Object)file, Boolean.FALSE, Boolean.FALSE);
                Object object3 = ((Method)object).invoke((Object)file, Boolean.TRUE, Boolean.TRUE);
                bl = Boolean.TRUE.equals(object2) && Boolean.TRUE.equals(object3);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        if (bl) {
            return;
        }
        try {
            int n;
            object = new File("/bin/chmod");
            if (!((File)object).isFile()) {
                object = new File("/usr/bin/chmod");
            }
            if (((File)object).isFile() && (n = Runtime.getRuntime().exec(new String[]{((File)object).getAbsolutePath(), "go-rwx", file.getAbsolutePath()}).waitFor()) != 0) {
                throw new IOException("could not run " + object + " go-rwx " + file);
            }
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new IOException(interruptedException.toString()).initCause(interruptedException);
        }
    }

    static {
        OUTPUT = Logger.getLogger("org.netbeans.CLIHandler");
        doLater = new ArrayList<Execute>();
    }

    private static final class Server
    extends Thread {
        private byte[] key;
        private ServerSocket socket;
        private Integer block;
        private Collection handlers;
        private Socket work;
        private static volatile int counter;
        private final boolean failOnUnknownOptions;
        private static long lastReply;
        private static long failDelay;

        public Server(byte[] byArray, Integer n, Collection collection, boolean bl) throws IOException {
            super("CLI Requests Server");
            this.key = byArray;
            this.setDaemon(true);
            this.block = n;
            this.handlers = collection;
            this.failOnUnknownOptions = bl;
            this.socket = new ServerSocket(0, 50, CLIHandler.localHostAddress());
            this.start();
        }

        public Server(Socket socket, byte[] byArray, Integer n, Collection collection, boolean bl) throws IOException {
            super("CLI Handler Thread Handler: " + ++counter);
            this.key = byArray;
            this.setDaemon(true);
            this.block = n;
            this.handlers = collection;
            this.work = socket;
            this.failOnUnknownOptions = bl;
            this.start();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public void run() {
            if (this.work != null) {
                try {
                    this.handleConnect(this.work);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            ServerSocket serverSocket = this.socket;
            if (serverSocket == null) {
                return;
            }
            while (this.socket != null) {
                try {
                    CLIHandler.enterState(65, this.block);
                    Socket socket = this.socket.accept();
                    if (this.socket == null) {
                        CLIHandler.enterState(66, this.block);
                        socket.getOutputStream().write(0);
                        CLIHandler.enterState(67, this.block);
                        socket.close();
                        continue;
                    }
                    new Server(socket, this.key, this.block, this.handlers, this.failOnUnknownOptions);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.socket == null) continue;
                    interruptedIOException.printStackTrace();
                }
                catch (SocketException socketException) {
                    if (this.socket == null) continue;
                    socketException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        final void stopServer() {
            this.socket = null;
            this.interrupt();
        }

        private void handleConnect(Socket socket) throws IOException {
            byte[] byArray = new byte[this.key.length];
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            CLIHandler.enterState(70, this.block);
            dataInputStream.readFully(byArray);
            CLIHandler.enterState(90, this.block);
            final DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            if (Arrays.equals(byArray, this.key)) {
                while (!CLIHandler.waitFinishInstallationIsOver(2000)) {
                    dataOutputStream.write(3);
                    dataOutputStream.flush();
                }
                CLIHandler.enterState(93, this.block);
                dataOutputStream.write(1);
                dataOutputStream.flush();
                int n = dataInputStream.readInt();
                String[] stringArray = new String[n];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                }
                String string = dataInputStream.readUTF();
                final Args args = new Args(stringArray, new IS(dataInputStream, dataOutputStream), new OS(dataOutputStream, 11), new OS(dataOutputStream, 13), string);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ComputingAndNotifying
                extends Thread {
                    public int res;
                    public boolean finished;

                    public ComputingAndNotifying() {
                        super("Computes values in handlers");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.res = CLIHandler.checkHelp(args, Server.this.handlers) ? 2 : CLIHandler.notifyHandlers(args, Server.this.handlers, 2, Server.this.failOnUnknownOptions, false);
                            if (this.res == 0) {
                                CLIHandler.enterState(98, Server.this.block);
                            } else {
                                CLIHandler.enterState(99, Server.this.block);
                            }
                        }
                        finally {
                            ComputingAndNotifying computingAndNotifying = this;
                            synchronized (computingAndNotifying) {
                                this.finished = true;
                                this.notifyAll();
                            }
                        }
                    }

                    public synchronized void waitForResultAndNotifyOthers() {
                        this.start();
                        while (!this.finished) {
                            try {
                                this.wait(1000L);
                                dataOutputStream.write(3);
                                dataOutputStream.flush();
                            }
                            catch (SocketException socketException) {
                                if (Server.isClosedSocket(socketException)) {
                                    args.close();
                                    this.interrupt();
                                    continue;
                                }
                                socketException.printStackTrace();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
                ComputingAndNotifying computingAndNotifying = new ComputingAndNotifying();
                computingAndNotifying.waitForResultAndNotifyOthers();
                try {
                    dataOutputStream.write(2);
                    dataOutputStream.writeInt(computingAndNotifying.res);
                }
                catch (SocketException socketException) {
                    if (Server.isClosedSocket(socketException)) {
                        args.close();
                        computingAndNotifying.interrupt();
                    }
                    throw socketException;
                }
            } else {
                CLIHandler.enterState(103, this.block);
                long l = lastReply + failDelay - System.currentTimeMillis();
                if (l > 0L) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    failDelay *= 2L;
                } else {
                    failDelay = 100L;
                }
                lastReply = System.currentTimeMillis();
                dataOutputStream.write(0);
            }
            CLIHandler.enterState(120, this.block);
            dataOutputStream.close();
            dataInputStream.close();
        }

        static final boolean isClosedSocket(SocketException socketException) {
            if (socketException.getMessage().equals("Broken pipe")) {
                return true;
            }
            return socketException.getMessage().startsWith("Connection reset by peer");
        }

        static {
            failDelay = 100L;
        }

        private static final class OS
        extends OutputStream {
            private DataOutputStream os;
            private int type;

            public OS(DataOutputStream dataOutputStream, int n) {
                this.os = dataOutputStream;
                this.type = n;
            }

            public void write(int n) throws IOException {
                byte[] byArray = new byte[]{(byte)n};
                this.write(byArray);
            }

            public void write(byte[] byArray) throws IOException {
                this.write(byArray, 0, byArray.length);
            }

            public void close() throws IOException {
                super.close();
            }

            public void flush() throws IOException {
                this.os.flush();
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.os.write(this.type);
                this.os.writeInt(n2);
                this.os.write(byArray, n, n2);
            }
        }

        private static final class IS
        extends InputStream {
            private DataInputStream is;
            private DataOutputStream os;

            public IS(DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
                this.is = dataInputStream;
                this.os = dataOutputStream;
            }

            public int read() throws IOException {
                byte[] byArray = new byte[1];
                if (this.read(byArray) == 1) {
                    return byArray[0];
                }
                return -1;
            }

            public void close() throws IOException {
                super.close();
            }

            public int available() throws IOException {
                this.os.write(12);
                this.os.flush();
                return this.is.readInt();
            }

            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                this.os.write(10);
                this.os.writeInt(n2);
                this.os.flush();
                int n3 = this.is.read();
                if (n3 > 0) {
                    return this.is.read(byArray, n, n3);
                }
                return n3;
            }
        }
    }

    public static final class Args {
        private String[] args;
        private final String[] argsBackup;
        private InputStream is;
        private OutputStream os;
        private OutputStream err;
        private File currentDir;
        private boolean closed;

        Args(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, String string) {
            this.argsBackup = stringArray;
            this.reset(false);
            this.is = inputStream;
            this.os = outputStream;
            this.err = outputStream2;
            this.currentDir = new File(string);
        }

        void reset(boolean bl) {
            if (bl) {
                String[] stringArray = this.args;
                if (stringArray == null) {
                    stringArray = this.argsBackup;
                }
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                arrayList.removeAll(Collections.singleton(null));
                this.args = arrayList.toArray(new String[arrayList.size()]);
            } else {
                this.args = (String[])this.argsBackup.clone();
            }
        }

        final void close() {
            this.closed = true;
        }

        public String[] getArguments() {
            return this.args;
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public OutputStream getErrorStream() {
            return this.err;
        }

        public File getCurrentDirectory() {
            return this.currentDir;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public boolean isOpen() {
            return !this.closed;
        }
    }

    static interface Execute {
        public int exec();
    }

    static final class Status {
        public static final int CANNOT_CONNECT = -255;
        private final File lockFile;
        private final int port;
        private int exitCode;
        private Task parael;

        Status() {
            this(0);
        }

        Status(int n) {
            this(null, 0, n, null);
        }

        Status(File file, int n, int n2, Task task) {
            this.lockFile = file;
            this.port = n;
            this.exitCode = n2;
            this.parael = task;
        }

        private void waitFinished() {
            if (this.parael != null) {
                this.parael.waitFinished();
            }
        }

        public File getLockFile() {
            this.waitFinished();
            return this.lockFile;
        }

        public int getServerPort() {
            return this.port;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

