/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.background;

import com.jaspersoft.ireport.addons.background.BackgroundImageAction;
import com.jaspersoft.ireport.addons.background.BackgroundImageLayer;
import com.jaspersoft.ireport.addons.background.BackgroundImageUtilities;
import com.jaspersoft.ireport.addons.background.ShowBackgroundImageAction;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class DeleteBackgroundImageAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
                ReportObjectScene scene = view.getReportDesignerPanel().getScene();
                BackgroundImageLayer layer = BackgroundImageUtilities.getBackgroundImageLayer(view, false);
                JasperDesign jd = view.getModel().getJasperDesign();
                jd.removeProperty("ireport.background.image");
                jd.removeProperty("ireport.background.image.properties");
                if (layer != null) {
                    layer.removeChildren();
                    scene.validate();
                    scene.revalidate(true);
                }
                ((ShowBackgroundImageAction)SystemAction.get(ShowBackgroundImageAction.class)).resultChanged(null);
                DeleteBackgroundImageAction.this.firePropertyChange("enabled", true, false);
                IReportManager.getInstance().notifyReportChange();
                BackgroundImageUtilities.notifyBackgroundOptionsChange();
                DeleteBackgroundImageAction.this.setEnabled(false);
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(BackgroundImageAction.class, (String)"CTL_DeleteBackgroundImageAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return IReportManager.getInstance().getActiveReport() != null && IReportManager.getInstance().getActiveVisualView() != null && IReportManager.getInstance().getActiveReport().getProperty("ireport.background.image") != null;
    }
}

