/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.background;

import com.jaspersoft.ireport.addons.background.BackgroundImageLayer;
import com.jaspersoft.ireport.addons.background.BackgroundImageWidget;
import com.jaspersoft.ireport.addons.background.ShowBackgroundImageAction;
import com.jaspersoft.ireport.addons.background.TransformBackgroundImageAction;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.actions.SystemAction;

public class BackgroundImageUtilities {
    public static void notifyBackgroundOptionsChange() {
        ((ShowBackgroundImageAction)SystemAction.get(ShowBackgroundImageAction.class)).resultChanged(null);
        ((TransformBackgroundImageAction)SystemAction.get(TransformBackgroundImageAction.class)).resultChanged(null);
    }

    public static BackgroundImageLayer getBackgroundImageLayer(JrxmlVisualView view, boolean create) {
        ReportObjectScene scene = view.getReportDesignerPanel().getScene();
        BackgroundImageLayer layer = null;
        for (Widget w : scene.getChildren()) {
            if (!(w instanceof BackgroundImageLayer)) continue;
            layer = (BackgroundImageLayer)w;
            break;
        }
        if (layer == null && create) {
            int index = scene.getChildren().indexOf(scene.getPageLayer());
            layer = new BackgroundImageLayer((Scene)scene);
            scene.addChild(index + 1, (Widget)layer);
            scene.validate();
        }
        return layer;
    }

    public static BackgroundImageWidget getBackgroundImageWidget(JrxmlVisualView view) {
        BackgroundImageLayer layer = BackgroundImageUtilities.getBackgroundImageLayer(view, false);
        if (layer == null) {
            return null;
        }
        for (Widget w : layer.getChildren()) {
            if (!(w instanceof BackgroundImageWidget)) continue;
            return (BackgroundImageWidget)w;
        }
        return null;
    }

    public static BackgroundImageWidget createImageWidget(Scene scene, File file) throws Exception {
        BackgroundImageWidget img = new BackgroundImageWidget(scene, new ImageIcon(file.getPath()));
        if (img.getImg().getImageLoadStatus() == 4) {
            throw new Exception("Error loading image");
        }
        return img;
    }

    public static void restore(final JrxmlVisualView view) {
        String s;
        File file;
        JasperDesign jd = view.getEditorSupport().getCurrentModel();
        if (jd.getProperty("ireport.background.image") != null && (file = new File(s = jd.getProperty("ireport.background.image"))).exists()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ReportObjectScene scene = view.getReportDesignerPanel().getScene();
                        BackgroundImageLayer layer = BackgroundImageUtilities.getBackgroundImageLayer(view, true);
                        layer.removeChildren();
                        layer.addChild(BackgroundImageUtilities.createImageWidget((Scene)scene, file));
                        scene.validate();
                        scene.revalidate(true);
                        BackgroundImageUtilities.notifyBackgroundOptionsChange();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }
}

