/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.background;

import com.jaspersoft.ireport.addons.background.BackgroundImageLayer;
import com.jaspersoft.ireport.addons.background.BackgroundImageUtilities;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class BackgroundImageAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(NbBundle.getMessage(BackgroundImageAction.class, (String)"select.image.file"));
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jpg") || file.isDirectory() || filename.toLowerCase().endsWith(".png") || filename.toLowerCase().endsWith(".gif");
            }

            public String getDescription() {
                return "Image file (.jpg,.png,.gif)";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(Misc.getMainFrame()) == 0) {
            final File file = jfc.getSelectedFile();
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
                        ReportObjectScene scene = view.getReportDesignerPanel().getScene();
                        BackgroundImageLayer layer = BackgroundImageUtilities.getBackgroundImageLayer(view, true);
                        layer.removeChildren();
                        JasperDesign jd = view.getModel().getJasperDesign();
                        jd.removeProperty("ireport.background.image");
                        jd.removeProperty("ireport.background.image.properties");
                        IReportManager.getInstance().notifyReportChange();
                        try {
                            layer.addChild(BackgroundImageUtilities.createImageWidget((Scene)scene, file));
                            jd.setProperty("ireport.background.image", file.getPath());
                            scene.validate();
                            scene.revalidate(true);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(Misc.getMainFrame(), "The image format is not supported.", "Error", 0);
                        }
                        BackgroundImageUtilities.notifyBackgroundOptionsChange();
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(BackgroundImageAction.class, (String)"CTL_BackgroundImageAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return IReportManager.getInstance().getActiveReport() != null && IReportManager.getInstance().getActiveVisualView() != null;
    }
}

