/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.output.CanvasProvider;

public class Canvas {
    private CanvasProvider canvasImp;

    public Canvas(CanvasProvider canvasImp) {
        this.canvasImp = canvasImp;
    }

    public CanvasProvider getCanvasImp() {
        return this.canvasImp;
    }

    public void establishDimensions(BarcodeDimension dim) {
        this.getCanvasImp().establishDimensions(dim);
    }

    public int getOrientation() {
        return this.getCanvasImp().getOrientation();
    }

    public void drawRect(double x1, double y1, double x2, double y2) {
        this.drawRectWH(x1, y1, x2 - x1, y2 - y1);
    }

    public void drawRectWH(double x, double y, double w, double h) {
        this.getCanvasImp().deviceFillRect(x, y, w, h);
    }

    public void drawCenteredChar(char ch, double x1, double x2, double y1, String fontName, double fontSize) {
        this.drawCenteredText(new Character(ch).toString(), x1, x2, y1, fontName, fontSize);
    }

    public void drawJustifiedText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.drawText(text, x1, x2, y1, fontName, fontSize, TextAlignment.TA_JUSTIFY);
    }

    public void drawCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.drawText(text, x1, x2, y1, fontName, fontSize, TextAlignment.TA_CENTER);
    }

    public void drawText(String text, double x1, double x2, double y1, String fontName, double fontSize, TextAlignment textAlign) {
        this.getCanvasImp().deviceText(text, x1, x2, y1, fontName, fontSize, textAlign);
    }
}

