/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.fourstate.AbstractFourStateLogicImpl;

public class USPSIntelligentMailLogicImpl
extends AbstractFourStateLogicImpl {
    static final char[] TABLE5OF13 = new char[1287];
    static final char[] TABLE2OF13 = new char[78];
    static final BarToCharacterMapping[] TABLE_BAR_TO_CHARACTER = new BarToCharacterMapping[65];
    private static final String BAR_TO_CHARACTER_TABLE_FILENAME = "usps-4bc-bar-to-character-table.csv";
    private static final int GENERATOR_POLYNOMIAL = 3893;
    private static final int ELEVEN_BITS = 2047;
    static /* synthetic */ Class class$org$krysalis$barcode4j$impl$fourstate$USPSIntelligentMailLogicImpl;

    public USPSIntelligentMailLogicImpl() {
        super(ChecksumMode.CP_AUTO);
    }

    private static int reverseUnsignedShort(int input) {
        int reverse = 0;
        for (int i = 0; i < 16; ++i) {
            reverse <<= 1;
            reverse |= input & 1;
            input >>= 1;
        }
        return reverse;
    }

    private static void initializeNof13Table(char[] tableNof13, int n, int tableLength) {
        int lutLowerIndex = 0;
        int lutUpperIndex = tableLength - 1;
        for (int count = 0; count < 8192; ++count) {
            int reverse;
            int bitCount = 0;
            for (int bitIndex = 0; bitIndex < 13; ++bitIndex) {
                if ((count & 1 << bitIndex) == 0) continue;
                ++bitCount;
            }
            if (bitCount != n || (reverse = USPSIntelligentMailLogicImpl.reverseUnsignedShort(count) >> 3) < count) continue;
            if (count == reverse) {
                tableNof13[lutUpperIndex] = (char)count;
                --lutUpperIndex;
                continue;
            }
            tableNof13[lutLowerIndex] = (char)count;
            tableNof13[++lutLowerIndex] = (char)reverse;
            ++lutLowerIndex;
        }
        if (lutLowerIndex != lutUpperIndex + 1) {
            throw new IllegalStateException("lookup table indices didn't meet properly!");
        }
    }

    private static void initializeBarToCharacterTable() {
        InputStream in = (class$org$krysalis$barcode4j$impl$fourstate$USPSIntelligentMailLogicImpl == null ? (class$org$krysalis$barcode4j$impl$fourstate$USPSIntelligentMailLogicImpl = USPSIntelligentMailLogicImpl.class$("org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMailLogicImpl")) : class$org$krysalis$barcode4j$impl$fourstate$USPSIntelligentMailLogicImpl).getResourceAsStream(BAR_TO_CHARACTER_TABLE_FILENAME);
        if (in == null) {
            throw new MissingResourceException("Resource usps-4bc-bar-to-character-table.csv not found!", null, null);
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            int idx = 0;
            while ((line = reader.readLine()) != null) {
                USPSIntelligentMailLogicImpl.TABLE_BAR_TO_CHARACTER[idx] = new BarToCharacterMapping(idx, line);
                ++idx;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not initialize constant due to I/O error: " + ioe.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
    }

    public char calcChecksum(String msg) {
        return '\u0000';
    }

    /*
     * WARNING - void declaration
     */
    static BigInteger convertToBinary(String msg) {
        void var3_3;
        if (msg.length() > 31) {
            throw new IllegalArgumentException("Message must not be longer than 31 digits");
        }
        String routingCode = msg.substring(20);
        int routingLength = routingCode.length();
        switch (routingLength) {
            case 0: {
                BigInteger routingBig = BigInteger.ZERO;
                break;
            }
            case 5: {
                BigInteger routingBig = new BigInteger(routingCode);
                routingBig = routingBig.add(BigInteger.ONE);
                break;
            }
            case 9: {
                BigInteger routingBig = new BigInteger(routingCode);
                routingBig = routingBig.add(BigInteger.valueOf(100001L));
                break;
            }
            case 11: {
                BigInteger routingBig = new BigInteger(routingCode);
                routingBig = routingBig.add(BigInteger.valueOf(1000100001L));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length for the routing code. Expected 0, 5, 9 or 11 but got " + routingLength);
            }
        }
        BigInteger binary = var3_3;
        BigInteger five = BigInteger.valueOf(5L);
        BigInteger ten = BigInteger.valueOf(10L);
        String trackingCode = msg.substring(0, 20);
        binary = binary.multiply(ten);
        binary = binary.add(new BigInteger(trackingCode.substring(0, 1)));
        binary = binary.multiply(five);
        binary = binary.add(new BigInteger(trackingCode.substring(1, 2)));
        for (int i = 2; i < 20; ++i) {
            binary = binary.multiply(ten);
            binary = binary.add(new BigInteger(trackingCode.substring(i, i + 1)));
        }
        return binary;
    }

    static byte[] to13ByteArray(BigInteger binary) {
        byte[] result = new byte[13];
        byte[] bin = binary.toByteArray();
        System.arraycopy(bin, 0, result, 13 - bin.length, bin.length);
        return result;
    }

    static int calcFCS(byte[] binary) {
        int frameCheckSequence = 2047;
        for (int byteIndex = 0; byteIndex < 13; ++byteIndex) {
            int data;
            int startBit;
            if (byteIndex == 0) {
                startBit = 2;
                data = binary[0] << 5;
            } else {
                startBit = 0;
                data = binary[byteIndex] << 3;
            }
            for (int bit = startBit; bit < 8; ++bit) {
                frameCheckSequence = ((frameCheckSequence ^ data) & 0x400) != 0 ? frameCheckSequence << 1 ^ 0xF35 : (frameCheckSequence <<= 1);
                frameCheckSequence &= 0x7FF;
                data <<= 1;
            }
        }
        return frameCheckSequence;
    }

    static int[] convertToCodewords(BigInteger binary) {
        int[] codewords = new int[10];
        BigInteger[] quotRem = binary.divideAndRemainder(BigInteger.valueOf(636L));
        codewords[9] = quotRem[1].intValue();
        binary = quotRem[0];
        BigInteger const1365 = BigInteger.valueOf(1365L);
        for (int i = 8; i >= 1; --i) {
            quotRem = binary.divideAndRemainder(const1365);
            codewords[i] = quotRem[1].intValue();
            binary = quotRem[0];
        }
        codewords[0] = binary.intValue();
        return codewords;
    }

    static int[] modifyCodewords(int[] codewords, int fcs) {
        int[] modified = new int[10];
        modified[9] = codewords[9] * 2;
        System.arraycopy(codewords, 1, modified, 1, 8);
        modified[0] = (fcs & 0x400) != 0 ? codewords[0] + 659 : codewords[0];
        return modified;
    }

    static char[] convertToCharacters(int[] codewords, int fcs) {
        int c = codewords.length;
        char[] chars = new char[c];
        for (int i = 0; i < c; ++i) {
            int codeword = codewords[i];
            chars[i] = codeword < TABLE5OF13.length ? TABLE5OF13[codeword] : TABLE2OF13[codeword - TABLE5OF13.length];
            if ((fcs & 1 << i) == 0) continue;
            chars[i] = (char)(~chars[i] & 0x1FFF);
        }
        return chars;
    }

    static String convertToBars(char[] chars) {
        StringBuffer bars = new StringBuffer(65);
        bars.setLength(65);
        for (int i = 0; i < bars.length(); ++i) {
            BarToCharacterMapping mapping = TABLE_BAR_TO_CHARACTER[i];
            int resultBits = 0;
            char c = chars[mapping.ascChar];
            if ((c & mapping.ascBitMap) != 0) {
                resultBits |= 1;
            }
            if (((c = chars[mapping.descChar]) & mapping.descBitMap) != 0) {
                resultBits |= 2;
            }
            bars.setCharAt(i, (char)(resultBits + 48));
        }
        return bars.toString();
    }

    protected String[] encodeHighLevel(String msg) {
        BigInteger binary = USPSIntelligentMailLogicImpl.convertToBinary(msg);
        int fcs = USPSIntelligentMailLogicImpl.calcFCS(USPSIntelligentMailLogicImpl.to13ByteArray(binary));
        int[] codewords = USPSIntelligentMailLogicImpl.convertToCodewords(binary);
        int[] modified = USPSIntelligentMailLogicImpl.modifyCodewords(codewords, fcs);
        char[] chars = USPSIntelligentMailLogicImpl.convertToCharacters(modified, fcs);
        String bars = USPSIntelligentMailLogicImpl.convertToBars(chars);
        return new String[]{bars};
    }

    protected String normalizeMessage(String msg) {
        StringBuffer sb = new StringBuffer(msg.length());
        int c = msg.length();
        for (int i = 0; i < c; ++i) {
            char ch = msg.charAt(i);
            if (!Character.isDigit(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String normalizedMsg = this.normalizeMessage(msg);
        String[] encodedMsg = this.encodeHighLevel(normalizedMsg);
        logic.startBarcode(msg, normalizedMsg);
        String codeword = encodedMsg[0];
        int count = codeword.length();
        for (int i = 0; i < count; ++i) {
            int height = Integer.parseInt(codeword.substring(i, i + 1));
            logic.addBar(true, height);
        }
        logic.endBarcode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        USPSIntelligentMailLogicImpl.initializeNof13Table(TABLE5OF13, 5, TABLE5OF13.length);
        USPSIntelligentMailLogicImpl.initializeNof13Table(TABLE2OF13, 2, TABLE2OF13.length);
        USPSIntelligentMailLogicImpl.initializeBarToCharacterTable();
    }

    private static final class BarToCharacterMapping {
        private int descChar;
        private int descBitMap;
        private int ascChar;
        private int ascBitMap;

        private BarToCharacterMapping(int index, String line) {
            StringTokenizer tokenizer = new StringTokenizer(line, ";");
            if (Integer.parseInt(tokenizer.nextToken()) != index + 1) {
                throw new IllegalStateException("Encountered the wrong line number");
            }
            this.descChar = tokenizer.nextToken().charAt(0) - 65;
            this.descBitMap = 1 << Integer.parseInt(tokenizer.nextToken());
            this.ascChar = tokenizer.nextToken().charAt(0) - 65;
            this.ascBitMap = 1 << Integer.parseInt(tokenizer.nextToken());
        }
    }
}

