/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;

public abstract class TextElementConverter
extends ElementConverter {
    protected void copyTextElement(ReportConverter reportConverter, JRTextElement textElement, JRBasePrintText printText) {
        this.copyElement(reportConverter, textElement, printText);
        printText.copyBox(textElement.getLineBox());
        printText.setBold(textElement.isOwnBold());
        printText.setFontName(textElement.getOwnFontName());
        printText.setFontSize(textElement.getOwnFontSize());
        printText.setHorizontalAlignment(textElement.getOwnHorizontalAlignment());
        printText.setItalic(textElement.isOwnItalic());
        printText.setLineSpacing(textElement.getOwnLineSpacing());
        printText.setPdfEmbedded(textElement.isOwnPdfEmbedded());
        printText.setPdfEncoding(textElement.getOwnPdfEncoding());
        printText.setPdfFontName(textElement.getOwnPdfFontName());
        printText.setReportFont(textElement.getReportFont());
        printText.setRotation(textElement.getOwnRotation());
        printText.setStrikeThrough(textElement.isOwnStrikeThrough());
        printText.setMarkup(textElement.getOwnMarkup());
        printText.setUnderline(textElement.isOwnUnderline());
        printText.setVerticalAlignment(textElement.getOwnVerticalAlignment());
    }

    public static void measureTextElement(JRPrintText printText) {
        JRStyledText styledText;
        JRMeasuredText measuredText;
        String text = printText.getText();
        JRTextMeasurer textMeasurer = JRTextMeasurerUtil.createTextMeasurer(printText);
        if (text == null) {
            text = "";
        }
        printText.setTextHeight((measuredText = textMeasurer.measure(styledText = JRStyledTextParser.getInstance().getStyledText(JRStyledTextAttributeSelector.NO_BACKCOLOR.getStyledTextAttributes(printText), text, "styled".equals(printText.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(printText)), 0, 0, false)).getTextHeight() < (float)printText.getHeight() ? measuredText.getTextHeight() : (float)printText.getHeight());
        printText.setLeadingOffset(measuredText.getLeadingOffset());
        printText.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        int textEnd = measuredText.getTextOffset();
        String printedText = "styled".equals(printText.getMarkup()) ? JRStyledTextParser.getInstance().write(styledText, 0, textEnd) : text.substring(0, textEnd);
        printText.setText(printedText);
    }
}

