/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.fold;

import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyTransactionImpl;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.SpiPackageAccessor;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;

public final class FoldOperation {
    private static boolean spiPackageAccessorRegistered;
    private final FoldOperationImpl impl;

    private static void ensureSpiAccessorRegistered() {
        if (!spiPackageAccessorRegistered) {
            spiPackageAccessorRegistered = true;
            SpiPackageAccessor.register(new SpiPackageAccessorImpl());
        }
    }

    private FoldOperation(FoldOperationImpl foldOperationImpl) {
        this.impl = foldOperationImpl;
    }

    public Fold addToHierarchy(FoldType foldType, String string, boolean bl, int n, int n2, int n3, int n4, Object object, FoldHierarchyTransaction foldHierarchyTransaction) throws BadLocationException {
        Fold fold = this.impl.createFold(foldType, string, bl, n, n2, n3, n4, object);
        this.impl.addToHierarchy(fold, foldHierarchyTransaction.getImpl());
        return fold;
    }

    public static boolean isBoundsValid(int n, int n2, int n3, int n4) {
        return n < n2 && n3 >= 0 && n4 >= 0 && n + n3 <= n2 - n4;
    }

    public void removeFromHierarchy(Fold fold, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.impl.removeFromHierarchy(fold, foldHierarchyTransaction.getImpl());
    }

    public boolean owns(Fold fold) {
        return ApiPackageAccessor.get().foldGetOperation(fold) == this.impl;
    }

    public Object getExtraInfo(Fold fold) {
        return this.impl.getExtraInfo(fold);
    }

    public boolean isStartDamaged(Fold fold) {
        return this.impl.isStartDamaged(fold);
    }

    public boolean isEndDamaged(Fold fold) {
        return this.impl.isEndDamaged(fold);
    }

    public FoldHierarchyTransaction openTransaction() {
        return this.impl.openTransaction().getTransaction();
    }

    public boolean isAddedOrBlocked(Fold fold) {
        return this.impl.isAddedOrBlocked(fold);
    }

    public boolean isBlocked(Fold fold) {
        return this.impl.isBlocked(fold);
    }

    public FoldHierarchy getHierarchy() {
        return this.impl.getHierarchy();
    }

    public boolean isReleased() {
        return this.impl.isReleased();
    }

    static {
        FoldOperation.ensureSpiAccessorRegistered();
    }

    private static final class SpiPackageAccessorImpl
    extends SpiPackageAccessor {
        private SpiPackageAccessorImpl() {
        }

        public FoldHierarchyTransaction createFoldHierarchyTransaction(FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
            return new FoldHierarchyTransaction(foldHierarchyTransactionImpl);
        }

        public FoldHierarchyTransactionImpl getImpl(FoldHierarchyTransaction foldHierarchyTransaction) {
            return foldHierarchyTransaction.getImpl();
        }

        public FoldOperation createFoldOperation(FoldOperationImpl foldOperationImpl) {
            return new FoldOperation(foldOperationImpl);
        }
    }
}

