/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import org.netbeans.api.editor.fold.Fold;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;

public final class FoldChildren
extends GapList {
    private static final int INITIAL_INDEX_GAP_LENGTH = 0x3FFFFFFF;
    Fold parent;
    private int indexGapIndex;
    private int indexGapLength;

    public FoldChildren(Fold fold) {
        this.parent = fold;
        this.indexGapLength = 0x3FFFFFFF;
    }

    public int getFoldCount() {
        return this.size();
    }

    public Fold getFold(int n) {
        return (Fold)this.get(n);
    }

    public int getFoldIndex(Fold fold) {
        int n = this.getTranslatedFoldIndex(ApiPackageAccessor.get().foldGetRawIndex(fold));
        if (n < 0 || n >= this.getFoldCount() || this.getFold(n) != fold) {
            n = -1;
        }
        return n;
    }

    public Fold[] foldsToArray(int n, int n2) {
        Object[] objectArray = new Fold[n2];
        this.copyElements(n, n + n2, objectArray, 0);
        return objectArray;
    }

    public void insert(int n, Fold fold) {
        this.moveIndexGap(n);
        this.insertImpl(n, fold);
    }

    public void insert(int n, Fold[] foldArray) {
        this.moveIndexGap(n);
        this.insertImpl(n, foldArray);
    }

    public void remove(int n, int n2) {
        this.moveIndexGap(n + n2);
        for (int i = n + n2 - 1; i >= n; --i) {
            ApiPackageAccessor.get().foldSetParent(this.getFold(i), null);
        }
        super.remove(n, n2);
        this.indexGapLength += n2;
        this.indexGapIndex -= n2;
    }

    public FoldChildren extractToChildren(int n, int n2, Fold fold) {
        FoldChildren foldChildren = new FoldChildren(fold);
        if (n2 == 1) {
            Fold fold2 = this.getFold(n);
            this.remove(n, n2);
            foldChildren.insert(0, fold2);
        } else {
            Fold[] foldArray = this.foldsToArray(n, n2);
            this.remove(n, n2);
            foldChildren.insert(0, foldArray);
        }
        this.insertImpl(n, fold);
        return foldChildren;
    }

    public void replaceByChildren(int n, FoldChildren foldChildren) {
        this.remove(n, 1);
        if (foldChildren != null) {
            int n2 = foldChildren.getFoldCount();
            this.insertImpl(n, foldChildren, 0, n2);
        }
    }

    private void insertImpl(int n, FoldChildren foldChildren, int n2, int n3) {
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                this.insertImpl(n, foldChildren.getFold(n2));
                break;
            }
            default: {
                Fold[] foldArray = foldChildren.foldsToArray(n2, n3);
                this.insertImpl(n, foldArray);
            }
        }
    }

    private void insertImpl(int n, Fold fold) {
        --this.indexGapLength;
        ++this.indexGapIndex;
        ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
        apiPackageAccessor.foldSetRawIndex(fold, n);
        apiPackageAccessor.foldSetParent(fold, this.parent);
        this.add(n, fold);
    }

    private void insertImpl(int n, Fold[] foldArray) {
        ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
        int n2 = foldArray.length;
        this.indexGapLength -= n2;
        this.indexGapIndex += n2;
        for (int i = n2 - 1; i >= 0; --i) {
            Fold fold = foldArray[i];
            apiPackageAccessor.foldSetRawIndex(fold, n + i);
            apiPackageAccessor.foldSetParent(fold, this.parent);
        }
        this.addArray(n, foldArray);
    }

    private int getTranslatedFoldIndex(int n) {
        if (n >= this.indexGapLength) {
            n -= this.indexGapLength;
        }
        return n;
    }

    private void moveIndexGap(int n) {
        if (n != this.indexGapIndex) {
            ApiPackageAccessor apiPackageAccessor = ApiPackageAccessor.get();
            int n2 = this.indexGapLength;
            if (n < this.indexGapIndex) {
                for (int i = this.indexGapIndex - 1; i >= n; --i) {
                    apiPackageAccessor.foldUpdateRawIndex(this.getFold(i), n2);
                }
            } else {
                for (int i = this.indexGapIndex; i < n; ++i) {
                    apiPackageAccessor.foldUpdateRawIndex(this.getFold(i), -n2);
                }
            }
            this.indexGapIndex = n;
        }
    }
}

