/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.event.WeakEventListenerList;

public abstract class AbstractHighlighter
implements Highlighter {
    private transient ChangeEvent changeEvent;
    protected WeakEventListenerList listenerList = new WeakEventListenerList();
    private HighlightPredicate predicate;

    public AbstractHighlighter() {
        this(null);
    }

    public AbstractHighlighter(HighlightPredicate predicate) {
        this.setHighlightPredicate(predicate);
    }

    public void setHighlightPredicate(HighlightPredicate predicate) {
        this.predicate = predicate != null ? predicate : HighlightPredicate.ALWAYS;
        this.fireStateChanged();
    }

    public HighlightPredicate getHighlightPredicate() {
        return this.predicate;
    }

    public Component highlight(Component component, ComponentAdapter adapter) {
        if (this.getHighlightPredicate().isHighlighted(component, adapter)) {
            component = this.doHighlight(component, adapter);
        }
        return component;
    }

    protected abstract Component doHighlight(Component var1, ComponentAdapter var2);

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public final ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected final void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

