/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.io.IOException;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.Sequence;

public class Compositor
extends AXIComponent {
    private CompositorType type;
    private String minOccurs;
    private String maxOccurs;
    public static final String PROP_COMPOSITOR = "compositor";
    public static final String PROP_MINOCCURS = "minOccurs";
    public static final String PROP_MAXOCCURS = "maxOccurs";
    public static final String PROP_TYPE = "type";

    Compositor(AXIModel aXIModel, CompositorType compositorType) {
        super(aXIModel);
        this.type = compositorType;
    }

    Compositor(AXIModel aXIModel, SchemaComponent schemaComponent) {
        super(aXIModel, schemaComponent);
        if (schemaComponent instanceof Sequence) {
            this.type = CompositorType.SEQUENCE;
        }
        if (schemaComponent instanceof Choice) {
            this.type = CompositorType.CHOICE;
        }
        if (schemaComponent instanceof All) {
            this.type = CompositorType.ALL;
        }
    }

    public Compositor(AXIModel aXIModel, AXIComponent aXIComponent) {
        super(aXIModel, aXIComponent);
    }

    public void accept(AXIVisitor aXIVisitor) {
        aXIVisitor.visit(this);
    }

    public CompositorType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(CompositorType compositorType) {
        if (this.getModel() == null) {
            return;
        }
        this.getModel().startTransaction();
        try {
            this.firePropertyChangeEvent(PROP_TYPE, (Object)this.getType(), (Object)compositorType);
        }
        finally {
            this.getModel().endTransaction();
            try {
                ((AXIModelImpl)this.getModel()).setForceSync(true);
                this.getModel().sync();
            }
            catch (IOException iOException) {
            }
            finally {
                if (this.getModel() != null) {
                    ((AXIModelImpl)this.getModel()).setForceSync(false);
                }
            }
        }
    }

    void setCompositorType(CompositorType compositorType) {
        this.type = compositorType;
    }

    public String getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(String string) {
        String string2 = this.getMinOccurs();
        if (string2 == null && string == null || string2 != null && string2.equals(string)) {
            return;
        }
        this.minOccurs = string;
        this.firePropertyChangeEvent(PROP_MINOCCURS, string2, string);
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(String string) {
        String string2 = this.getMaxOccurs();
        if (string2 == null && string == null || string2 != null && string2.equals(string)) {
            return;
        }
        this.maxOccurs = string;
        this.firePropertyChangeEvent(PROP_MAXOCCURS, string2, string);
    }

    public void addCompositor(Compositor compositor) {
        this.appendChild(PROP_COMPOSITOR, compositor);
    }

    public void removeCompositor(Compositor compositor) {
        this.removeChild(PROP_COMPOSITOR, compositor);
    }

    public void addElement(Element element) {
        this.appendChild("element", element);
    }

    public void removeElement(Element element) {
        this.removeChild("element", element);
    }

    public boolean allowsFullMultiplicity() {
        return !(this.getParent() instanceof Compositor) || ((Compositor)this.getParent()).getType() != CompositorType.ALL;
    }

    public String toString() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompositorType {
        SEQUENCE,
        CHOICE,
        ALL;


        public String getName() {
            return this.toString();
        }

        public String toString() {
            String string = super.toString();
            return string.substring(0, 1) + string.substring(1).toLowerCase();
        }
    }
}

