/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.editor.macros.storage.ui.MacrosModel;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacrosKeymapManager
extends KeymapManager {
    private MacrosModel model = null;
    private Map<String, Set<ShortcutAction>> macroActionsMap = null;
    private Map<ShortcutAction, Set<String>> macroShortcutsMap = null;

    public MacrosKeymapManager() {
        super(MacrosKeymapManager.class.getName());
    }

    public Map<String, Set<ShortcutAction>> getActions() {
        if (this.macroActionsMap == null) {
            List<MacrosModel.Macro> list = this.getModel().getAllMacros();
            HashSet<MacrosModel.Macro> hashSet = new HashSet<MacrosModel.Macro>(list.size());
            this.macroShortcutsMap = new HashMap<ShortcutAction, Set<String>>(list.size());
            for (MacrosModel.Macro macro : list) {
                hashSet.add(macro);
                HashSet<String> hashSet2 = new HashSet<String>();
                for (MultiKeyBinding multiKeyBinding : macro.getShortcuts()) {
                    String string = StorageSupport.keyStrokesToString((Collection)multiKeyBinding.getKeyStrokeList(), (boolean)true);
                    assert (string != null);
                    hashSet2.add(string);
                }
                if (hashSet2.size() <= 0) continue;
                this.macroShortcutsMap.put(macro, hashSet2);
            }
            this.macroActionsMap = new HashMap<String, Set<ShortcutAction>>();
            this.macroActionsMap.put(NbBundle.getMessage(MacrosKeymapManager.class, (String)"Macros_Keymap_Category"), hashSet);
        }
        return this.macroActionsMap;
    }

    public void refreshActions() {
        this.macroActionsMap = null;
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        this.getActions();
        return this.macroShortcutsMap;
    }

    public Map<ShortcutAction, Set<String>> getDefaultKeymap(String string) {
        return this.getKeymap(string);
    }

    public void saveKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        for (ShortcutAction shortcutAction : map.keySet()) {
            if (!(shortcutAction instanceof MacrosModel.Macro)) continue;
            MacrosModel.Macro macro = (MacrosModel.Macro)shortcutAction;
            Set<String> set = map.get(shortcutAction);
            macro.setShortcuts(set);
        }
        this.getModel().save();
        this.macroActionsMap = null;
    }

    public List<String> getProfiles() {
        return null;
    }

    public String getCurrentProfile() {
        return null;
    }

    public void setCurrentProfile(String string) {
    }

    public void deleteProfile(String string) {
    }

    public boolean isCustomProfile(String string) {
        return false;
    }

    private MacrosModel getModel() {
        if (this.model == null) {
            this.model = MacrosModel.get();
            if (!this.model.isLoaded()) {
                this.model.load();
            }
        }
        return this.model;
    }
}

