/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.options.indentation.IndentationPanelController;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizerSelector {
    public static final String FORMATTING_CUSTOMIZERS_FOLDER = "OptionsDialog/Editor/Formatting/";
    public static final String PROP_MIMETYPE = "CustomizerSelector.PROP_MIMETYPE";
    public static final String PROP_CUSTOMIZER = "CustomizerSelector.PROP_CUSTOMIZER";
    private static final Logger LOG = Logger.getLogger(CustomizerSelector.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final PreferencesFactory pf;
    private final boolean acceptOldControllers;
    private final Set<String> allowedMimeTypes;
    private String selectedMimeType;
    private String selectedCustomizerId;
    private Set<String> mimeTypes = null;
    private final Map<String, List<? extends PreferencesCustomizer>> allCustomizers = new HashMap<String, List<? extends PreferencesCustomizer>>();
    private final Map<PreferencesCustomizer, Preferences> c2p = new HashMap<PreferencesCustomizer, Preferences>();

    public CustomizerSelector(PreferencesFactory preferencesFactory, boolean bl, String string) {
        this.pf = preferencesFactory;
        this.acceptOldControllers = bl;
        if (string != null) {
            this.allowedMimeTypes = new HashSet<String>();
            for (String string2 : string.split(",")) {
                if (MimePath.validate((CharSequence)(string2 = string2.trim()))) {
                    this.allowedMimeTypes.add(string2);
                    continue;
                }
                LOG.warning("Ignoring invalid mimetype '" + string2 + "'");
            }
        } else {
            this.allowedMimeTypes = null;
        }
    }

    public synchronized String getSelectedMimeType() {
        return this.selectedMimeType;
    }

    public synchronized void setSelectedMimeType(String string) {
        assert (this.getMimeTypes().contains(string)) : "'" + string + "' is not among " + this.getMimeTypes();
        if (this.selectedMimeType == null || !this.selectedMimeType.equals(string)) {
            String string2 = this.selectedMimeType;
            this.selectedMimeType = string;
            this.selectedCustomizerId = null;
            this.pcs.firePropertyChange(PROP_MIMETYPE, string2, string);
        }
    }

    public synchronized PreferencesCustomizer getSelectedCustomizer() {
        if (this.selectedCustomizerId != null) {
            for (PreferencesCustomizer preferencesCustomizer : this.getCustomizersFor(this.selectedMimeType)) {
                if (!this.selectedCustomizerId.equals(preferencesCustomizer.getId())) continue;
                return preferencesCustomizer;
            }
        }
        return null;
    }

    public synchronized void setSelectedCustomizer(String string) {
        if (this.selectedCustomizerId == null || !this.selectedCustomizerId.equals(string)) {
            for (PreferencesCustomizer preferencesCustomizer : this.getCustomizersFor(this.selectedMimeType)) {
                if (!string.equals(preferencesCustomizer.getId())) continue;
                String string2 = this.selectedCustomizerId;
                this.selectedCustomizerId = string;
                this.pcs.firePropertyChange(PROP_CUSTOMIZER, string2, string);
                break;
            }
        }
    }

    public synchronized Preferences getCustomizerPreferences(PreferencesCustomizer preferencesCustomizer) {
        Preferences preferences = this.c2p.get(preferencesCustomizer);
        assert (preferences != null);
        return preferences;
    }

    public synchronized Collection<? extends String> getMimeTypes() {
        if (this.mimeTypes == null) {
            this.mimeTypes = new HashSet<String>();
            this.mimeTypes.add("");
            for (String string : EditorSettings.getDefault().getAllMimeTypes()) {
                Collection collection;
                Lookup lookup = Lookups.forPath((String)(FORMATTING_CUSTOMIZERS_FOLDER + string));
                Collection collection2 = lookup.lookupAll(PreferencesCustomizer.Factory.class);
                if (!collection2.isEmpty()) {
                    if (this.allowedMimeTypes != null && !this.allowedMimeTypes.contains(string)) continue;
                    this.mimeTypes.add(string);
                    continue;
                }
                if (!this.acceptOldControllers || (collection = lookup.lookupAll(OptionsPanelController.class)).isEmpty() || this.allowedMimeTypes != null && !this.allowedMimeTypes.contains(string)) continue;
                this.mimeTypes.add(string);
            }
        }
        return this.mimeTypes;
    }

    public synchronized List<? extends PreferencesCustomizer> getCustomizers(String string) {
        return this.getCustomizersFor(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private List<? extends PreferencesCustomizer> getCustomizersFor(String string) {
        List<? extends PreferencesCustomizer> list = this.allCustomizers.get(string);
        if (list == null) {
            list = this.loadCustomizers(string);
            this.allCustomizers.put(string, list);
        }
        return list;
    }

    private List<? extends PreferencesCustomizer> loadCustomizers(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Preferences preferences = this.pf.getPreferences(string);
        if (string.length() > 0) {
            Object object;
            PreferencesCustomizer preferencesCustomizer;
            Lookup lookup = Lookups.forPath((String)(FORMATTING_CUSTOMIZERS_FOLDER + string));
            Collection collection = lookup.lookupAll(PreferencesCustomizer.Factory.class);
            for (Object object2 : collection) {
                preferencesCustomizer = object2.create(preferences);
                if (preferencesCustomizer.getId().equals("tabs-and-indents")) {
                    object = this.pf.getPreferences("");
                    preferencesCustomizer = new IndentationPanelController(MimePath.parse((String)string), this.pf, preferences, (Preferences)object, preferencesCustomizer);
                }
                arrayList.add(preferencesCustomizer);
                this.c2p.put(preferencesCustomizer, preferences);
            }
            if (this.acceptOldControllers) {
                Object object2;
                Collection collection2 = lookup.lookupAll(OptionsPanelController.class);
                object2 = collection2.iterator();
                while (object2.hasNext()) {
                    preferencesCustomizer = (OptionsPanelController)object2.next();
                    object = preferencesCustomizer instanceof PreviewProvider ? new WrapperCustomizerWithPreview((OptionsPanelController)preferencesCustomizer) : new WrapperCustomizer((OptionsPanelController)preferencesCustomizer);
                    arrayList.add(object);
                    this.c2p.put((PreferencesCustomizer)object, preferences);
                }
            }
        } else {
            IndentationPanelController indentationPanelController = new IndentationPanelController(preferences);
            arrayList.add(indentationPanelController);
            this.c2p.put(indentationPanelController, preferences);
        }
        return arrayList;
    }

    private static final class WrapperCustomizerWithPreview
    extends WrapperCustomizer
    implements PreviewProvider {
        private final PreviewProvider provider;

        public WrapperCustomizerWithPreview(OptionsPanelController optionsPanelController) {
            super(optionsPanelController);
            this.provider = (PreviewProvider)optionsPanelController;
        }

        public JComponent getPreviewComponent() {
            return this.provider.getPreviewComponent();
        }

        public void refreshPreview() {
            this.provider.refreshPreview();
        }
    }

    static class WrapperCustomizer
    implements PreferencesCustomizer {
        private final OptionsPanelController controller;
        private JComponent component;

        public WrapperCustomizer(OptionsPanelController optionsPanelController) {
            this.controller = optionsPanelController;
        }

        public String getId() {
            return this.controller.getClass() + "@" + Integer.toHexString(System.identityHashCode(this.controller));
        }

        public String getDisplayName() {
            return this.getComponent().getName();
        }

        public HelpCtx getHelpCtx() {
            return this.controller.getHelpCtx();
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = this.controller.getComponent(Lookup.EMPTY);
                this.controller.update();
            }
            return this.component;
        }

        public void applyChanges() {
            this.controller.applyChanges();
        }

        public void cancel() {
            this.controller.cancel();
        }
    }

    public static interface PreferencesFactory {
        public Preferences getPreferences(String var1);

        public boolean isKeyOverridenForMimeType(String var1, String var2);
    }
}

