/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

public class NoMainProjectWarning
extends JPanel {
    private ChangeListener changeListener;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList1;
    private JScrollPane jScrollPane2;

    public NoMainProjectWarning(Project[] projectArray) {
        this.initComponents();
        Arrays.sort(projectArray, OpenProjectList.PROJECT_BY_DISPLAYNAME);
        ProjectsListModel projectsListModel = new ProjectsListModel(projectArray);
        this.jList1.setModel(projectsListModel);
        this.jList1.setSelectionMode(0);
        if (projectsListModel.getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.jList1.setCellRenderer(new ProjectsRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (NoMainProjectWarning.this.changeListener != null) {
                    NoMainProjectWarning.this.changeListener.stateChanged(new ChangeEvent(listSelectionEvent));
                }
            }
        });
        this.jList1.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && NoMainProjectWarning.this.getSelectedProject() != null && NoMainProjectWarning.this.changeListener != null) {
                    NoMainProjectWarning.this.changeListener.stateChanged(new ChangeEvent(mouseEvent));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    public Project getSelectedProject() {
        if (this.jList1.getSelectedIndex() == -1) {
            return null;
        }
        return (Project)this.jList1.getSelectedValue();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(380, 300));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/ui/Bundle").getString("AD_NoMainProjectWarninig"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainProjectWarning_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 6, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainProjectWarning_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 2, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(100, 200));
        this.jList1.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/ui/Bundle").getString("AD_NoMainProjectWarning_jList1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListener = null;
    }

    private static final class ProjectsRenderer
    extends JLabel
    implements ListCellRenderer {
        ProjectsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Project) {
                Project project = (Project)object;
                this.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
                this.setIcon(ProjectUtils.getInformation((Project)project).getIcon());
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static final class ProjectsListModel
    extends AbstractListModel {
        private Project[] openProjects;

        public ProjectsListModel(Project[] projectArray) {
            this.openProjects = projectArray;
        }

        public synchronized int getSize() {
            return this.getProjects().length;
        }

        public synchronized Object getElementAt(int n) {
            if (n >= 0 && n < this.getProjects().length) {
                return this.getProjects()[n];
            }
            return null;
        }

        private Project[] getProjects() {
            if (this.openProjects == null) {
                return new Project[0];
            }
            return this.openProjects;
        }
    }
}

