/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectTemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_LICENSE = "license";
    private static final String ATTR_ENCODING = "encoding";

    public Map<String, ? extends Object> attributesFor(DataObject dataObject, DataFolder dataFolder, String string) {
        Project project = FileOwnerQuery.getOwner((FileObject)dataFolder.getPrimaryFile());
        HashMap hashMap = null;
        if (project != null) {
            for (CreateFromTemplateAttributesProvider createFromTemplateAttributesProvider : project.getLookup().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Map map = createFromTemplateAttributesProvider.attributesFor(dataObject, dataFolder, string);
                if (map == null) continue;
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.putAll(map);
            }
        }
        return ProjectTemplateAttributesProvider.checkProjectAttrs(hashMap, dataFolder.getPrimaryFile());
    }

    static Map<String, ? extends Object> checkProjectAttrs(Map<String, Object> map, FileObject fileObject) {
        Object object;
        Object object2 = object = map != null ? map.get(ATTR_PROJECT) : null;
        if (object instanceof Map) {
            Map map2 = NbCollections.checkedMapByFilter((Map)((Map)object), String.class, Object.class, (boolean)false);
            if (map2.get(ATTR_LICENSE) == null || map2.get(ATTR_ENCODING) == null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(map2);
                map.put(ATTR_PROJECT, hashMap);
                ProjectTemplateAttributesProvider.ensureProjectAttrs(hashMap, fileObject);
            }
            return map;
        }
        if (object != null) {
            return map;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ProjectTemplateAttributesProvider.ensureProjectAttrs(hashMap, fileObject);
        if (map != null) {
            map.put(ATTR_PROJECT, hashMap);
            return map;
        }
        return Collections.singletonMap(ATTR_PROJECT, hashMap);
    }

    private static void ensureProjectAttrs(Map<String, Object> map, FileObject fileObject) {
        if (map.get(ATTR_LICENSE) == null) {
            map.put(ATTR_LICENSE, "default");
        }
        if (map.get(ATTR_ENCODING) == null) {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            String string = charset != null ? charset.name() : "UTF-8";
            map.put(ATTR_ENCODING, string);
        }
    }
}

