/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;

public class CategoryModel {
    public static final String PROP_CURRENT_CATEGORY = "propCurrentCategory";
    private ProjectCustomizer.Category[] categories;
    private ProjectCustomizer.Category currentCategory;
    private PropertyChangeSupport pcs;

    public CategoryModel(ProjectCustomizer.Category[] categoryArray) {
        if (categoryArray == null || categoryArray.length == 0) {
            throw new IllegalArgumentException("Must provide at least one category");
        }
        this.categories = categoryArray;
        this.currentCategory = categoryArray[0];
        this.pcs = new PropertyChangeSupport(this);
    }

    public ProjectCustomizer.Category getCurrentCategory() {
        return this.currentCategory;
    }

    public ProjectCustomizer.Category getCategory(String string) {
        return CategoryModel.findCategoryByName(string, this.categories);
    }

    public void setCurrentCategory(ProjectCustomizer.Category category) {
        if (this.currentCategory != category) {
            ProjectCustomizer.Category category2 = this.currentCategory;
            this.currentCategory = category;
            this.firePropertyChange(PROP_CURRENT_CATEGORY, category2, category);
        }
    }

    public ProjectCustomizer.Category[] getCategories() {
        return this.categories;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    private static ProjectCustomizer.Category findCategoryByName(String string, ProjectCustomizer.Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            ProjectCustomizer.Category category;
            if (string.equals(categoryArray[i].getName())) {
                return categoryArray[i];
            }
            ProjectCustomizer.Category[] categoryArray2 = categoryArray[i].getSubcategories();
            if (categoryArray2 == null || (category = CategoryModel.findCategoryByName(string, categoryArray2)) == null) continue;
            return category;
        }
        return null;
    }
}

