/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.spi;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.SpiPackageAccessor;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;
import org.openide.filesystems.FileObject;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StorageReader<K, V>
extends DefaultHandler
implements LexicalHandler {
    private static final Logger LOG = Logger.getLogger(StorageReader.class.getName());
    private final FileObject file;
    private final boolean isModuleFile;
    private final boolean isDefaultProfile;
    private final String mimePath;

    protected StorageReader(FileObject fileObject, String string) {
        assert (fileObject != null) : "The processedFile parameter must not be null";
        assert (string != null) : "The mimePath parameter must not be null";
        this.file = fileObject;
        this.mimePath = string;
        boolean bl = false;
        boolean bl2 = false;
        FileObject fileObject2 = this.file.getParent();
        if (fileObject2 != null) {
            bl = fileObject2.getNameExt().contains("Default");
            if ((fileObject2 = fileObject2.getParent()) != null) {
                bl2 = fileObject2.getNameExt().contains("NetBeans");
            }
        }
        this.isModuleFile = bl;
        this.isDefaultProfile = bl2;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.log("warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.log("error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw this.log("fatal error", sAXParseException);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    public abstract Map<K, V> getAdded();

    public abstract Set<K> getRemoved();

    protected final FileObject getProcessedFile() {
        return this.file;
    }

    protected final boolean isModuleFile() {
        return this.isModuleFile;
    }

    protected final boolean isDefaultProfile() {
        return this.isDefaultProfile;
    }

    protected final String getMimePath() {
        return this.mimePath;
    }

    private SAXException log(String string, SAXParseException sAXParseException) {
        String string2;
        Level level;
        if (this.file == null) {
            level = Level.FINE;
            string2 = "XML parser " + string;
        } else {
            level = this.isModuleFile() ? Level.WARNING : Level.FINE;
            string2 = "XML parser " + string + " in file " + this.file.getPath();
        }
        SAXException sAXException = new SAXException(string2);
        sAXException.initCause(sAXParseException);
        LOG.log(level, string2, sAXException);
        return sAXException;
    }

    static {
        SpiPackageAccessor.register(new SpiPackageAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SpiPackageAccessorImpl
    extends SpiPackageAccessor {
        private SpiPackageAccessorImpl() {
        }

        @Override
        public String storageFilterGetStorageDescriptionId(StorageFilter storageFilter) {
            return storageFilter.getStorageDescriptionId();
        }

        @Override
        public void storageFilterInitialize(StorageFilter storageFilter, Callable<Void> callable) {
            storageFilter.initialize(callable);
        }
    }
}

