/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.classfile.Access;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AttributeMap;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.EnclosingMethod;
import org.netbeans.modules.classfile.InnerClass;
import org.netbeans.modules.classfile.InvalidClassFileAttributeException;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFile {
    ConstantPool constantPool;
    int classAccess;
    CPClassInfo classInfo;
    CPClassInfo superClassInfo;
    CPClassInfo[] interfaces;
    Variable[] variables;
    Method[] methods;
    String sourceFileName;
    InnerClass[] innerClasses;
    private AttributeMap attributes;
    private Map<ClassName, Annotation> annotations;
    short majorVersion;
    short minorVersion;
    String typeSignature;
    EnclosingMethod enclosingMethod;
    private boolean includeCode = false;
    private static final int BUFFER_SIZE = 4096;

    public ClassFile(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public ClassFile(String string) throws IOException {
        this(string, true);
    }

    public ClassFile(File file, boolean bl) throws IOException {
        InputStream inputStream = null;
        this.includeCode = bl;
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file != null ? file.getPath() : "null");
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file), 4096);
            this.load(inputStream);
        }
        catch (InvalidClassFormatException invalidClassFormatException) {
            throw new InvalidClassFormatException(file.getPath() + '(' + invalidClassFormatException.getMessage() + ')');
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public ClassFile(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new IOException("input stream not specified");
        }
        this.includeCode = bl;
        try {
            this.load(inputStream);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidClassFormatException("invalid classfile format");
        }
    }

    public ClassFile(String string, boolean bl) throws IOException {
        InputStream inputStream = null;
        this.includeCode = bl;
        try {
            if (string == null) {
                throw new IOException("input stream not specified");
            }
            inputStream = new BufferedInputStream(new FileInputStream(string), 4096);
            this.load(inputStream);
        }
        catch (InvalidClassFormatException invalidClassFormatException) {
            throw new InvalidClassFormatException(string + '(' + invalidClassFormatException.getMessage() + ')');
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public final ConstantPool getConstantPool() {
        return this.constantPool;
    }

    private void load(InputStream inputStream) throws IOException {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.constantPool = this.loadClassHeader(dataInputStream);
            this.interfaces = ClassFile.getCPClassList(dataInputStream, this.constantPool);
            this.variables = Variable.loadFields(dataInputStream, this.constantPool, this);
            this.methods = Method.loadMethods(dataInputStream, this.constantPool, this, this.includeCode);
            this.attributes = AttributeMap.load(dataInputStream, this.constantPool);
        }
        catch (IOException iOException) {
            throw new InvalidClassFormatException(iOException);
        }
    }

    private ConstantPool loadClassHeader(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != -889275714) {
            throw new InvalidClassFormatException();
        }
        this.minorVersion = dataInputStream.readShort();
        this.majorVersion = dataInputStream.readShort();
        int n2 = dataInputStream.readUnsignedShort();
        ConstantPool constantPool = new ConstantPool(n2, dataInputStream);
        this.classAccess = dataInputStream.readUnsignedShort();
        this.classInfo = constantPool.getClass(dataInputStream.readUnsignedShort());
        if (this.classInfo == null) {
            throw new InvalidClassFormatException();
        }
        int n3 = dataInputStream.readUnsignedShort();
        if (n3 != 0) {
            this.superClassInfo = constantPool.getClass(n3);
        }
        return constantPool;
    }

    static CPClassInfo[] getCPClassList(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        CPClassInfo[] cPClassInfoArray = new CPClassInfo[n];
        for (int i = 0; i < n; ++i) {
            cPClassInfoArray[i] = constantPool.getClass(dataInputStream.readUnsignedShort());
        }
        return cPClassInfoArray;
    }

    public final int getAccess() {
        return this.classAccess;
    }

    public final ClassName getName() {
        return this.classInfo.getClassName();
    }

    public final ClassName getSuperClass() {
        if (this.superClassInfo == null) {
            return null;
        }
        return this.superClassInfo.getClassName();
    }

    public final Collection<ClassName> getInterfaces() {
        ArrayList<ClassName> arrayList = new ArrayList<ClassName>();
        int n = this.interfaces.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.interfaces[i].getClassName());
        }
        return arrayList;
    }

    public final Variable getVariable(String string) {
        for (Variable variable : this.variables) {
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    public final Collection<Variable> getVariables() {
        return Arrays.asList(this.variables);
    }

    public final int getVariableCount() {
        return this.variables.length;
    }

    public final Method getMethod(String string, String string2) {
        for (Method method : this.methods) {
            if (!method.getName().equals(string) || !method.getDescriptor().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public final Collection<Method> getMethods() {
        return Arrays.asList(this.methods);
    }

    public final int getMethodCount() {
        return this.methods.length;
    }

    public final String getSourceFileName() {
        DataInputStream dataInputStream;
        if (this.sourceFileName == null && (dataInputStream = this.attributes.getStream("SourceFile")) != null) {
            try {
                int n = dataInputStream.readUnsignedShort();
                CPUTF8Info cPUTF8Info = (CPUTF8Info)this.constantPool.get(n);
                this.sourceFileName = cPUTF8Info.getName();
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid SourceFile attribute", iOException);
            }
        }
        return this.sourceFileName;
    }

    public final boolean isDeprecated() {
        return this.attributes.get("Deprecated") != null;
    }

    public final boolean isSynthetic() {
        return (this.classAccess & 0x1000) == 4096 || this.attributes.get("Synthetic") != null;
    }

    public final boolean isAnnotation() {
        return (this.classAccess & 0x2000) == 8192;
    }

    public final boolean isEnum() {
        return (this.classAccess & 0x4000) == 16384;
    }

    public final AttributeMap getAttributes() {
        return this.attributes;
    }

    public final Collection<InnerClass> getInnerClasses() {
        if (this.innerClasses == null) {
            DataInputStream dataInputStream = this.attributes.getStream("InnerClasses");
            if (dataInputStream != null) {
                try {
                    this.innerClasses = InnerClass.loadInnerClasses(dataInputStream, this.constantPool);
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    throw new InvalidClassFileAttributeException("invalid InnerClasses attribute", iOException);
                }
            } else {
                this.innerClasses = new InnerClass[0];
            }
        }
        return Arrays.asList(this.innerClasses);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getTypeSignature() {
        DataInputStream dataInputStream;
        if (this.typeSignature == null && (dataInputStream = this.attributes.getStream("Signature")) != null) {
            try {
                CPUTF8Info cPUTF8Info = (CPUTF8Info)this.constantPool.get(dataInputStream.readUnsignedShort());
                this.typeSignature = cPUTF8Info.getName();
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid Signature attribute", iOException);
            }
        }
        return this.typeSignature;
    }

    public EnclosingMethod getEnclosingMethod() {
        DataInputStream dataInputStream;
        if (this.enclosingMethod == null && (dataInputStream = this.attributes.getStream("EnclosingMethod")) != null) {
            try {
                int n = dataInputStream.readUnsignedShort();
                int n2 = dataInputStream.readUnsignedShort();
                CPEntry cPEntry = this.constantPool.get(n);
                if (cPEntry.getTag() == 7) {
                    this.enclosingMethod = new EnclosingMethod(this.constantPool, (CPClassInfo)cPEntry, n2);
                }
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid EnclosingMethod attribute", iOException);
            }
        }
        return this.enclosingMethod;
    }

    private void loadAnnotations() {
        if (this.annotations == null) {
            this.annotations = ClassFile.buildAnnotationMap(this.constantPool, this.attributes);
        }
    }

    static Map<ClassName, Annotation> buildAnnotationMap(ConstantPool constantPool, AttributeMap attributeMap) {
        HashMap<ClassName, Annotation> hashMap = new HashMap<ClassName, Annotation>(2);
        DataInputStream dataInputStream = attributeMap.getStream("RuntimeVisibleAnnotations");
        if (dataInputStream != null) {
            try {
                Annotation.load(dataInputStream, constantPool, true, hashMap);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid RuntimeVisibleAnnotations attribute", iOException);
            }
        }
        if ((dataInputStream = attributeMap.getStream("RuntimeInvisibleAnnotations")) != null) {
            try {
                Annotation.load(dataInputStream, constantPool, false, hashMap);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid RuntimeInvisibleAnnotations attribute", iOException);
            }
        }
        return hashMap;
    }

    public final Collection<Annotation> getAnnotations() {
        this.loadAnnotations();
        return this.annotations.values();
    }

    public final Annotation getAnnotation(ClassName className) {
        this.loadAnnotations();
        return this.annotations.get(className);
    }

    public final boolean isAnnotationPresent(ClassName className) {
        this.loadAnnotations();
        return this.annotations.get(className) != null;
    }

    public final Set<ClassName> getAllClassNames() {
        int n;
        HashSet<ClassName> hashSet = new HashSet<ClassName>();
        Collection collection = this.constantPool.getAllConstants(CPClassInfo.class);
        for (CPClassInfo cPClassInfo : collection) {
            hashSet.add(cPClassInfo.getClassName());
        }
        for (n = 0; n < this.variables.length; ++n) {
            this.addClassNames(hashSet, this.variables[n].getDescriptor());
        }
        for (n = 0; n < this.methods.length; ++n) {
            this.addClassNames(hashSet, this.methods[n].getDescriptor());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private void addClassNames(Set<ClassName> set, String string) {
        int n;
        int n2 = 0;
        while ((n2 = string.indexOf(76, n2)) != -1 && (n = string.indexOf(59, n2)) > n2) {
            String string2 = string.substring(n2 + 1, n);
            set.add(ClassName.getClassName(string2));
            n2 = n + 1;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ClassFile: ");
        stringBuffer.append(Access.toString(this.classAccess));
        stringBuffer.append(' ');
        stringBuffer.append(this.classInfo);
        if (this.isSynthetic()) {
            stringBuffer.append(" (synthetic)");
        }
        if (this.isDeprecated()) {
            stringBuffer.append(" (deprecated)");
        }
        stringBuffer.append("\n   source: ");
        stringBuffer.append(this.getSourceFileName());
        stringBuffer.append("\n   super: ");
        stringBuffer.append(this.superClassInfo);
        if (this.getTypeSignature() != null) {
            stringBuffer.append("\n   signature: ");
            stringBuffer.append(this.typeSignature);
        }
        if (this.getEnclosingMethod() != null) {
            stringBuffer.append("\n   enclosing method: ");
            stringBuffer.append(this.enclosingMethod);
        }
        stringBuffer.append("\n   ");
        this.loadAnnotations();
        if (this.annotations.size() > 0) {
            Iterator<Annotation> iterator = this.annotations.values().iterator();
            stringBuffer.append("annotations: ");
            while (iterator.hasNext()) {
                stringBuffer.append("\n      ");
                stringBuffer.append(((Object)iterator.next()).toString());
            }
            stringBuffer.append("\n   ");
        }
        if (this.interfaces.length > 0) {
            stringBuffer.append(this.arrayToString("interfaces", this.interfaces));
            stringBuffer.append("\n   ");
        }
        if (this.getInnerClasses().size() > 0) {
            stringBuffer.append(this.arrayToString("innerclasses", this.innerClasses));
            stringBuffer.append("\n   ");
        }
        if (this.variables.length > 0) {
            stringBuffer.append(this.arrayToString("variables", this.variables));
            stringBuffer.append("\n   ");
        }
        if (this.methods.length > 0) {
            stringBuffer.append(this.arrayToString("methods", this.methods));
        }
        return stringBuffer.toString();
    }

    private String arrayToString(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(": ");
        int n = objectArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                stringBuffer.append("\n      ");
                stringBuffer.append(objectArray[n2++].toString());
            } while (n2 < n);
        } else {
            stringBuffer.append("none");
        }
        return stringBuffer.toString();
    }
}

