/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ExtendedJTable
extends JTable {
    private static final Color MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(0xE0E0E0);
    private static final Color MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    private static final Color MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(3435966);
    private static final Color MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    private static final Color MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(0xACACAC);
    private static final Color MAC_OS_ALTERNATE_ROW_COLOR = new Color(0.92f, 0.95f, 0.99f);

    public ExtendedJTable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        if (ExtendedJTable.isMacOs() && System.getProperty("os.version").startsWith("10.4")) {
            ((JLabel)((Object)this.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(10);
        }
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintEmptyRows(graphics);
    }

    protected void paintEmptyRows(Graphics graphics) {
        int n = this.getRowCount();
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = rectangle.y + rectangle.height;
        if (n * this.rowHeight < n2) {
            for (int i = n; i <= n2 / this.rowHeight; ++i) {
                graphics.setColor(ExtendedJTable.backgroundColorForRow(i));
                graphics.fillRect(rectangle.x, i * this.rowHeight, rectangle.width, this.rowHeight);
            }
            if (this.getShowVerticalLines()) {
                graphics.setColor(MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                TableColumnModel tableColumnModel = this.getColumnModel();
                int n3 = 0;
                for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    graphics.drawLine((n3 += tableColumn.getWidth()) - 1, n * this.rowHeight, n3 - 1, n2);
                }
            }
        }
    }

    public static Color backgroundColorForRow(int n) {
        if (UIManager.getLookAndFeel().getClass().getName().contains("GTK")) {
            return n % 2 == 0 ? Color.WHITE : UIManager.getColor("Table.background");
        }
        if (System.getProperty("os.name").contains("Mac")) {
            return n % 2 == 0 ? Color.WHITE : MAC_OS_ALTERNATE_ROW_COLOR;
        }
        if (System.getProperty("os.name").contains("Win")) {
            return n % 2 == 0 ? Color.WHITE : MAC_OS_ALTERNATE_ROW_COLOR;
        }
        return UIManager.getColor("Table.background");
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            return jViewport.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        return this.prepareComponent(super.prepareRenderer(tableCellRenderer, n, n2), n, n2);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        return this.prepareComponent(super.prepareEditor(tableCellEditor, n, n2), n, n2);
    }

    private Component prepareComponent(Component component, int n, int n2) {
        boolean bl = this.hasFocus();
        boolean bl2 = this.isCellSelected(n, n2);
        if (!bl2) {
            component.setBackground(ExtendedJTable.backgroundColorForRow(n));
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (ExtendedJTable.isGtk() && component instanceof JCheckBox) {
                jComponent.setOpaque(true);
            } else if (ExtendedJTable.isMacOs() && component instanceof JCheckBox) {
                jComponent.setOpaque(true);
                ((JCheckBox)jComponent).putClientProperty("JComponent.sizeVariant", "mini");
            }
            if (!this.getCellSelectionEnabled()) {
                jComponent.setBorder(new AquaTableCellBorder(bl2, bl, this.getShowVerticalLines()));
            }
        }
        return component;
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        if (!ExtendedJTable.isMacOs()) {
            return;
        }
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            Component component = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(component, "Center");
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", jPanel);
        }
    }

    private static boolean isMacOs() {
        return System.getProperty("os.name").contains("Mac");
    }

    private static boolean isGtk() {
        return UIManager.getLookAndFeel().getClass().getName().contains("GTK");
    }

    private static class AquaTableCellBorder
    extends AbstractBorder {
        private boolean selected;
        private boolean focused;
        private boolean verticalLines;

        public AquaTableCellBorder(boolean bl, boolean bl2, boolean bl3) {
            this.selected = bl;
            this.focused = bl2;
            this.verticalLines = bl3;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.selected) {
                graphics.setColor(this.focused ? MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR : MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR);
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
            if (this.verticalLines) {
                if (this.focused) {
                    graphics.setColor(this.selected ? MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                } else {
                    graphics.setColor(this.selected ? MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                }
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

