/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class DateType
extends TimestampType {
    private final DateFormat[] DATE_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd", LOCALE), new SimpleDateFormat("MM-dd-yyyy", LOCALE), DateFormat.getTimeInstance(3, LOCALE)};
    static final long INCREMENT_DAY = 86400000L;

    public DateType() {
        for (int i = 0; i < this.DATE_PARSING_FORMATS.length; ++i) {
            this.DATE_PARSING_FORMATS[i].setLenient(false);
        }
    }

    private java.sql.Date convertToDate(Object object) throws DBException {
        Calendar calendar = Calendar.getInstance();
        if (null == object) {
            return null;
        }
        if (object instanceof Timestamp) {
            calendar.setTimeInMillis(((Timestamp)object).getTime());
        } else if (object instanceof String) {
            Date date = null;
            for (int i = 0; date == null && i < this.DATE_PARSING_FORMATS.length; ++i) {
                date = this.DATE_PARSING_FORMATS[i].parse((String)object, new ParsePosition(0));
            }
            if (date == null) {
                throw new DBException(NbBundle.getMessage(DateType.class, (String)"LBL_invalid_date"));
            }
            calendar.setTimeInMillis(date.getTime());
        } else {
            throw new DBException(NbBundle.getMessage(DateType.class, (String)"LBL_invalid_date"));
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public Object convert(Object object) throws DBException {
        try {
            if (object instanceof java.sql.Date) {
                return object;
            }
            return this.convertToDate(object);
        }
        catch (DBException dBException) {
            throw new DBException(NbBundle.getMessage(DateType.class, (String)"MSG_failure_convert_date", (Object)object.getClass().getName(), (Object)object));
        }
    }
}

