/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.provider.ComponentLine;
import org.netbeans.modules.print.util.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentDocument
extends JComponent {
    private int[] myCorrection;
    private int[] myAscent;
    private int[] myDescent;
    private int[] myLeading;
    private int myMinOffset;
    private Font myTextFont;
    private int myWidth;
    private int myHeight;
    private Color myBackgroundColor;
    private Color myTextColor;
    private double myLineSpacing;
    private boolean myWrapLines;
    private boolean myLineNumbers;
    private List<ComponentLine> myLines;

    ComponentDocument(String string) {
        this.init();
        this.prepare(string);
        this.perform();
    }

    ComponentDocument(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        this.init();
        this.prepare(attributedCharacterIteratorArray);
        this.perform();
    }

    private void init() {
        this.myWrapLines = Config.getDefault().isWrapLines();
        this.myLineNumbers = Config.getDefault().isLineNumbers();
        this.myTextColor = Config.getDefault().getTextColor();
        this.myTextFont = Config.getDefault().getTextFont();
        this.myBackgroundColor = Config.getDefault().getBackgroundColor();
        this.myLineSpacing = Config.getDefault().getLineSpacing();
        this.myLines = new ArrayList<ComponentLine>();
    }

    private void prepare(String string) {
        LineTokenizer lineTokenizer = new LineTokenizer(string);
        while (lineTokenizer.hasMoreTokens()) {
            ComponentLine componentLine = new ComponentLine(this.trimEnded(lineTokenizer.nextToken()), this.myTextFont, this.myTextColor);
            this.myLines.add(componentLine);
        }
    }

    private void prepare(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        for (AttributedCharacterIterator attributedCharacterIterator : attributedCharacterIteratorArray) {
            ComponentLine componentLine = new ComponentLine(attributedCharacterIterator, this.myTextFont, this.myTextColor);
            this.myLines.add(componentLine);
        }
    }

    private void perform() {
        this.removeEmptyLinesAtTheEnd();
        if (this.myLineNumbers) {
            this.prepareLineNumbering();
        }
        this.calculateOffset();
        if (this.myWrapLines) {
            this.prepareWrapLines();
        } else {
            this.prepareNoWrapLines();
        }
        this.calculateMetrics();
    }

    private void removeEmptyLinesAtTheEnd() {
        ComponentLine componentLine;
        int n = this.myLines.size() - 1;
        while (n >= 0 && (componentLine = this.myLines.get(n--)).isEmpty()) {
            this.myLines.remove(componentLine);
        }
    }

    private String trimEnded(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        return string.substring(0, n + 1);
    }

    private void prepareLineNumbering() {
        int n = (this.myLines.size() + "").length();
        int n2 = 1;
        for (ComponentLine componentLine : this.myLines) {
            componentLine.prepend(this.getNumber(n2++, n));
        }
    }

    private void prepareNoWrapLines() {
        int n = 0;
        for (ComponentLine componentLine : this.myLines) {
            int n2 = componentLine.getWidth();
            if (n2 <= n) continue;
            n = n2;
        }
        this.myWidth = n + this.myMinOffset;
    }

    private void prepareWrapLines() {
        this.myWidth = Config.getDefault().getPageWidth();
        ArrayList<ComponentLine> arrayList = new ArrayList<ComponentLine>();
        for (ComponentLine componentLine : this.myLines) {
            if (componentLine.getWidth() + this.myMinOffset <= this.myWidth) {
                arrayList.add(componentLine);
                continue;
            }
            this.addWordWrappedLine(arrayList, componentLine);
        }
        this.myLines = arrayList;
    }

    private void addWordWrappedLine(List<ComponentLine> list, ComponentLine componentLine) {
        block5: {
            int n;
            ComponentLine componentLine2;
            if (componentLine.getWidth() + this.myMinOffset <= this.myWidth) {
                list.add(componentLine);
                return;
            }
            int n2 = componentLine.length();
            do {
                if ((n = componentLine.lastIndexOf(' ', n2 - 1)) == -1) {
                    this.addCharWrappedLine(list, componentLine);
                    break block5;
                }
                n2 = n;
                componentLine2 = componentLine.substring(0, n);
                this.checkOffset(componentLine2);
            } while (componentLine2.getWidth() + this.myMinOffset > this.myWidth);
            if (componentLine2.isEmpty()) {
                this.addCharWrappedLine(list, componentLine);
            } else {
                list.add(componentLine2);
                componentLine2 = componentLine.substring(n + 1);
                this.checkOffset(componentLine2);
                this.addWordWrappedLine(list, componentLine2);
            }
        }
    }

    private void addCharWrappedLine(List<ComponentLine> list, ComponentLine componentLine) {
        if (componentLine.getWidth() + this.myMinOffset <= this.myWidth) {
            list.add(componentLine);
            return;
        }
        for (int i = componentLine.length(); i >= 0; --i) {
            ComponentLine componentLine2 = componentLine.substring(0, i);
            this.checkOffset(componentLine2);
            if (componentLine2.getWidth() + this.myMinOffset > this.myWidth) continue;
            list.add(componentLine2);
            componentLine2 = componentLine.substring(i);
            this.checkOffset(componentLine2);
            this.addCharWrappedLine(list, componentLine2);
            break;
        }
    }

    private void checkOffset(ComponentLine componentLine) {
        int n = -componentLine.getOffset();
        if (n > this.myMinOffset) {
            this.myMinOffset = n;
        }
    }

    private void calculateOffset() {
        this.myMinOffset = 0;
        for (ComponentLine componentLine : this.myLines) {
            this.checkOffset(componentLine);
        }
    }

    private void calculateMetrics() {
        int n;
        this.myHeight = 0;
        int n2 = this.myLines.size();
        this.myAscent = new int[n2];
        this.myDescent = new int[n2];
        this.myLeading = new int[n2];
        this.myCorrection = new int[n2];
        int n3 = n = Config.getDefault().getPageHeight();
        for (int i = 0; i < n2; ++i) {
            ComponentLine componentLine = this.myLines.get(i);
            this.myAscent[i] = (int)Math.round((double)componentLine.getAscent() * this.myLineSpacing);
            this.myDescent[i] = componentLine.getDescent();
            this.myCorrection[i] = 0;
            int n4 = this.myHeight;
            this.myHeight += this.myAscent[i] + this.myDescent[i];
            if (this.myHeight > n3 && n4 < n3) {
                this.myCorrection[i] = n3 - n4;
                this.myHeight += this.myCorrection[i];
                n3 += n;
            }
            if (i == n2 - 1) continue;
            this.myLeading[i] = componentLine.getLeading();
            this.myHeight += this.myLeading[i];
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = Config.getDefault().getGraphics(graphics);
        graphics2D.setColor(this.myBackgroundColor);
        graphics2D.fillRect(0, 0, this.myWidth, this.myHeight);
        int n = 0;
        for (int i = 0; i < this.myLines.size(); ++i) {
            ComponentLine componentLine = this.myLines.get(i);
            componentLine.draw(graphics2D, this.myMinOffset, n += this.myCorrection[i] + this.myAscent[i]);
            n += this.myDescent[i] + this.myLeading[i];
        }
    }

    private String getNumber(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        for (int i = stringBuffer.length(); i < n2; ++i) {
            stringBuffer.insert(0, " ");
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private static final class LineTokenizer {
        private int myPos;
        private int myLength;
        private String myValue;
        private StringBuffer myBuffer;

        public LineTokenizer(String string) {
            this.myValue = string;
            this.myLength = string.length();
            this.myBuffer = new StringBuffer();
        }

        public boolean hasMoreTokens() {
            return this.myPos < this.myLength;
        }

        public String nextToken() {
            this.myBuffer.setLength(0);
            String string = "";
            while (this.myPos < this.myLength) {
                char c = this.myValue.charAt(this.myPos);
                ++this.myPos;
                if (c == '\r' || c == '\n') {
                    if (c != '\r' || this.myPos >= this.myLength || this.myValue.charAt(this.myPos) != '\n') break;
                    ++this.myPos;
                    break;
                }
                this.myBuffer.append(c);
            }
            return this.myBuffer.toString();
        }
    }
}

