/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ElementDecorator;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.widgets.ErrorWidget;
import com.jaspersoft.ireport.designer.widgets.ErrorsLayer;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class PositionErrorDecorator
implements ElementDecorator {
    private static ImageIcon warningIcon = null;

    public void paintWidget(final Widget w) {
        if (w instanceof JRDesignElementWidget) {
            JasperDesign jd = this.findJasperDesign(w);
            if (jd == null) {
                return;
            }
            JRDesignElementWidget elementWidget = (JRDesignElementWidget)w;
            Rectangle rect = ModelUtils.getParentBounds(jd, elementWidget.getElement(), elementWidget);
            IReportManager.getInstance();
            if (IReportManager.getPreferences().getBoolean("showPositionErrors", true) && rect.height < elementWidget.getElement().getY() + elementWidget.getElement().getHeight()) {
                Graphics2D gr = w.getScene().getGraphics();
                Rectangle r = w.getPreferredBounds();
                AffineTransform af = gr.getTransform();
                AffineTransform new_af = (AffineTransform)af.clone();
                AffineTransform translate = AffineTransform.getTranslateInstance(w.getBorder().getInsets().left + r.x, w.getBorder().getInsets().top + r.y);
                new_af.concatenate(translate);
                gr.setTransform(new_af);
                gr.setColor(new Color(255, 0, 0, 128));
                gr.setStroke(new BasicStroke(2.0f));
                gr.drawRect(0, 0, r.width, r.height);
                if (warningIcon == null) {
                    warningIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/warning.png"));
                }
                gr.drawImage(warningIcon.getImage(), r.width - warningIcon.getIconWidth() + 5, -5, null);
                gr.setTransform(af);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ErrorWidget errorWidget = PositionErrorDecorator.this.findErrorWidget(w);
                        if (errorWidget == null) {
                            errorWidget = new ErrorWidget(w.getScene(), w);
                            errorWidget.setToolTipText("<html><img src=\"" + this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/warning.png") + "\"> Warning: the element position is invalid.");
                            PositionErrorDecorator.this.findErrorsLayer(w, true).addChild(errorWidget);
                            errorWidget.setPreferredLocation(w.getPreferredLocation());
                            errorWidget.setPreferredBounds(w.getPreferredBounds());
                            w.getScene().validate();
                        }
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ErrorWidget errorWidget = PositionErrorDecorator.this.findErrorWidget(w);
                        if (errorWidget != null) {
                            errorWidget.removeFromParent();
                        }
                    }
                });
            }
        }
    }

    public SystemAction[] getActions(Node node) {
        return new SystemAction[0];
    }

    public boolean appliesTo(Object designElement) {
        return designElement instanceof JRElement;
    }

    private JasperDesign findJasperDesign(Widget w) {
        if (w.getScene() instanceof AbstractReportObjectScene) {
            return ((AbstractReportObjectScene)w.getScene()).getJasperDesign();
        }
        return null;
    }

    private ErrorsLayer findErrorsLayer(Widget w, boolean create) {
        Scene scene = w.getScene();
        List layers = scene.getChildren();
        for (Widget layer : layers) {
            if (!(layer instanceof ErrorsLayer)) continue;
            return (ErrorsLayer)layer;
        }
        ErrorsLayer errLayer = null;
        if (create) {
            errLayer = new ErrorsLayer(scene);
            scene.addChild((Widget)errLayer);
            scene.validate();
        }
        return errLayer;
    }

    private ErrorWidget findErrorWidget(Widget w) {
        ErrorsLayer layer = this.findErrorsLayer(w, false);
        if (layer == null) {
            return null;
        }
        List widgets = layer.getChildren();
        for (Widget widget : widgets) {
            if (!(widget instanceof ErrorWidget) || ((ErrorWidget)widget).getReferringWidget() != w) continue;
            return (ErrorWidget)widget;
        }
        return null;
    }
}

