/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriterHelper;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.templates.AbstractReportGenerator;
import com.jaspersoft.ireport.designer.utils.ImageExpressionFileResolver;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;

public class DefaultReportGenerator
extends AbstractReportGenerator {
    public FileObject generateReport(WizardDescriptor wizard) {
        Misc.log("Inside generateReport");
        try {
            Misc.log("Generating design ...");
            JasperDesign jasperDesign = this.generateDesign(wizard);
            Misc.log("Generating design OK ...");
            File f = this.getFile(wizard);
            Misc.log("get the file ...");
            Misc.log("The file store the generated report is " + f);
            if (!f.exists()) {
                f.createNewFile();
            }
            String compatibility = IReportManager.getPreferences().get("compatibility", "");
            String content = "";
            content = compatibility.length() == 0 ? JRXmlWriter.writeReport((JRReport)jasperDesign, (String)"UTF-8") : JRXmlWriterHelper.writeReport((JRReport)jasperDesign, "UTF-8", compatibility);
            PrintWriter pw = new PrintWriter(new FileOutputStream(f.getPath()));
            pw.write(content);
            pw.close();
            JasperCompileManager.writeReportToXmlFile((JRReport)jasperDesign, (String)f.getPath());
            return FileUtil.toFileObject((File)f);
        }
        catch (Exception ex) {
            Misc.log("Exception generating the file ...", ex);
            return null;
        }
    }

    protected File getFile(WizardDescriptor wizard) throws Exception {
        File f = null;
        String fname = null;
        String directory = null;
        if (wizard.getProperty("filename") != null) {
            f = new File("" + wizard.getProperty("filename"));
            if (wizard instanceof TemplateWizard) {
                DataFolder df = ((TemplateWizard)wizard).getTargetFolder();
                if (df == null || df.getPrimaryFile() == null || !Misc.getDataFolderPath(df).equals(f.getParent())) {
                    directory = f.getParent();
                }
                if (((TemplateWizard)wizard).getTargetName() == null || !((TemplateWizard)wizard).getTargetName().equals(f.getName())) {
                    fname = f.getName();
                }
            }
        }
        if (wizard instanceof TemplateWizard && ((TemplateWizard)wizard).getTargetFolder() != null) {
            if (fname == null) {
                fname = ((TemplateWizard)wizard).getTargetName();
            }
            if (directory == null) {
                directory = Misc.getDataFolderPath(((TemplateWizard)wizard).getTargetFolder());
            }
            if (fname == null) {
                fname = "Report.jrxml";
                f = new File(directory, fname);
                int i = 1;
                while (f.exists()) {
                    fname = "Report_" + i + ".jrxml";
                    f = new File(directory, fname);
                    ++i;
                }
            } else {
                f = new File(directory, fname);
            }
            if (((TemplateWizard)wizard).getTargetName() == null || !((TemplateWizard)wizard).getTargetName().equals(fname)) {
                // empty if block
            }
        }
        if (f == null) {
            throw new Exception("Filename not specified");
        }
        return f;
    }

    protected JasperDesign generateDesign(WizardDescriptor wizard) throws Exception {
        JRDesignTextField fieldElement;
        JRDesignStaticText labelElement;
        FileObject reportTemplate = (FileObject)wizard.getProperty("reportTemplate");
        String reportType = (String)wizard.getProperty("reportType");
        ArrayList selectedFields = (ArrayList)wizard.getProperty("selectedFields");
        ArrayList groupFields = (ArrayList)wizard.getProperty("groupFields");
        String query = (String)wizard.getProperty("query");
        String queryLanguage = (String)wizard.getProperty("queryLanguage");
        JasperDesign jasperDesign = JRXmlLoader.load((InputStream)reportTemplate.getInputStream());
        jasperDesign.setName("" + wizard.getProperty("reportname"));
        if (reportType == null) {
            reportType = "tabular";
        }
        if (jasperDesign.getProperty("template.type") != null) {
            reportType = jasperDesign.getProperty("template.type");
        }
        boolean keepExtraGroups = false;
        boolean noLayoutChanges = false;
        if (wizard.getProperty("noFields") != null && wizard.getProperty("noFields").equals("true")) {
            noLayoutChanges = true;
        }
        if (jasperDesign.getProperty("template.keepExtraGroups") != null && jasperDesign.getProperty("template.keepExtraGroups").equals("true")) {
            keepExtraGroups = true;
        }
        jasperDesign.getProperty("");
        if (selectedFields == null) {
            selectedFields = new ArrayList();
        }
        if (groupFields == null) {
            groupFields = new ArrayList();
        }
        for (JRDesignField f : selectedFields) {
            jasperDesign.addField((JRField)f);
        }
        if (query != null) {
            JRDesignQuery designQuery = new JRDesignQuery();
            designQuery.setText(query);
            if (queryLanguage != null) {
                designQuery.setLanguage(queryLanguage);
            }
            jasperDesign.setQuery(designQuery);
        }
        for (int i = 0; i < groupFields.size(); ++i) {
            JRDesignTextField tf;
            if (jasperDesign.getGroupsList().size() <= i) {
                JRDesignGroup g = new JRDesignGroup();
                g.setName(((JRDesignField)groupFields.get(i)).getName());
                jasperDesign.addGroup(g);
            }
            JRDesignGroup group = (JRDesignGroup)jasperDesign.getGroupsList().get(i);
            group.setName(((JRDesignField)groupFields.get(i)).getName());
            group.setExpression((JRExpression)Misc.createExpression("java.lang.Object", "$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}"));
            if (group.getGroupHeaderSection() == null || group.getGroupHeaderSection().getBands()[0] == null) continue;
            JRBand groupHeaderSection = group.getGroupHeaderSection().getBands()[0];
            JRDesignStaticText st = DefaultReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "G" + (i + 1) + "Label");
            if (st == null) {
                st = DefaultReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "GroupLabel");
            }
            if (st == null) {
                st = DefaultReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group Label");
            }
            if (st == null) {
                st = DefaultReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "Label");
            }
            if (st == null) {
                st = DefaultReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group name");
            }
            if (st != null) {
                st.setText(((JRDesignField)groupFields.get(i)).getName());
            }
            if ((tf = DefaultReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "G" + (i + 1) + "Field")) == null) {
                tf = DefaultReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "GroupField");
            }
            if (tf == null) {
                tf = DefaultReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "Group Field");
            }
            if (tf == null) {
                tf = DefaultReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "Field");
            }
            if (tf == null) continue;
            JRDesignExpression expression = Misc.createExpression(((JRDesignField)groupFields.get(i)).getValueClassName(), "$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}");
            CreateTextFieldAction.setMatchingClassExpression(expression, ((JRDesignField)groupFields.get(i)).getValueClassName(), true);
            tf.setExpression((JRExpression)expression);
        }
        if (!keepExtraGroups && !noLayoutChanges) {
            while (groupFields.size() < jasperDesign.getGroupsList().size()) {
                jasperDesign.removeGroup((JRGroup)((JRDesignGroup)jasperDesign.getGroupsList().get(groupFields.size())));
            }
        }
        if (!noLayoutChanges && reportType != null && reportType.equals("tabular")) {
            int cols;
            JRDesignBand columnHeaderBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRBand detailBand = jasperDesign.getDetailSection().getBands()[0];
            labelElement = DefaultReportGenerator.findStaticTextElement((JRElementGroup)columnHeaderBand, "DetailLabel");
            if (labelElement == null) {
                labelElement = DefaultReportGenerator.findStaticTextElement((JRElementGroup)columnHeaderBand, "Label");
            }
            if (labelElement == null) {
                labelElement = DefaultReportGenerator.findStaticTextElement((JRElementGroup)columnHeaderBand, "Header");
            }
            if ((fieldElement = DefaultReportGenerator.findTextFieldElement((JRElementGroup)detailBand, "DetailField")) == null) {
                fieldElement = DefaultReportGenerator.findTextFieldElement((JRElementGroup)detailBand, "Field");
            }
            System.out.println("Unable to find in the detail band a field with exp DetailField or Field");
            System.out.flush();
            if (labelElement != null) {
                columnHeaderBand = labelElement.getElementGroup();
                this.removeElement((JRElementGroup)columnHeaderBand, (JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBand = fieldElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBand, (JRDesignElement)fieldElement);
            }
            int width = jasperDesign.getPageWidth() - jasperDesign.getRightMargin() - jasperDesign.getLeftMargin();
            if (detailBand instanceof JRDesignFrame) {
                width = ((JRDesignFrame)detailBand).getWidth();
            }
            if ((cols = selectedFields.size() - groupFields.size()) > 0) {
                width /= cols;
                int currentX = 0;
                for (JRDesignField f : selectedFields) {
                    if (groupFields.contains(f)) continue;
                    if (labelElement != null) {
                        JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                        newLabel.setText(f.getName());
                        newLabel.setX(currentX);
                        newLabel.setWidth(width);
                        this.addElement((JRElementGroup)columnHeaderBand, (JRDesignElement)newLabel);
                    }
                    if (fieldElement != null) {
                        JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                        JRDesignExpression expression = Misc.createExpression(f.getValueClassName(), "$F{" + f.getName() + "}");
                        CreateTextFieldAction.setMatchingClassExpression(expression, f.getValueClassName(), true);
                        newTextField.setExpression((JRExpression)expression);
                        newTextField.setX(currentX);
                        newTextField.setWidth(width);
                        this.addElement((JRElementGroup)detailBand, (JRDesignElement)newTextField);
                    }
                    currentX += width;
                }
            }
        } else if (!noLayoutChanges && reportType != null && reportType.equals("columnar")) {
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetailSection().getBands()[0];
            JRDesignBand detailBandField = (JRDesignBand)jasperDesign.getDetailSection().getBands()[0];
            labelElement = DefaultReportGenerator.findStaticTextElement((JRElementGroup)detailBand, "DetailLabel");
            if (labelElement == null) {
                labelElement = DefaultReportGenerator.findStaticTextElement((JRElementGroup)detailBand, "Label");
            }
            if (labelElement == null) {
                labelElement = DefaultReportGenerator.findStaticTextElement((JRElementGroup)detailBand, "Header");
            }
            if ((fieldElement = DefaultReportGenerator.findTextFieldElement((JRElementGroup)detailBandField, "DetailField")) == null) {
                fieldElement = DefaultReportGenerator.findTextFieldElement((JRElementGroup)detailBandField, "Field");
            }
            if (labelElement != null) {
                detailBand = labelElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBand, (JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBandField = fieldElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBandField, (JRDesignElement)fieldElement);
            }
            int currentY = 0;
            int rowHeight = 0;
            if (labelElement != null) {
                rowHeight = labelElement.getHeight();
            }
            if (fieldElement != null) {
                rowHeight = Math.max(rowHeight, fieldElement.getHeight());
            }
            for (File f : selectedFields) {
                if (groupFields.contains(f)) continue;
                if (labelElement != null) {
                    JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                    newLabel.setText(f.getName());
                    newLabel.setY(currentY);
                    this.addElement((JRElementGroup)detailBand, (JRDesignElement)newLabel);
                }
                if (fieldElement != null) {
                    JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                    JRDesignExpression expression = Misc.createExpression(f.getValueClassName(), "$F{" + f.getName() + "}");
                    CreateTextFieldAction.setMatchingClassExpression(expression, f.getValueClassName(), true);
                    newTextField.setExpression((JRExpression)expression);
                    newTextField.setY(currentY);
                    this.addElement((JRElementGroup)detailBandField, (JRDesignElement)newTextField);
                }
                currentY += rowHeight;
            }
            this.setGroupHeight((JRElementGroup)detailBand, currentY);
            this.setGroupHeight((JRElementGroup)detailBandField, currentY);
        }
        List<JRDesignElement> elements = ModelUtils.getAllElements(jasperDesign);
        for (JRDesignElement ele : elements) {
            File destFile;
            File reportFolder;
            ImageExpressionFileResolver fr;
            File file;
            JRDesignImage imgelement;
            File f;
            if (!(ele instanceof JRDesignImage) || (imgelement = (JRDesignImage)ele).getExpression() == null || !imgelement.getExpression().getValueClassName().equals("java.lang.String") || (file = FileUtil.toFile((FileObject)reportTemplate)).getParentFile() == null || (f = (fr = new ImageExpressionFileResolver(imgelement, (reportFolder = file.getParentFile()) + "", jasperDesign)).resolveFile(null)) == null) continue;
            JRDesignExpression exp = Misc.createExpression("java.lang.String", "\"" + f.getName() + "\"");
            imgelement.setExpression((JRExpression)exp);
            File destFolder = this.getFile(wizard).getParentFile();
            if (destFolder == null || (destFile = new File(destFolder, f.getName())).exists()) continue;
            Misc.copyFile(f, destFile);
        }
        return jasperDesign;
    }

    public void removeElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).removeElement(element);
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).removeElement((JRElement)element);
        }
    }

    public void addElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElement(element);
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElement((JRElement)element);
        }
    }

    private void setGroupHeight(JRElementGroup container, int currentY) {
        if (container instanceof JRDesignBand) {
            ((JRDesignBand)container).setHeight(Math.max(currentY, ((JRDesignBand)container).getHeight()));
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).setHeight(Math.max(currentY, ((JRDesignFrame)container).getHeight()));
        }
    }
}

