/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.openide.nodes.PropertySupport;

public final class FontNameProperty
extends PropertySupport.ReadWrite
implements PreferenceChangeListener {
    private final JRBaseStyle style;
    PropertyEditor editor = null;

    public FontNameProperty(JRBaseStyle style) {
        super("fontName", String.class, I18n.getString("AbstractStyleNode.Property.Font_name"), I18n.getString("Font_name"));
        this.style = style;
        this.setValue("canEditAsText", true);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", false);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.style.getFontName();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof String) {
            String oldValue = this.style.getOwnFontName();
            String newValue = (String)val;
            this.style.setFontName(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "FontName", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.style.getOwnFontName() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    private void updateTags() {
        ArrayList<Tag> classes = new ArrayList<Tag>();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
        Collection extensionFonts = JRFontUtil.getFontFamilyNames();
        for (String fname : extensionFonts) {
            classes.add(new Tag(fname));
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        if (IReportManager.getPreferences().getBoolean("showSystemFonts", true)) {
            String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            classes.add(new Tag(null, "__________"));
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                classes.add(new Tag(name));
            }
        }
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(true, classes);
        } else {
            ((ComboBoxPropertyEditor)this.editor).setTagValues(classes);
        }
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.updateTags();
        }
        return this.editor;
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt == null || evt.getKey() == null || evt.getKey().equals("IREPORT_CLASSPATH")) {
            this.updateTags();
        }
    }
}

