/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors.box;

import com.jaspersoft.ireport.designer.sheet.editors.box.BorderSelectionListener;
import com.jaspersoft.ireport.designer.sheet.editors.box.BoxBorderSelectionPanel;
import com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel;
import com.jaspersoft.ireport.designer.sheet.editors.box.LineStyleListCellRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxPanel
extends JPanel
implements ActionListener,
BorderSelectionListener {
    private boolean init = false;
    private int dialogResult = 2;
    private SpinnerNumberModel spinnedModel = null;
    private DefaultListModel styleListModel = null;
    private JRLineBox lineBox = null;
    private ColorSelectorPanel colorSelector;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JButton jButtonReset;
    private JButton jButtonRestoreDefaults;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelBorderEditorContainer;
    private JPanel jPanelButtons;
    private JPanel jPanelColorSelector;
    private JPanel jPanelPreview;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerBottom;
    private JSpinner jSpinnerLeft;
    private JSpinner jSpinnerLineWidth;
    private JSpinner jSpinnerRight;
    private JSpinner jSpinnerTop;
    private BoxBorderSelectionPanel selectionPanel;
    JDialog dialog = null;

    public BoxBorderSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public void setSelectionPanel(BoxBorderSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setLineBox(JRLineBox lineBox) {
        boolean oldInit = this.isInit();
        this.setInit(true);
        this.lineBox = lineBox;
        this.getSelectionPanel().clearSelection();
        this.getSelectionPanel().setLineBox(lineBox);
        this.getSelectionPanel().repaint();
        if (lineBox != null) {
            this.jSpinnerBottom.setValue(lineBox.getBottomPadding());
            this.jSpinnerTop.setValue(lineBox.getTopPadding());
            this.jSpinnerLeft.setValue(lineBox.getLeftPadding());
            this.jSpinnerRight.setValue(lineBox.getRightPadding());
        } else {
            this.jSpinnerBottom.setValue(0);
            this.jSpinnerTop.setValue(0);
            this.jSpinnerLeft.setValue(0);
            this.jSpinnerRight.setValue(0);
        }
        this.setInit(oldInit);
        this.selectionChanged(this.getSelectionPanel().getSelectedBorders());
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public BoxPanel() {
        this.initComponents();
        this.jPanelButtons.setVisible(false);
        this.colorSelector.setColor(null);
        this.colorSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxPanel.this.colorChanged();
            }
        });
        this.spinnedModel = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.25);
        this.jSpinnerLineWidth.setModel(this.spinnedModel);
        this.spinnedModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BoxPanel.this.widthChanged();
            }
        });
        this.jSpinnerLineWidth.setFont(UIManager.getFont("TextField.font"));
        this.jList1.setCellRenderer(new LineStyleListCellRenderer());
        this.styleListModel = new DefaultListModel();
        this.jList1.setModel(this.styleListModel);
        this.styleListModel.addElement(new Byte(0));
        this.styleListModel.addElement(new Byte(1));
        this.styleListModel.addElement(new Byte(2));
        this.styleListModel.addElement(new Byte(3));
        this.jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BoxPanel.this.lineStyleChanged();
            }
        });
        this.init = true;
        SpinnerNumberModel snmTop = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerTop.setModel(snmTop);
        snmTop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerTopStateChanged(evt);
            }
        });
        SpinnerNumberModel snmBottom = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerBottom.setModel(snmBottom);
        snmBottom.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerBottomStateChanged(evt);
            }
        });
        SpinnerNumberModel snmRight = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerRight.setModel(snmRight);
        snmRight.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerRightStateChanged(evt);
            }
        });
        SpinnerNumberModel snmLeft = new SpinnerNumberModel(0, 0, 10000, 1);
        this.jSpinnerLeft.setModel(snmLeft);
        snmLeft.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPanel.this.jSpinnerLeftStateChanged(evt);
            }
        });
        this.init = false;
        this.selectionPanel.addBorderSelectionListener(this);
    }

    private void jSpinnerTopStateChanged(ChangeEvent evt) {
        this.getLineBox().setTopPadding(Integer.parseInt(this.jSpinnerTop.getValue() + ""));
    }

    private void jSpinnerLeftStateChanged(ChangeEvent evt) {
        this.getLineBox().setLeftPadding(Integer.parseInt(this.jSpinnerLeft.getValue() + ""));
    }

    private void jSpinnerRightStateChanged(ChangeEvent evt) {
        this.getLineBox().setRightPadding(Integer.parseInt(this.jSpinnerRight.getValue() + ""));
    }

    private void jSpinnerBottomStateChanged(ChangeEvent evt) {
        this.getLineBox().setBottomPadding(Integer.parseInt(this.jSpinnerBottom.getValue() + ""));
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinnerLeft = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jSpinnerTop = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jSpinnerRight = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jSpinnerBottom = new JSpinner();
        this.jPanelBorderEditorContainer = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanelPreview = new JPanel();
        this.selectionPanel = new BoxBorderSelectionPanel();
        this.jButtonRestoreDefaults = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinnerLineWidth = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel2 = new JLabel();
        this.jPanelColorSelector = new JPanel();
        this.colorSelector = new ColorSelectorPanel();
        this.jPanelButtons = new JPanel();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonReset = new JButton();
        this.setMinimumSize(new Dimension(309, 80));
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Padding"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel3.setText(I18n.getString("BoxPanel.Label.Left"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jSpinnerLeft.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerLeft.setPreferredSize(new Dimension(50, 20));
        this.jSpinnerLeft.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BoxPanel.this.jSpinnerLeftPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerLeft, gridBagConstraints);
        this.jLabel4.setText(I18n.getString("BoxPanel.Label.Top"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jSpinnerTop.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerTop.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerTop, gridBagConstraints);
        this.jLabel5.setText(I18n.getString("BoxPanel.Label.Right"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jSpinnerRight.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerRight.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerRight, gridBagConstraints);
        this.jLabel6.setText(I18n.getString("BoxPanel.Label.Bottom"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jSpinnerBottom.setMinimumSize(new Dimension(50, 20));
        this.jSpinnerBottom.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jSpinnerBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanelBorderEditorContainer.setBorder(BorderFactory.createTitledBorder("Borders"));
        this.jPanelBorderEditorContainer.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanelPreview.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelPreview.setMinimumSize(new Dimension(120, 80));
        this.jPanelPreview.setPreferredSize(new Dimension(120, 80));
        this.jPanelPreview.setLayout(new BorderLayout());
        this.jPanelPreview.add((Component)this.selectionPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel3.add((Component)this.jPanelPreview, gridBagConstraints);
        this.jButtonRestoreDefaults.setText(I18n.getString("BoxPanel.Button.RestoreDefaults"));
        this.jButtonRestoreDefaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonRestoreDefaultsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jButtonRestoreDefaults, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(200, 150));
        this.jPanel4.setPreferredSize(new Dimension(200, 150));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText(I18n.getString("BoxPanel.Label.LineWidth"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        this.jSpinnerLineWidth.setMinimumSize(new Dimension(120, 20));
        this.jSpinnerLineWidth.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.jPanel4.add((Component)this.jSpinnerLineWidth, gridBagConstraints);
        this.jLabel7.setText(I18n.getString("BoxPanel.Label.LineStyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(120, 80));
        this.jScrollPane1.setPreferredSize(new Dimension(120, 80));
        this.jList1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText(I18n.getString("BoxPanel.Label.LineColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanelColorSelector.setBackground(new Color(255, 255, 255));
        this.jPanelColorSelector.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        this.jPanelColorSelector.setMinimumSize(new Dimension(50, 20));
        this.jPanelColorSelector.setPreferredSize(new Dimension(120, 20));
        this.jPanelColorSelector.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelColorSelector.add((Component)this.colorSelector, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.jPanel4.add((Component)this.jPanelColorSelector, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelBorderEditorContainer.add((Component)this.jPanel1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 6, 6);
        this.add((Component)this.jPanelBorderEditorContainer, gridBagConstraints);
        this.jButtonCancel.setText(I18n.getString("Global.Button.Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText(I18n.getString("Global.Button.Ok"));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonReset.setText(I18n.getString("Global.Button.Reset"));
        this.jButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPanel.this.jButtonResetActionPerformed(evt);
            }
        });
        GroupLayout jPanelButtonsLayout = new GroupLayout((Container)this.jPanelButtons);
        this.jPanelButtons.setLayout((LayoutManager)jPanelButtonsLayout);
        jPanelButtonsLayout.setHorizontalGroup((GroupLayout.Group)jPanelButtonsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelButtonsLayout.createSequentialGroup().addContainerGap(137, Short.MAX_VALUE).add((Component)this.jButtonOk, -2, 67, -2).addPreferredGap(0).add((Component)this.jButtonCancel).addPreferredGap(0).add((Component)this.jButtonReset, -2, 67, -2).add(9, 9, 9)));
        jPanelButtonsLayout.setVerticalGroup((GroupLayout.Group)jPanelButtonsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelButtonsLayout.createSequentialGroup().add((GroupLayout.Group)jPanelButtonsLayout.createParallelGroup(3).add((Component)this.jButtonReset).add((Component)this.jButtonCancel).add((Component)this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.jPanelButtons, gridBagConstraints);
    }

    private void jSpinnerLeftPropertyChange(PropertyChangeEvent evt) {
    }

    private void jButtonRestoreDefaultsActionPerformed(ActionEvent evt) {
        if (this.lineBox == null) {
            return;
        }
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            this.resetPen((JRPen)this.getLineBox().getPen());
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    this.resetPen((JRPen)this.getLineBox().getTopPen());
                    break;
                }
                case LEFT: {
                    this.resetPen((JRPen)this.getLineBox().getLeftPen());
                    break;
                }
                case BOTTOM: {
                    this.resetPen((JRPen)this.getLineBox().getBottomPen());
                    break;
                }
                case RIGHT: {
                    this.resetPen((JRPen)this.getLineBox().getRightPen());
                }
            }
        }
        this.selectionChanged(borders);
        this.getSelectionPanel().repaint();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.setDialogResult(0);
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.setDialogResult(2);
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.setLineBox((JRLineBox)new JRBaseLineBox(null));
    }

    @Override
    public void selectionChanged(List<BoxBorderSelectionPanel.Side> selectedBorders) {
        if (this.isInit() || this.lineBox == null) {
            return;
        }
        this.setInit(true);
        boolean sameWidth = true;
        boolean sameStyle = true;
        boolean sameColor = true;
        boolean first = true;
        this.spinnedModel.setValue(0.0);
        this.colorSelector.setColor(null);
        this.jList1.clearSelection();
        if (selectedBorders.size() == 0) {
            JRBoxPen pen = this.getLineBox().getPen();
            this.spinnedModel.setValue(pen.getLineWidth().doubleValue());
            this.colorSelector.setColor(pen.getLineColor());
            if (pen.getLineStyle() != null) {
                this.jList1.setSelectedValue(pen.getLineStyle(), true);
            }
        }
        for (BoxBorderSelectionPanel.Side s : selectedBorders) {
            JRBoxPen pen = null;
            if (this.getLineBox() != null) {
                switch (s) {
                    case TOP: {
                        pen = this.getLineBox().getTopPen();
                        break;
                    }
                    case BOTTOM: {
                        pen = this.getLineBox().getBottomPen();
                        break;
                    }
                    case RIGHT: {
                        pen = this.getLineBox().getRightPen();
                        break;
                    }
                    case LEFT: {
                        pen = this.getLineBox().getLeftPen();
                    }
                }
            }
            if (pen == null) continue;
            if (first) {
                this.spinnedModel.setValue(pen.getLineWidth().doubleValue());
                this.colorSelector.setColor(pen.getLineColor());
                if (pen.getLineStyle() != null) {
                    this.jList1.setSelectedValue(pen.getLineStyle(), true);
                }
            } else {
                Byte b;
                if (sameWidth && pen.getLineWidth().floatValue() != this.spinnedModel.getNumber().floatValue()) {
                    sameWidth = false;
                }
                if (sameColor && (pen.getLineColor() == null || !pen.getLineColor().equals(this.colorSelector.getColor()))) {
                    sameColor = false;
                    this.colorSelector.setColor(null);
                }
                if (sameStyle && (b = (Byte)this.jList1.getSelectedValue()) != pen.getLineStyle()) {
                    sameStyle = false;
                    this.jList1.clearSelection();
                }
            }
            first = false;
        }
        this.setInit(false);
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireActionListenerActionPerformed(e);
    }

    public void resetPen(JRPen pen) {
        if (pen == null) {
            return;
        }
        pen.setLineColor(null);
        pen.setLineStyle(null);
        pen.setLineWidth(null);
    }

    public void widthChanged() {
        if (this.isInit() || this.lineBox == null) {
            return;
        }
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            JRBoxPen pen = this.lineBox.getPen();
            pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    JRBoxPen pen = this.lineBox.getTopPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
                case LEFT: {
                    JRBoxPen pen = this.lineBox.getLeftPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
                case BOTTOM: {
                    JRBoxPen pen = this.lineBox.getBottomPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
                case RIGHT: {
                    JRBoxPen pen = this.lineBox.getRightPen();
                    pen.setLineWidth(this.spinnedModel.getNumber().floatValue());
                    break;
                }
            }
        }
        this.getSelectionPanel().repaint();
    }

    public void colorChanged() {
        if (this.isInit() || this.lineBox == null) {
            return;
        }
        Color color = this.colorSelector.getColor();
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            JRBoxPen pen = this.lineBox.getPen();
            pen.setLineColor(color);
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    JRBoxPen pen = this.lineBox.getTopPen();
                    if (pen == null) break;
                    pen.setLineColor(color);
                    break;
                }
                case LEFT: {
                    JRBoxPen pen = this.lineBox.getLeftPen();
                    if (pen == null) break;
                    pen.setLineColor(color);
                    break;
                }
                case BOTTOM: {
                    JRBoxPen pen = this.lineBox.getBottomPen();
                    if (pen == null) break;
                    pen.setLineColor(color);
                    break;
                }
                case RIGHT: {
                    JRBoxPen pen = this.lineBox.getRightPen();
                    if (pen == null) break;
                    pen.setLineColor(color);
                    break;
                }
            }
        }
        this.getSelectionPanel().repaint();
    }

    public void lineStyleChanged() {
        if (this.isInit() || this.lineBox == null) {
            return;
        }
        Byte style = null;
        if (this.jList1.getSelectedIndex() >= 0) {
            style = (Byte)this.jList1.getSelectedValue();
        }
        ArrayList<BoxBorderSelectionPanel.Side> borders = new ArrayList<BoxBorderSelectionPanel.Side>();
        borders.addAll(this.selectionPanel.getSelectedBorders());
        if (borders.size() == 0) {
            JRBoxPen pen = this.lineBox.getPen();
            pen.setLineStyle(style);
            borders.add(BoxBorderSelectionPanel.Side.TOP);
            borders.add(BoxBorderSelectionPanel.Side.BOTTOM);
            borders.add(BoxBorderSelectionPanel.Side.LEFT);
            borders.add(BoxBorderSelectionPanel.Side.RIGHT);
        }
        for (BoxBorderSelectionPanel.Side s : borders) {
            switch (s) {
                case TOP: {
                    JRBoxPen pen = this.lineBox.getTopPen();
                    pen.setLineStyle(style);
                    break;
                }
                case LEFT: {
                    JRBoxPen pen = this.lineBox.getLeftPen();
                    pen.setLineStyle(style);
                    break;
                }
                case BOTTOM: {
                    JRBoxPen pen = this.lineBox.getBottomPen();
                    pen.setLineStyle(style);
                    break;
                }
                case RIGHT: {
                    JRBoxPen pen = this.lineBox.getRightPen();
                    pen.setLineStyle(style);
                    break;
                }
            }
        }
        this.getSelectionPanel().repaint();
    }

    public JRLineBox showDialog(JRLineBox box) {
        this.setLineBox(box);
        this.getJPanelButtons().setVisible(true);
        this.dialog = new JDialog(Misc.getMainFrame(), true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
        if (this.getDialogResult() == 0) {
            return this.getLineBox();
        }
        return null;
    }

    public JPanel getJPanelButtons() {
        return this.jPanelButtons;
    }

    public void setJPanelButtons(JPanel jPanelButtons) {
        this.jPanelButtons = jPanelButtons;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

