/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compatibility;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;

public class VersionWarningDialog
extends JDialog {
    public static int DIALOG_RESULT_KEEP_VERSION = 1;
    public static int DIALOG_RESULT_USE_LAST_VERSION = 2;
    private int dialogResult = DIALOG_RESULT_KEEP_VERSION;
    private JButton jButtonLastVersion;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxNoAgain;
    private JLabel jLabelWarning;
    private JSeparator jSeparator1;

    public VersionWarningDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jLabelWarning.setText(I18n.getString("VersionWarningDialog.jLabelWarning.text"));
        this.jCheckBoxNoAgain.setText(I18n.getString("VersionWarningDialog.jCheckBoxNoAgain.text"));
        this.jButtonLastVersion.setText(I18n.getString("VersionWarningDialog.jButtonLastVersion.text"));
        this.jButtonOk.setText(I18n.getString("VersionWarningDialog.jButtonOk.text"));
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jLabelWarning = new JLabel();
        this.jCheckBoxNoAgain = new JCheckBox();
        this.jButtonLastVersion = new JButton();
        this.jButtonOk = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("\"Compatibility warning\"");
        this.jLabelWarning.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/info.png")));
        this.jLabelWarning.setText("<html>This report may contain formatting or content that cannot be saved in JasperReports {0}. Do you want to save the report using keeping the compatibility with this version anyway?<br><br>Use the latest JasperReports version to be sure all formatting and content is saved correctly.");
        this.jLabelWarning.setVerticalAlignment(1);
        this.jLabelWarning.setIconTextGap(10);
        this.jCheckBoxNoAgain.setText("Don't show this dialog again");
        this.jButtonLastVersion.setText("Save using the latest version");
        this.jButtonLastVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VersionWarningDialog.this.jButtonLastVersionActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("Keep this version");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VersionWarningDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSeparator1, -1, 498, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(80, Short.MAX_VALUE).add((Component)this.jCheckBoxNoAgain, -2, 385, -2).add(33, 33, 33)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelWarning, -1, 478, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add(85, 85, 85).add((Component)this.jButtonOk).addPreferredGap(0).add((Component)this.jButtonLastVersion).addContainerGap(121, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelWarning, -2, 103, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOk).add((Component)this.jButtonLastVersion)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jCheckBoxNoAgain)));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setDialogResult(DIALOG_RESULT_KEEP_VERSION);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonLastVersionActionPerformed(ActionEvent evt) {
        this.setDialogResult(DIALOG_RESULT_USE_LAST_VERSION);
        this.setVisible(false);
        this.dispose();
    }

    public void setVersion(String version) {
        String v = version.replace('_', '.');
        this.jLabelWarning.setText(I18n.getString("VersionWarningDialog.jLabelWarning.text", (Object)v));
    }

    public boolean askAgain() {
        return !this.jCheckBoxNoAgain.isSelected();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

