/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets;

import com.jaspersoft.ireport.designer.charts.datasets.PieSeriesPanel;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;

public class PieSeriesDialog
extends JDialog {
    private JRDesignPieSeries pieSeries = new JRDesignPieSeries();
    private PieSeriesPanel pieSeriesPanel = null;
    private ExpressionContext expressionContext = null;
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JPanel jPanel6;
    private JPanel jPanel7;

    public PieSeriesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pieSeriesPanel = new PieSeriesPanel();
        this.getContentPane().add((Component)this.pieSeriesPanel, "Center");
        this.setSize(500, 500);
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PieSeriesDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.pieSeriesPanel.setExpressionContext(ec);
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Time period series");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                PieSeriesDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieSeriesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PieSeriesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel6, "South");
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.pieSeries == null) {
            return;
        }
        if (Misc.getExpressionText(this.pieSeries.getKeyExpression()).trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("PieSeriesDialog.invalidKeyExpression"), I18n.getString("Global.validationError"), 0);
            return;
        }
        if (Misc.getExpressionText(this.pieSeries.getValueExpression()).trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("PieSeriesDialog.invalidValueExpression"), I18n.getString("Global.validationError"), 0);
            return;
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JRDesignPieSeries getPieSeries() {
        return this.pieSeries;
    }

    public void setPieSeries(JRDesignPieSeries originalPieSeries) {
        this.pieSeries = (JRDesignPieSeries)originalPieSeries.clone();
        this.pieSeriesPanel.setPieSeries(this.pieSeries);
    }
}

