/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.design.JRDesignBand;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class MaximizeBandAction
extends NodeAction {
    public String getName() {
        return I18n.getString("MaximizeBandAction.Name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        JRDesignBand band = ((BandNode)activatedNodes[0]).getBand();
        int height = ModelUtils.getMaxBandHeight(band, ((BandNode)activatedNodes[0]).getJasperDesign());
        int oldValue = band.getHeight();
        if (oldValue < height) {
            band.setHeight(height);
            ObjectPropertyUndoableEdit undo = new ObjectPropertyUndoableEdit(band, "Height", Integer.TYPE, oldValue, height);
            IReportManager.getInstance().addUndoableEdit(undo);
            IReportManager.getInstance().notifyReportChange();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0] instanceof BandNode;
    }
}

