/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.api.model;

import java.beans.FeatureDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.openide.ErrorManager;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class GrammarQueryManager {
    private static Reference instance;

    public abstract Enumeration enabled(GrammarEnvironment var1);

    public abstract GrammarQuery getGrammar(GrammarEnvironment var1);

    public abstract FeatureDescriptor getDescriptor();

    public static synchronized GrammarQueryManager getDefault() {
        DefaultQueryManager defaultQueryManager;
        DefaultQueryManager defaultQueryManager2 = defaultQueryManager = instance != null ? (DefaultQueryManager)instance.get() : null;
        if (defaultQueryManager == null) {
            defaultQueryManager = new DefaultQueryManager();
            instance = new WeakReference<DefaultQueryManager>(defaultQueryManager);
        }
        return defaultQueryManager;
    }

    private static class DefaultQueryManager
    extends GrammarQueryManager {
        private static final String FOLDER = "Plugins/XML/GrammarQueryManagers";
        private Lookup.Result registrations;
        private static ThreadLocal<GrammarQueryManager> transaction = new ThreadLocal();

        private DefaultQueryManager() {
        }

        public FeatureDescriptor getDescriptor() {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor();
            featureDescriptor.setHidden(true);
            featureDescriptor.setName(this.getClass().getName());
            return featureDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GrammarQuery getGrammar(GrammarEnvironment grammarEnvironment) {
            try {
                GrammarQueryManager grammarQueryManager = transaction.get();
                if (grammarQueryManager != null) {
                    Object object;
                    GrammarQuery grammarQuery = grammarQueryManager.getGrammar(grammarEnvironment);
                    if (grammarQuery == null) {
                        object = ErrorManager.getDefault();
                        object.log(16, "Broken contract: " + grammarQueryManager.getClass());
                    }
                    object = grammarQuery;
                    return object;
                }
                ErrorManager errorManager = ErrorManager.getDefault();
                IllegalStateException illegalStateException = new IllegalStateException("Broken contract");
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                illegalStateException.printStackTrace(printWriter);
                printWriter.flush();
                errorManager.log(16, stringWriter.getBuffer().toString());
                GrammarQuery grammarQuery = null;
                return grammarQuery;
            }
            finally {
                transaction.set(null);
            }
        }

        public Enumeration enabled(GrammarEnvironment grammarEnvironment) {
            Iterator iterator = this.getRegistrations();
            transaction.set(null);
            ArrayList arrayList = new ArrayList(5);
            Object[] objectArray = grammarEnvironment.getDocumentChildren();
            while (objectArray.hasMoreElements()) {
                arrayList.add(objectArray.nextElement());
            }
            objectArray = arrayList.toArray();
            while (iterator.hasNext()) {
                GrammarEnvironment grammarEnvironment2;
                GrammarQueryManager grammarQueryManager = (GrammarQueryManager)iterator.next();
                Enumeration enumeration = grammarQueryManager.enabled(grammarEnvironment2 = new GrammarEnvironment(Enumerations.array((Object[])objectArray), grammarEnvironment.getInputSource(), grammarEnvironment.getFileObject()));
                if (enumeration == null) continue;
                transaction.set(grammarQueryManager);
                return enumeration;
            }
            return null;
        }

        private synchronized Iterator getRegistrations() {
            if (this.registrations != null) {
                return this.registrations.allInstances().iterator();
            }
            this.registrations = Lookups.forPath((String)FOLDER).lookupResult(GrammarQueryManager.class);
            return this.registrations.allInstances().iterator();
        }
    }
}

