/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProblemDetails;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.spi.impl.ErrorPanel;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.ProblemComponent;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.netbeans.modules.refactoring.spi.impl.UndoWatcher;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ParametersPanel
extends JPanel
implements ProgressListener,
ChangeListener,
InvalidationListener {
    private static final Logger LOGGER = Logger.getLogger(ParametersPanel.class.getName());
    private final Object RESULT_LOCK = new Object();
    private RefactoringSession result;
    private final RefactoringUI rui;
    private final JPanel customPanel;
    private final CustomRefactoringPanel customComponent;
    private transient JDialog dialog = null;
    private ArrayList components = null;
    private Problem problem;
    private ErrorPanel errorPanel;
    private final int PRE_CHECK = 0;
    private final int INPUT_PARAMETERS = 1;
    private final int POST_CHECK = 2;
    private final int CHECK_PARAMETERS = 3;
    private transient int currentState = 1;
    private boolean cancelRequest = false;
    private JButton back;
    private JPanel buttonsPanel;
    public JButton cancel;
    private JPanel containerPanel;
    private JPanel controlsPanel;
    private JButton help;
    private JPanel innerPanel;
    private JLabel label;
    private JButton next;
    private JLabel pleaseWait;
    private JButton previewButton;
    private JPanel progressPanel;
    private ProblemDetails currentProblemAction;
    private ProgressBar progressBar;
    private ProgressHandle progressHandle;
    private boolean isIndeterminate;

    public void setPreviewEnabled(boolean bl) {
        RefactoringPanel.checkEventThread();
        this.next.setEnabled(bl && !this.isPreviewRequired());
    }

    public ParametersPanel(RefactoringUI refactoringUI) {
        RefactoringPanel.checkEventThread();
        this.rui = refactoringUI;
        this.initComponents();
        HelpCtx helpCtx = this.getHelpCtx();
        this.help.setEnabled(helpCtx != null && helpCtx != HelpCtx.DEFAULT_HELP);
        this.innerPanel.setBorder(null);
        this.label.setText(" ");
        this.customComponent = refactoringUI.getPanel(this);
        this.customPanel = this.customComponent != null ? (JPanel)this.customComponent.getComponent() : null;
        this.errorPanel = new ErrorPanel(refactoringUI);
        this.calculatePrefferedSize();
        this.setButtonsEnabled(false);
    }

    private void calculatePrefferedSize() {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.progressPanel.getPreferredSize();
        Dimension dimension3 = new Dimension(0, 0);
        if (this.customPanel != null) {
            dimension = this.customPanel.getPreferredSize();
        }
        if (this.errorPanel != null) {
            dimension3 = this.errorPanel.getPreferredSize();
        }
        this.setPreferredSize(new Dimension(Math.max(Math.max(dimension.width, dimension2.width), dimension3.width), Math.max(dimension.height, dimension3.height) + dimension2.height));
        if (this.dialog != null && this.rui.isQuery()) {
            this.dialog.setSize(this.getPreferredSize());
        }
    }

    private void initComponents() {
        this.progressPanel = new JPanel();
        this.innerPanel = new JPanel();
        this.label = new JLabel();
        this.controlsPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.back = new JButton();
        this.previewButton = new JButton();
        this.previewButton.setVisible(false);
        this.next = new JButton();
        this.cancel = new JButton();
        this.help = new JButton();
        this.containerPanel = new JPanel();
        this.pleaseWait = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/spi/impl/Bundle");
        this.setName(resourceBundle.getString("LBL_FindUsagesDialog"));
        this.setLayout(new BorderLayout());
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 11));
        this.progressPanel.setOpaque(false);
        this.progressPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.innerPanel.setLayout(new BorderLayout());
        this.label.setHorizontalAlignment(4);
        this.innerPanel.add((Component)this.label, "West");
        this.progressPanel.add((Component)this.innerPanel, "Center");
        this.controlsPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.controlsPanel.setLayout(new BorderLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonsPanel.setLayout(new GridLayout(1, 0, 4, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.back, (String)NbBundle.getBundle((String)"org/netbeans/modules/refactoring/spi/impl/Bundle").getString("CTL_Back"));
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.backActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.back);
        this.back.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Back"));
        Mnemonics.setLocalizedText((AbstractButton)this.previewButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"CTL_PreviewAll"));
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.preview(actionEvent);
            }
        });
        this.buttonsPanel.add(this.previewButton);
        this.previewButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.previewButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.next, (String)NbBundle.getBundle((String)"org/netbeans/modules/refactoring/spi/impl/Bundle").getString("CTL_Finish"));
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.refactor(actionEvent);
            }
        });
        this.buttonsPanel.add(this.next);
        this.next.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_finish"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancel, (String)NbBundle.getBundle((String)"org/netbeans/modules/refactoring/spi/impl/Bundle").getString("CTL_Cancel"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.cancelActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.cancel);
        this.cancel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_cancel"));
        Mnemonics.setLocalizedText((AbstractButton)this.help, (String)NbBundle.getBundle((String)"org/netbeans/modules/refactoring/spi/impl/Bundle").getString("CTL_Help"));
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.helpActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.help);
        this.help.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_help"));
        this.controlsPanel.add((Component)this.buttonsPanel, "East");
        this.progressPanel.add((Component)this.controlsPanel, "South");
        this.add((Component)this.progressPanel, "South");
        this.containerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.containerPanel.setLayout(new BorderLayout());
        this.pleaseWait.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.pleaseWait, (String)NbBundle.getBundle((String)"org/netbeans/modules/refactoring/spi/impl/Bundle").getString("LBL_PleaseWait"));
        this.containerPanel.add((Component)this.pleaseWait, "Center");
        this.pleaseWait.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParametersPanel.class, (String)"LBL_PleaseWait"));
        this.add((Component)this.containerPanel, "Center");
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_FindUsagesDialog"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FindUsagesDialog"));
    }

    private void preview(ActionEvent actionEvent) {
        this.refactor(true);
    }

    private void helpActionPerformed(ActionEvent actionEvent) {
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        help.showHelp(this.getHelpCtx());
    }

    private void backActionPerformed(ActionEvent actionEvent) {
        this.placeCustomPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelActionPerformed(ActionEvent actionEvent) {
        ParametersPanel parametersPanel = this;
        synchronized (parametersPanel) {
            if (actionEvent != null && actionEvent.getSource() instanceof Cancellable) {
                this.putResult(null);
                this.dialog.setVisible(false);
            } else {
                this.rui.getRefactoring().cancelRequest();
                this.putResult(null);
                this.dialog.setVisible(false);
                this.cancelRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refactor(final boolean bl) {
        LOGGER.finest("refactor - currentState=" + this.currentState);
        if (this.currentState == 0) {
            LOGGER.finest("refactor - PRE_CHECK");
            this.placeCustomPanel();
            return;
        }
        if (this.currentState == 2 && bl && this.currentProblemAction != null) {
            LOGGER.finest("refactor - POST_CHECK - problems");
            Cancellable cancellable = new Cancellable(){

                public boolean cancel() {
                    ParametersPanel.this.cancelActionPerformed(new ActionEvent(this, 0, null));
                    return true;
                }
            };
            this.currentProblemAction.showDetails(new ProblemComponent.CallbackAction(this.rui), cancellable);
            return;
        }
        this.setPanelEnabled(false);
        this.cancel.setEnabled(true);
        RequestProcessor requestProcessor = new RequestProcessor();
        final int n = this.currentState;
        if (this.currentState != 0 && this.currentState != 2) {
            if (this.rui instanceof RefactoringUIBypass && ((RefactoringUIBypass)((Object)this.rui)).isRefactoringBypassRequired()) {
                LOGGER.finest("refactor - bypass");
                try {
                    ((RefactoringUIBypass)((Object)this.rui)).doRefactoringBypass();
                }
                catch (IOException iOException) {
                    this.currentState = 2;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeErrorPanel(new Problem(true, iOException.getMessage()));
                        }
                    });
                }
                finally {
                    if (n == this.currentState) {
                        this.setVisibleLater(false);
                    }
                    return;
                }
            }
            if (this.currentState != 2 && this.currentState != 3) {
                this.putResult(RefactoringSession.create(this.rui.getName()));
                requestProcessor.post((Runnable)new Prepare());
            } else if (this.currentState == 3) {
                requestProcessor.post((Runnable)new Prepare());
            }
        }
        LOGGER.finest("refactor - asynchronously");
        requestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOGGER.finest("refactor - inputState=" + n + ", currentState=" + ParametersPanel.this.currentState);
                if (n == ParametersPanel.this.currentState) {
                    try {
                        RefactoringSession refactoringSession = ParametersPanel.this.getResult();
                        if (!bl && refactoringSession != null) {
                            UndoWatcher.watch(refactoringSession, ParametersPanel.this);
                            refactoringSession.addProgressListener(ParametersPanel.this);
                            refactoringSession.doRefactoring(true);
                            UndoWatcher.stopWatching(ParametersPanel.this);
                        }
                    }
                    finally {
                        if (!bl) {
                            ParametersPanel.this.putResult(null);
                        }
                        if (n == ParametersPanel.this.currentState) {
                            ParametersPanel.this.setVisibleLater(false);
                        }
                    }
                }
            }
        });
    }

    private void refactor(ActionEvent actionEvent) {
        this.refactor(this.rui.isQuery());
    }

    private void setVisibleLater(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParametersPanel.this.dialog.setVisible(bl);
            }
        });
    }

    private void setPanelEnabled(boolean bl) {
        RefactoringPanel.checkEventThread();
        this.setButtonsEnabled(bl);
        if (bl) {
            if (this.components == null) {
                return;
            }
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((Component)iterator.next()).setEnabled(true);
            }
            this.components = null;
        } else {
            if (this.components != null) {
                return;
            }
            this.components = new ArrayList();
            this.disableComponents(this.customPanel);
        }
    }

    private void disableComponents(Container container) {
        RefactoringPanel.checkEventThread();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i].isEnabled()) {
                componentArray[i].setEnabled(false);
                this.components.add(componentArray[i]);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            this.disableComponents((Container)componentArray[i]);
        }
    }

    public synchronized RefactoringSession showDialog() {
        RefactoringPanel.checkEventThread();
        if (this.rui != null) {
            this.rui.getRefactoring().addProgressListener(this);
        }
        String string = this.customPanel != null && this.customPanel.getName() != null && !"".equals(this.customPanel.getName()) ? this.customPanel.getName() : this.rui.getName();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string, true, new Object[0], null, 0, null, null);
        this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.validate();
        if (this.customPanel != null) {
            this.dialog.getAccessibleContext().setAccessibleName(this.rui.getName());
            this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_FindUsagesDialog"));
        }
        this.setCancelStuff();
        this.dialog.pack();
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ParametersPanel.this.problem = ParametersPanel.this.rui.getRefactoring().preCheck();
                }
                catch (RuntimeException runtimeException) {
                    ParametersPanel.this.setVisibleLater(false);
                    throw runtimeException;
                }
                if (ParametersPanel.this.problem != null) {
                    ParametersPanel.this.currentState = 0;
                    if (!ParametersPanel.this.problem.isFatal()) {
                        ParametersPanel.this.customComponent.initialize();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeErrorPanel(ParametersPanel.this.problem);
                            ParametersPanel.this.dialog.setVisible(true);
                        }
                    });
                } else {
                    if (ParametersPanel.this.customPanel != null) {
                        ParametersPanel.this.customComponent.initialize();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ParametersPanel.this.placeCustomPanel();
                        }
                    });
                    if (!ParametersPanel.this.rui.hasParameters()) {
                        RefactoringSession refactoringSession = ParametersPanel.this.putResult(RefactoringSession.create(ParametersPanel.this.rui.getName()));
                        try {
                            ParametersPanel.this.rui.getRefactoring().prepare(refactoringSession);
                        }
                        finally {
                            ParametersPanel.this.setVisibleLater(false);
                        }
                    }
                }
            }
        });
        if (this.customComponent != null || this.rui.hasParameters() || APIAccessor.DEFAULT.hasPluginsWithProgress(this.rui.getRefactoring())) {
            this.dialog.setVisible(true);
        }
        this.dialog.dispose();
        if (this.rui != null) {
            this.rui.getRefactoring().removeProgressListener(this);
        }
        if (!this.cancelRequest) {
            task.waitFinished();
        }
        RefactoringSession refactoringSession = this.getResult();
        this.putResult(null);
        return refactoringSession;
    }

    private final void setCancelStuff() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        String string = "cancel";
        this.getRootPane().getInputMap(1).put(keyStroke, string);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ParametersPanel.this.cancel.isEnabled()) {
                    ParametersPanel.this.cancelActionPerformed(actionEvent);
                }
            }
        };
        this.getRootPane().getActionMap().put(string, abstractAction);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (ParametersPanel.this.cancel.isEnabled()) {
                    ParametersPanel.this.cancelActionPerformed(null);
                }
            }
        });
    }

    private ProblemDetails getDetails(Problem problem) {
        if (problem.getNext() == null) {
            return problem.getDetails();
        }
        return null;
    }

    private void placeErrorPanel(Problem problem) {
        this.containerPanel.removeAll();
        this.errorPanel = new ErrorPanel(problem, this.rui);
        this.errorPanel.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.containerPanel.add((Component)this.errorPanel, "Center");
        this.next.setEnabled(!problem.isFatal() && !this.isPreviewRequired());
        this.dialog.getRootPane().setDefaultButton(this.next);
        if (this.currentState == 0) {
            Mnemonics.setLocalizedText((AbstractButton)this.next, (String)NbBundle.getMessage(ParametersPanel.class, (String)"CTL_Next"));
            this.back.setVisible(false);
        } else {
            ProblemDetails problemDetails = this.getDetails(problem);
            if (problemDetails != null) {
                Mnemonics.setLocalizedText((AbstractButton)this.previewButton, (String)problemDetails.getDetailsHint());
                this.previewButton.setVisible(true);
                this.previewButton.setEnabled(true);
                this.currentProblemAction = problemDetails;
            }
            this.back.setVisible(true);
            this.back.setEnabled(true);
            this.dialog.getRootPane().setDefaultButton(this.back);
            if (problemDetails != null) {
                this.setPreferredSize(null);
                this.dialog.pack();
            }
        }
        this.cancel.setEnabled(true);
        this.previewButton.setEnabled(!problem.isFatal());
        if (this.progressHandle != null) {
            this.stop(null);
        }
        this.repaint();
    }

    private void placeCustomPanel() {
        if (this.customPanel == null) {
            return;
        }
        Mnemonics.setLocalizedText((AbstractButton)this.next, (String)NbBundle.getMessage(ParametersPanel.class, (String)(this.rui.isQuery() ? "CTL_Find" : "CTL_Finish")));
        Mnemonics.setLocalizedText((AbstractButton)this.previewButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"CTL_PreviewAll"));
        this.customPanel.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.containerPanel.removeAll();
        this.containerPanel.add((Component)this.customPanel, "Center");
        this.back.setVisible(false);
        this.previewButton.setVisible(!this.rui.isQuery());
        Boolean bl = this.rui.getRefactoring().getContext().lookup(Boolean.class);
        this.next.setEnabled(!this.isPreviewRequired());
        this.currentState = 1;
        this.setPanelEnabled(true);
        this.cancel.setEnabled(true);
        this.dialog.getRootPane().setDefaultButton(this.next);
        if (this.customPanel.isEnabled()) {
            this.customPanel.requestFocus();
        }
        this.setOKorRefactor();
        this.repaint();
    }

    private boolean isPreviewRequired() {
        UI.Constants constants = this.rui.getRefactoring().getContext().lookup(UI.Constants.class);
        return constants != null && constants == UI.Constants.REQUEST_PREVIEW;
    }

    public void start(final ProgressEvent progressEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string;
                ParametersPanel.this.progressPanel.remove(ParametersPanel.this.innerPanel);
                ParametersPanel.this.progressBar = ProgressBar.create(ParametersPanel.this.progressHandle = ProgressHandleFactory.createHandle((String)""));
                ParametersPanel.this.progressPanel.add((Component)ParametersPanel.this.progressBar, "Center");
                if (progressEvent.getCount() == -1) {
                    ParametersPanel.this.isIndeterminate = true;
                    ParametersPanel.this.progressHandle.start();
                    ParametersPanel.this.progressHandle.switchToIndeterminate();
                } else {
                    ParametersPanel.this.isIndeterminate = false;
                    ParametersPanel.this.progressHandle.start(progressEvent.getCount());
                }
                switch (progressEvent.getOperationType()) {
                    case 2: {
                        string = NbBundle.getMessage(ParametersPanel.class, (String)"LBL_ParametersCheck");
                        break;
                    }
                    case 3: {
                        string = NbBundle.getMessage(ParametersPanel.class, (String)"LBL_Prepare");
                        break;
                    }
                    case 1: {
                        string = NbBundle.getMessage(ParametersPanel.class, (String)"LBL_PreCheck");
                        break;
                    }
                    default: {
                        string = NbBundle.getMessage(ParametersPanel.class, (String)"LBL_Usages");
                    }
                }
                ParametersPanel.this.progressBar.setString(string);
                ParametersPanel.this.progressPanel.setVisible(true);
                ParametersPanel.this.setButtonsEnabled(false);
            }
        });
    }

    public void step(final ProgressEvent progressEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (ParametersPanel.this.progressHandle == null) {
                        return;
                    }
                    ParametersPanel.this.progressHandle.progress(ParametersPanel.this.isIndeterminate ? -2 : progressEvent.getCount());
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(1, throwable);
                }
            }
        });
    }

    public void stop(ProgressEvent progressEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ParametersPanel.this.progressHandle == null) {
                    return;
                }
                ParametersPanel.this.progressHandle.finish();
                ParametersPanel.this.progressPanel.remove(ParametersPanel.this.progressBar);
                ParametersPanel.this.progressPanel.add((Component)ParametersPanel.this.innerPanel, "Center");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.rui instanceof RefactoringUIBypass && ((RefactoringUIBypass)((Object)this.rui)).isRefactoringBypassRequired()) {
            this.showProblem(null);
        } else {
            this.showProblem(this.rui.checkParameters());
        }
        this.setOKorRefactor();
    }

    private void setOKorRefactor() {
        if (this.rui instanceof RefactoringUIBypass) {
            if (((RefactoringUIBypass)((Object)this.rui)).isRefactoringBypassRequired()) {
                this.next.setText(NbBundle.getMessage(DialogDisplayer.class, (String)"CTL_OK"));
                this.previewButton.setVisible(false);
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this.next, (String)NbBundle.getMessage(ParametersPanel.class, (String)(this.rui.isQuery() ? "CTL_Find" : "CTL_Finish")));
                this.previewButton.setVisible(true);
            }
        }
    }

    private void showProblem(Problem problem) {
        if (problem == null) {
            this.label.setText(" ");
            this.innerPanel.setBorder(null);
            this.next.setEnabled(!this.isPreviewRequired());
            this.previewButton.setEnabled(true);
            return;
        }
        this.innerPanel.setBorder(new LineBorder(Color.gray));
        this.progressPanel.setVisible(true);
        if (problem.isFatal()) {
            this.displayError(problem.getMessage());
        } else {
            this.displayWarning(problem.getMessage());
        }
    }

    private void displayError(String string) {
        this.next.setEnabled(false);
        this.previewButton.setEnabled(false);
        this.label.setText("<html><font color=\"red\">" + NbBundle.getMessage(ParametersPanel.class, (String)"LBL_Error") + ": </font>" + string + "</html>");
    }

    private void displayWarning(String string) {
        this.next.setEnabled(!this.isPreviewRequired());
        this.previewButton.setEnabled(true);
        this.label.setText("<html><font color=\"red\">" + NbBundle.getMessage(ParametersPanel.class, (String)"LBL_Warning") + ": </font>" + string + "</html>");
    }

    private void setButtonsEnabled(boolean bl) {
        this.next.setEnabled(bl && !this.isPreviewRequired());
        this.back.setEnabled(bl);
        this.previewButton.setEnabled(bl);
    }

    public HelpCtx getHelpCtx() {
        return this.rui.getHelpCtx();
    }

    public void invalidateObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringSession getResult() {
        Object object = this.RESULT_LOCK;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringSession putResult(RefactoringSession refactoringSession) {
        Object object = this.RESULT_LOCK;
        synchronized (object) {
            this.result = refactoringSession;
        }
        return refactoringSession;
    }

    private static class ProgressBar
    extends JPanel {
        private JLabel label;

        private static ProgressBar create(ProgressHandle progressHandle) {
            ProgressBar progressBar = new ProgressBar();
            progressBar.setLayout(new BorderLayout());
            progressBar.label = new JLabel();
            progressBar.label.setBorder(new EmptyBorder(0, 0, 2, 0));
            progressBar.add((Component)progressBar.label, "North");
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            progressBar.add((Component)jComponent, "Center");
            return progressBar;
        }

        public void setString(String string) {
            this.label.setText(string);
        }

        private ProgressBar() {
        }
    }

    private class Prepare
    implements Runnable {
        private Prepare() {
        }

        public void run() {
            if (ParametersPanel.this.currentState != 2 && ParametersPanel.this.currentState != 3) {
                ParametersPanel.this.problem = ParametersPanel.this.rui.setParameters();
                if (ParametersPanel.this.problem != null && ParametersPanel.this.currentState != 2) {
                    ParametersPanel.this.currentState = 3;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                ParametersPanel.this.placeErrorPanel(ParametersPanel.this.problem);
                            }
                        });
                    }
                    catch (Exception exception) {
                        throw (RuntimeException)new RuntimeException().initCause(exception);
                    }
                    return;
                }
            }
            try {
                ParametersPanel.this.problem = ParametersPanel.this.rui.getRefactoring().prepare(ParametersPanel.this.getResult());
            }
            catch (RuntimeException runtimeException) {
                ParametersPanel.this.setVisibleLater(false);
                throw runtimeException;
            }
            if (ParametersPanel.this.problem != null) {
                ParametersPanel.this.currentState = 2;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ParametersPanel.this.placeErrorPanel(ParametersPanel.this.problem);
                    }
                });
            }
        }
    }
}

