/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileDeletePlugin
implements RefactoringPlugin {
    private SafeDeleteRefactoring refactoring;

    public FileDeletePlugin(SafeDeleteRefactoring safeDeleteRefactoring) {
        this.refactoring = safeDeleteRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        for (FileObject fileObject : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            refactoringElementsBag.addFileChange(this.refactoring, new DeleteFile(fileObject, refactoringElementsBag));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    static class DeleteFile
    extends SimpleRefactoringElementImplementation {
        private final URL res;
        private String filename;
        private RefactoringElementsBag session;
        BackupFacility.Handle id;

        public DeleteFile(FileObject fileObject, RefactoringElementsBag refactoringElementsBag) {
            try {
                this.res = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new IllegalStateException(fileStateInvalidException);
            }
            this.filename = fileObject.getNameExt();
            this.session = refactoringElementsBag;
        }

        public String getText() {
            return NbBundle.getMessage(FileDeletePlugin.class, (String)"TXT_DeleteFile", (Object)this.filename);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)this.res);
                if (fileObject == null) {
                    throw new IOException(this.res.toString());
                }
                this.id = BackupFacility.getDefault().backup(fileObject);
                DataObject.find((FileObject)fileObject).delete();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void undoChange() {
            try {
                this.id.restore();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.res);
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

