/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class ExtFormatter
extends Formatter
implements FormatLayer {
    private List formatLayerList = new ArrayList();
    private static final Object NULL_VALUE = new Object();
    private final HashMap settingsMap = new HashMap();
    private Acceptor indentHotCharsAcceptor;
    private boolean reindentWithTextBefore;
    private final String mimeType;
    private final Preferences prefs;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || "indent-hot-chars-acceptor".equals(string)) {
                ExtFormatter.this.indentHotCharsAcceptor = (Acceptor)SettingsConversions.callFactory(ExtFormatter.this.prefs, MimePath.parse((String)ExtFormatter.this.mimeType), "indent-hot-chars-acceptor", AcceptorFactory.FALSE);
            }
            if (string == null || "reindent-with-text-before".equals(string)) {
                ExtFormatter.this.reindentWithTextBefore = ExtFormatter.this.prefs.getBoolean("reindent-with-text-before", false);
            }
        }
    };

    public ExtFormatter(Class clazz) {
        super(clazz);
        this.initFormatLayers();
        this.mimeType = BaseKit.getKit(clazz).getContentType();
        this.prefs = (Preferences)MimeLookup.getLookup((String)this.mimeType).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
    }

    protected void initFormatLayers() {
    }

    public String getName() {
        return this.getKitClass().getName().substring(this.getKitClass().getName().lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSettingValue(String string) {
        Object object;
        Object object2 = this.settingsMap;
        synchronized (object2) {
            object = this.settingsMap.get(string);
            if (object != null) {
                return object != NULL_VALUE ? object : null;
            }
        }
        try {
            object2 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            object = ((ClassLoader)object2).loadClass("org.netbeans.editor.Settings");
            Method method = ((Class)object).getMethod("getValue", Class.class, String.class);
            return method.invoke(null, this.getKitClass(), string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettingValue(String string, Object object) {
        HashMap hashMap = this.settingsMap;
        synchronized (hashMap) {
            this.settingsMap.put(string, object == null ? NULL_VALUE : object);
        }
    }

    public synchronized void addFormatLayer(FormatLayer formatLayer) {
        this.formatLayerList.add(formatLayer);
    }

    public synchronized boolean replaceFormatLayer(String string, FormatLayer formatLayer) {
        int n = this.formatLayerList.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(((FormatLayer)this.formatLayerList.get(i)).getName())) continue;
            this.formatLayerList.set(i, formatLayer);
            return true;
        }
        return false;
    }

    public synchronized void removeFormatLayer(String string) {
        Iterator iterator = this.formatLayerIterator();
        while (iterator.hasNext()) {
            if (!string.equals(((FormatLayer)iterator.next()).getName())) continue;
            iterator.remove();
            return;
        }
    }

    public Iterator formatLayerIterator() {
        return this.formatLayerList.iterator();
    }

    public boolean isSimple() {
        return false;
    }

    public synchronized void format(FormatWriter formatWriter) {
        boolean bl = false;
        int n = 0;
        do {
            formatWriter.setChainModified(false);
            formatWriter.setRestartFormat(false);
            Iterator iterator = this.formatLayerIterator();
            while (iterator.hasNext()) {
                ((FormatLayer)iterator.next()).format(formatWriter);
                if (!formatWriter.isRestartFormat()) continue;
            }
            if (!iterator.hasNext() && !formatWriter.isRestartFormat()) {
                bl = true;
            }
            if (n <= 1000) continue;
            new Exception("Indentation infinite loop detected").printStackTrace();
            break;
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        ExtFormatter.pushFormattingContextDocument(baseDocument);
        try {
            Object object;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            Writer writer = this.createWriter(baseDocument, n, charArrayWriter);
            FormatWriter formatWriter = writer instanceof FormatWriter ? (FormatWriter)writer : null;
            boolean bl2 = true;
            if (formatWriter != null) {
                formatWriter.setIndentOnly(bl);
                if (bl2) {
                    formatWriter.setReformatting(true);
                }
            }
            writer.write(baseDocument.getChars(n, n2 - n));
            writer.close();
            if (!bl2 || formatWriter == null) {
                object = new String(charArrayWriter.toCharArray());
                baseDocument.remove(n, n2 - n);
                baseDocument.insertString(n, (String)object, null);
            }
            object = writer;
            return object;
        }
        finally {
            ExtFormatter.popFormattingContextDocument(baseDocument);
        }
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        try {
            Position position = baseDocument.createPosition(n2);
            this.reformat(baseDocument, n, n2, false);
            return position.getOffset() - n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        if (this.indentHotCharsAcceptor == null) {
            this.prefsListener.preferenceChange(null);
        }
        if (this.indentHotCharsAcceptor.accept(string.charAt(0))) {
            if (!this.reindentWithTextBefore && this.hasTextBefore(jTextComponent, string)) {
                return null;
            }
            int n = jTextComponent.getCaret().getDot();
            return new int[]{Math.max(n - 1, 0), n};
        }
        return null;
    }

    protected boolean hasTextBefore(JTextComponent jTextComponent, String string) {
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        try {
            int n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
            return n != n2 + string.length();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        return new FormatWriter(this, document, n, writer, false);
    }

    public int indentLine(Document document, int n) {
        if (document instanceof BaseDocument) {
            try {
                BaseDocument baseDocument = (BaseDocument)document;
                int n2 = Utilities.getRowStart(baseDocument, n);
                int n3 = Utilities.getRowStart(baseDocument, n, 1);
                if (n3 < 0) {
                    n3 = baseDocument.getLength();
                }
                this.reformat(baseDocument, n2, n3, false);
                return Utilities.getRowEnd(baseDocument, n2);
            }
            catch (GuardedException guardedException) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            catch (IOException iOException) {
                Utilities.annotateLoggable(iOException);
            }
            return n;
        }
        return super.indentLine(document, n);
    }

    protected int getEOLOffset(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getRowEnd(baseDocument, n);
    }

    public int indentNewLine(Document document, int n) {
        final int[] nArray = new int[]{n};
        if (document instanceof BaseDocument) {
            final BaseDocument baseDocument = (BaseDocument)document;
            baseDocument.runAtomicAsUser(new Runnable(){

                public void run() {
                    boolean bl = false;
                    try {
                        baseDocument.insertString(nArray[0], "\n", null);
                        nArray[0] = nArray[0] + 1;
                        bl = true;
                        int n = Utilities.getRowEnd(baseDocument, nArray[0]);
                        Writer writer = ExtFormatter.this.reformat(baseDocument, nArray[0], n, true);
                        n = Utilities.getRowFirstNonWhite(baseDocument, nArray[0]);
                        if (n < 0) {
                            n = ExtFormatter.this.getEOLOffset(baseDocument, nArray[0]);
                        }
                        nArray[0] = n;
                        if (writer instanceof FormatWriter) {
                            nArray[0] = nArray[0] + ((FormatWriter)writer).getIndentShift();
                        }
                    }
                    catch (GuardedException guardedException) {
                        if (!bl) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Utilities.annotateLoggable(badLocationException);
                    }
                    catch (IOException iOException) {
                        Utilities.annotateLoggable(iOException);
                    }
                }
            });
        } else {
            try {
                document.insertString(nArray[0], "\n", null);
                nArray[0] = nArray[0] + 1;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return nArray[0];
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return true;
    }

    static void pushFormattingContextDocument(Document document) {
        try {
            Method method = Formatter.class.getDeclaredMethod("pushFormattingContextDocument", Document.class);
            method.setAccessible(true);
            method.invoke(null, document);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void popFormattingContextDocument(Document document) {
        try {
            Method method = Formatter.class.getDeclaredMethod("popFormattingContextDocument", Document.class);
            method.setAccessible(true);
            method.invoke(null, document);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Simple
    extends ExtFormatter {
        public Simple(Class clazz) {
            super(clazz);
        }

        public boolean isSimple() {
            return true;
        }

        protected int getEOLOffset(BaseDocument baseDocument, int n) throws BadLocationException {
            return n;
        }
    }
}

