/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.xml.text.completion.NodeSelector;
import org.netbeans.modules.xml.text.syntax.XMLDefaultSyntax;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLKit
extends NbEditorKit
implements HelpCtx.Provider {
    private static final long serialVersionUID = 5326735092324267367L;
    public static final String MIME_TYPE = "text/xml";
    public static final String xmlCommentAction = "xml-comment";
    public static final String xmlUncommentAction = "xml-uncomment";
    public static final String xmlTestAction = "xml-dump";
    public static Map settings;
    private static final boolean J2EE_LEXER_COLORING;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(XMLKit.class);
    }

    public Syntax createSyntax(Document document) {
        return new XMLDefaultSyntax();
    }

    public Document createDefaultDocument() {
        if (J2EE_LEXER_COLORING) {
            XMLEditorDocument xMLEditorDocument = new XMLEditorDocument(this.getContentType());
            xMLEditorDocument.putProperty(Language.class, XMLTokenId.language());
            return xMLEditorDocument;
        }
        return super.createDefaultDocument();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new XMLSyntaxSupport(baseDocument);
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        if (Boolean.getBoolean("netbeans.experimental.xml.nodeselectors")) {
            new NodeSelector(jEditorPane);
        }
    }

    public static void setMap(Map map) {
        settings = map;
    }

    public Map getMap() {
        return settings;
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new XMLCommentAction(), new XMLUncommentAction(), new TestAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    static {
        J2EE_LEXER_COLORING = Boolean.getBoolean("j2ee_lexer_coloring");
    }

    public class XMLEditorDocument
    extends NbEditorDocument {
        public XMLEditorDocument(Class clazz) {
            super(clazz);
        }

        public XMLEditorDocument(String string) {
            super(string);
        }

        public boolean addLayer(DrawLayer drawLayer, int n) {
            if (!(drawLayer instanceof DrawLayerFactory.SyntaxLayer)) {
                return super.addLayer(drawLayer, n);
            }
            return false;
        }
    }

    public static class TestAction
    extends XMLEditorAction {
        private static final long serialVersionUID = 4004056745446099L;

        public TestAction() {
            super(XMLKit.xmlTestAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                this.problem(null);
                return;
            }
            Caret caret = jTextComponent.getCaret();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            try {
                baseDocument.dump(System.out);
                if (jTextComponent == null) {
                    throw new BadLocationException(null, 0);
                }
            }
            catch (BadLocationException badLocationException) {
                this.problem(null);
            }
        }
    }

    public static class XMLUncommentAction
    extends XMLEditorAction {
        private static final String commentStartString = "<!--";
        private static final String commentEndString = "-->";
        private static final char[] commentStart = new char[]{'<', '!', '-', '-'};
        private static final char[] commentEnd = new char[]{'-', '-', '>'};
        static final long serialVersionUID = 40040567454546061L;

        public XMLUncommentAction() {
            super(XMLKit.xmlUncommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block12: {
                if (jTextComponent == null) {
                    return;
                }
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    this.problem(null);
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                try {
                    if (caret.isSelectionVisible()) {
                        int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                        int n2 = jTextComponent.getSelectionEnd();
                        baseDocument.atomicLock();
                        try {
                            if (n2 > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) == n2) {
                                --n2;
                            }
                            int n3 = n;
                            for (int i = Utilities.getRowCount((BaseDocument)baseDocument, (int)n, (int)n2); i > 0; --i) {
                                char[] cArray = baseDocument.getChars(n3, 4);
                                char[] cArray2 = baseDocument.getChars(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3) - 3, 3);
                                if (cArray[0] == commentStart[0] && cArray[1] == commentStart[1] && cArray[2] == commentStart[2] && cArray[3] == commentStart[3] && cArray2[0] == commentEnd[0] && cArray2[1] == commentEnd[1] && cArray2[2] == commentEnd[2]) {
                                    baseDocument.remove(n3, 4);
                                    baseDocument.remove(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3) - 3, 3);
                                }
                                n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3, (int)1);
                            }
                            break block12;
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    char[] cArray = baseDocument.getChars(jTextComponent.getSelectionStart(), 4);
                    char[] cArray3 = baseDocument.getChars(Utilities.getRowEnd((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart()) - 3, 3);
                    if (cArray[0] == commentStart[0] && cArray[1] == commentStart[1] && cArray[2] == commentStart[2] && cArray[3] == commentStart[3] && cArray3[0] == commentEnd[0] && cArray3[1] == commentEnd[1] && cArray3[2] == commentEnd[2]) {
                        baseDocument.remove(jTextComponent.getSelectionStart(), 4);
                        baseDocument.remove(Utilities.getRowEnd((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart()) - 3, 3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.problem(null);
                }
            }
        }
    }

    public static class XMLCommentAction
    extends XMLEditorAction {
        private static final long serialVersionUID = 4004056745446061L;
        private static final String commentStartString = "<!--";
        private static final String commentEndString = "-->";

        public XMLCommentAction() {
            super(XMLKit.xmlCommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block10: {
                if (jTextComponent == null) {
                    return;
                }
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    this.problem(null);
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                try {
                    if (caret.isSelectionVisible()) {
                        int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                        int n2 = jTextComponent.getSelectionEnd();
                        baseDocument.atomicLock();
                        try {
                            if (n2 > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) == n2) {
                                --n2;
                            }
                            int n3 = n;
                            for (int i = Utilities.getRowCount((BaseDocument)baseDocument, (int)n, (int)n2); i > 0; --i) {
                                baseDocument.insertString(n3, commentStartString, null);
                                baseDocument.insertString(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3), commentEndString, null);
                                n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3, (int)1);
                            }
                            break block10;
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    baseDocument.insertString(Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart()), commentStartString, null);
                    baseDocument.insertString(Utilities.getRowEnd((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart()), commentEndString, null);
                }
                catch (BadLocationException badLocationException) {
                    this.problem(null);
                }
            }
        }
    }

    public static abstract class XMLEditorAction
    extends BaseAction {
        public XMLEditorAction(String string) {
            super(string);
            String string2 = NbBundle.getMessage(XMLKit.class, (String)string);
            if (string2 != null) {
                this.putValue("ShortDescription", string2);
            }
        }

        protected void problem(String string) {
            if (string != null) {
                StatusDisplayer.getDefault().setStatusText("Cannot proceed: " + string);
            }
            new Panel().getToolkit().beep();
        }
    }
}

