/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.editor.structure.formatting.TagBasedFormatter;
import org.netbeans.modules.xml.text.indent.XMLFormatSupport;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.javacc.lib.JJEditorSyntax;

public class XMLFormatter
extends TagBasedFormatter {
    private static final String TAG_OPENING_PREFIX = "<";
    private static final String TAG_CLOSING_PREFIX = "</";
    private static final String TAG_CLOSED_SUFFIX = "/>";
    private static final String TAG_CLOSING_SUFFIX = "/>";
    private static final Pattern VALID_TAG_NAME = Pattern.compile("[\\w+|-]*");
    private static final int WORKUNITS_MAX = 100;

    public XMLFormatter(Class clazz) {
        super(clazz);
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new XMLFormatSupport(formatWriter);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JJEditorSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
    }

    protected String extractTagName(TokenItem tokenItem) {
        String string = tokenItem.getImage();
        int n = -1;
        if (this.isOpeningTag(tokenItem)) {
            n = TAG_OPENING_PREFIX.length();
        } else if (this.isClosingTag(tokenItem)) {
            n = TAG_CLOSING_PREFIX.length();
        }
        if (n >= 0) {
            String string2 = string.substring(n);
            return string2;
        }
        return null;
    }

    protected boolean isOpeningTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith(TAG_OPENING_PREFIX) && !tokenItem.getImage().startsWith(TAG_CLOSING_PREFIX);
    }

    protected boolean isClosingTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith(TAG_CLOSING_PREFIX);
    }

    protected int getTagEndOffset(TokenItem tokenItem) {
        TokenItem tokenItem2;
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() != XMLTokenIDs.TAG; tokenItem2 = tokenItem2.getNext()) {
        }
        return tokenItem2 == null ? -1 : tokenItem2.getOffset();
    }

    protected ExtSyntaxSupport getSyntaxSupport(BaseDocument baseDocument) {
        return (XMLSyntaxSupport)baseDocument.getSyntaxSupport().get(XMLSyntaxSupport.class);
    }

    protected boolean areTagNamesEqual(String string, String string2) {
        return string.equals(string2);
    }

    protected boolean isClosingTagRequired(BaseDocument baseDocument, String string) {
        return true;
    }

    protected int getOpeningSymbolOffset(TokenItem tokenItem) {
        return tokenItem.getOffset();
    }

    protected TokenItem getTagTokenEndingAtPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        ExtSyntaxSupport extSyntaxSupport;
        TokenItem tokenItem;
        if (n >= 0 && (tokenItem = (extSyntaxSupport = this.getSyntaxSupport(baseDocument)).getTokenChain(n, n + 1)).getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().equals(">")) {
            while ((tokenItem = tokenItem.getPrevious()) != null && !this.isOpeningTag(tokenItem) && !this.isClosingTag(tokenItem)) {
            }
            return tokenItem;
        }
        return null;
    }

    protected boolean isUnformattableToken(TokenItem tokenItem) {
        return tokenItem.getTokenID() == XMLTokenIDs.BLOCK_COMMENT || tokenItem.getTokenID() == XMLTokenIDs.CDATA_SECTION;
    }

    protected boolean isUnformattableTag(String string) {
        return false;
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("xml-strip-whitespace-at-line-end-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new XMLFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            FormatTokenPosition formatTokenPosition;
            XMLFormatSupport xMLFormatSupport = (XMLFormatSupport)this.createFormatSupport(formatWriter);
            if (xMLFormatSupport.isLineStart(formatTokenPosition = xMLFormatSupport.getFormatStartPosition()) && !xMLFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if ((formatTokenPosition = xMLFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = xMLFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

