/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class FileChooser
extends JFileChooser {
    FileChooser() {
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        FileFilter fileFilter = this.getFileFilter();
        this.addChoosableFileFilter(new Filter(new String[]{".JAVA"}, NbBundle.getMessage(FileChooser.class, (String)"TXT_JavaFilter")));
        this.addChoosableFileFilter(new Filter(new String[]{".TXT"}, NbBundle.getMessage(FileChooser.class, (String)"TXT_TxtFilter")));
        this.setFileFilter(fileFilter);
    }

    public void approveSelection() {
        File[] fileArray = this.getSelectedFiles();
        ArrayList<String> arrayList = null;
        for (int i = 0; i < fileArray.length; ++i) {
            Object object = null;
            File object2 = fileArray[i];
            if (!object2.exists()) {
                object = "MSG_FileDoesNotExist";
            } else if (object2.isDirectory()) {
                object = "MSG_FileIsADirectory";
            } else if (!object2.isFile()) {
                object = "MSG_FileIsNotPlainFile";
            }
            if (object == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(fileArray.length - i);
            }
            arrayList.add(NbBundle.getMessage(FileChooser.class, (String)object, (Object)object2.getName()));
        }
        if (arrayList == null) {
            super.approveSelection();
        } else {
            JPanel jPanel = new JPanel(new GridLayout(arrayList.size(), 0, 0, 2));
            for (String string : arrayList) {
                jPanel.add(new JLabel(string));
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)jPanel, 2));
        }
    }

    private static class Filter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public Filter(String[] stringArray, String string) {
            this.extensions = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.extensions[i] = stringArray[i].toUpperCase();
            }
            this.description = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!file.getName().toUpperCase().endsWith(this.extensions[i])) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

