/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.mdxeditor.CellPropertiesDialog;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTCellPropertyNode
extends DefaultMBTNode
implements LanguageChangedListener {
    private String value;
    static ImageIcon icon = S.getAppIcon("MBTCellPropertyNode.gif");

    public MBTCellPropertyNode() {
        I18n.addOnLanguageChangedListener(this);
        this.value = "";
    }

    public String getMdx(String indent) {
        return indent + this.value;
    }

    public String toString() {
        if (this.value != null && !this.value.trim().equals("")) {
            return this.value;
        }
        return "<html><i>[" + I18n.getString("str.cellProperty") + "]</i></html>";
    }

    void setAcceptableFlavorsArray() {
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
    }

    void editValue() {
        CellPropertiesDialog dialog = new CellPropertiesDialog(null);
        this.value = dialog.getFormat();
        dialog.dispose();
    }

    public String[] getPopUpActionList() {
        return new String[]{MBTPopUpActions.CLEAR_VALUE, MBTPopUpActions.EDIT};
    }

    public void handlePopUpAction(String action, DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        if (action.equals(MBTPopUpActions.CLEAR_VALUE)) {
            this.value = "";
        } else if (action.equals(MBTPopUpActions.EDIT)) {
            this.editValue();
        }
    }

    public void setCellProperty(String cellProperty) {
        if (cellProperty != null) {
            this.value = cellProperty;
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.CLEAR_VALUE, I18n.getString("menu.clearValue"));
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.EDIT, I18n.getString("menu.editValue"));
    }
}

