/*
 * Decompiled with CFR 0.152.
 */
package rex;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import rex.event.RexWizardEvent;
import rex.event.RexWizardListener;
import rex.graphics.datasourcetree.elements.CatalogElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.graphics.mdxeditor.RexWizard;
import rex.metadata.ServerMetadata;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class TestRexWizard
extends JFrame
implements ActionListener,
RexWizardListener {
    JButton bDS = new JButton("Get DataSources");
    JButton bCat = new JButton("Get Catalogs");
    JButton bCube = new JButton("Get Cube");
    JButton bRexWiz1 = new JButton("Show Rex Wizard Dialog with information provided");
    JButton bRexWiz2 = new JButton("Show Rex Wizard Dialog with out info");
    JTextField tf = new JTextField(20);
    JTextArea taProp = new JTextArea(20, 20);
    JScrollPane sp = new JScrollPane(this.taProp);
    String[] x = new String[]{"", ""};
    JComboBox cmbDS = new JComboBox<String>(this.x);
    JComboBox cmbCat = new JComboBox<String>(this.x);
    JComboBox cmbCube = new JComboBox<String>(this.x);
    RexWizard rexWizard;

    public TestRexWizard() {
        super("Mondrian Explorer");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = env.getMaximumWindowBounds();
        Container con = this.getContentPane();
        con.setLayout(new FlowLayout());
        this.tf.setText("http://localhost:8080/mondrian/xmla");
        con.add(new JLabel("Add XMLA URL"));
        con.add(this.tf);
        con.add(this.bDS);
        con.add(this.cmbDS);
        con.add(this.bCat);
        con.add(this.cmbCat);
        con.add(this.bCube);
        con.add(this.cmbCube);
        con.add(this.bRexWiz1);
        con.add(this.bRexWiz2);
        con.add(this.sp);
        this.bDS.addActionListener(this);
        this.bCat.addActionListener(this);
        this.bCube.addActionListener(this);
        this.bRexWiz1.addActionListener(this);
        this.bRexWiz2.addActionListener(this);
        this.setSize(600, 600);
        this.setVisible(true);
    }

    public void getMdx(RexWizardEvent evt) {
        this.taProp.setText(evt.getQuery());
    }

    public void actionPerformed(ActionEvent evt) {
        String ur = this.tf.getText().trim();
        Object obj = evt.getSource();
        if (ur.equalsIgnoreCase("http://localhost:8080/mondrian/xmla")) {
            int i;
            DataSourceTreeElement[] ds;
            XMLADiscoverRestrictions restrictions;
            ServerMetadata smd;
            if (obj == this.bDS) {
                smd = new ServerMetadata(ur);
                DataSourceTreeElement[] ds2 = smd.discoverDataSources();
                this.cmbDS.removeAllItems();
                for (int i2 = 0; ds2 != null && i2 < ds2.length; ++i2) {
                    this.cmbDS.addItem(((Object)ds2[i2]).toString().trim());
                }
                this.cmbDS.repaint();
            }
            if (obj == this.bCat) {
                smd = new ServerMetadata(ur);
                restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
                XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
                properties.setDataSourceInfo((String)this.cmbDS.getSelectedItem());
                ds = (CatalogElement[])smd.getCatalogList(restrictions, properties);
                this.cmbCat.removeAllItems();
                for (i = 0; i < ds.length; ++i) {
                    this.cmbCat.addItem(((CatalogElement)ds[i]).toString().trim());
                }
                this.cmbCat.repaint();
            }
            if (obj == this.bCube) {
                smd = new ServerMetadata(ur);
                restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
                XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
                properties.setDataSourceInfo((String)this.cmbDS.getSelectedItem());
                properties.setCatalog((String)this.cmbCat.getSelectedItem());
                ds = smd.getCubeList(restrictions, properties);
                this.cmbCube.removeAllItems();
                for (i = 0; i < ds.length; ++i) {
                    System.out.println(((Object)ds[i]).toString());
                    this.cmbCube.addItem(((Object)ds[i]).toString());
                }
            }
            if (obj == this.bRexWiz1 && this.tf.getText().trim().length() > 0 && this.cmbDS.getItemCount() > 0 && this.cmbCat.getItemCount() > 0 && this.cmbCube.getItemCount() > 0) {
                this.rexWizard = new RexWizard(this.tf.getText().trim(), (String)this.cmbDS.getSelectedItem(), (String)this.cmbCat.getSelectedItem(), (String)this.cmbCube.getSelectedItem());
                this.rexWizard.addRexWizardListener(this);
                this.rexWizard.showDialog();
            }
            if (obj == this.bRexWiz2) {
                this.rexWizard = new RexWizard();
                this.rexWizard.addRexWizardListener(this);
                this.rexWizard.showDialog();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Sorry, nothing there!\n" + ur, "Add data source", 0);
        }
    }

    public static void main(String[] args) {
        new TestRexWizard();
    }
}

