/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.AnnotationManager;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.openide.text.Annotation;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesSupport
implements CaretListener {
    private static Map<JTextComponent, WeakReference<MarkOccurrencesSupport>> editorToMOS = new WeakHashMap<JTextComponent, WeakReference<MarkOccurrencesSupport>>();
    private JTextComponent editor;
    private RequestProcessor.Task parsingTask;
    private List<Highlighting.Highlight> highlights;
    private List<AnnotationManager.LanguagesAnnotation> annotations;
    private static AttributeSet highlightAS = null;

    public MarkOccurrencesSupport(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
        editorToMOS.put(jTextComponent, new WeakReference<MarkOccurrencesSupport>(this));
    }

    @Override
    public void caretUpdate(final CaretEvent caretEvent) {
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        this.parsingTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MarkOccurrencesSupport.this.refresh(caretEvent.getDot());
            }
        }, 1000);
    }

    private void refresh(int n) {
        ParserManagerImpl parserManagerImpl = ParserManagerImpl.getImpl(this.editor.getDocument());
        if (parserManagerImpl.getState() == ParserManager.State.PARSING) {
            return;
        }
        ASTNode aSTNode = parserManagerImpl.getAST();
        DatabaseContext databaseContext = DatabaseManager.getRoot(aSTNode);
        if (databaseContext == null) {
            return;
        }
        DatabaseItem databaseItem = databaseContext.getDatabaseItem(n);
        if (databaseItem == null) {
            databaseItem = databaseContext.getDatabaseItem(n - 1);
        }
        if (databaseItem == null) {
            return;
        }
        this.removeHighlights();
        this.addHighlights(MarkOccurrencesSupport.getUsages(databaseItem, aSTNode));
    }

    private void addHighlights(final List<ASTItem> list) {
        if (list.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    NbEditorDocument nbEditorDocument = (NbEditorDocument)MarkOccurrencesSupport.this.editor.getDocument();
                    Highlighting highlighting = Highlighting.getHighlighting((Document)nbEditorDocument);
                    MarkOccurrencesSupport.this.annotations = new ArrayList();
                    MarkOccurrencesSupport.this.highlights = new ArrayList();
                    Iterator iterator = list.iterator();
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    while (iterator.hasNext()) {
                        ASTItem aSTItem = (ASTItem)iterator.next();
                        Highlighting.Highlight highlight = highlighting.highlight(aSTItem.getOffset(), aSTItem.getEndOffset(), MarkOccurrencesSupport.getHighlightAS());
                        if (highlight == null) continue;
                        MarkOccurrencesSupport.this.highlights.add(highlight);
                        int n = Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)aSTItem.getOffset());
                        if (hashSet.contains(n)) continue;
                        AnnotationManager.LanguagesAnnotation languagesAnnotation = new AnnotationManager.LanguagesAnnotation("Usage", "...");
                        nbEditorDocument.addAnnotation(nbEditorDocument.createPosition(aSTItem.getOffset()), aSTItem.getLength(), (Annotation)languagesAnnotation);
                        hashSet.add(n);
                        MarkOccurrencesSupport.this.annotations.add(languagesAnnotation);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    static List<ASTItem> getUsages(DatabaseItem databaseItem, ASTNode aSTNode) {
        ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>();
        DatabaseDefinition databaseDefinition = null;
        databaseDefinition = databaseItem instanceof DatabaseDefinition ? (DatabaseDefinition)databaseItem : ((DatabaseUsage)databaseItem).getDefinition();
        if (databaseDefinition.getSourceFileUrl() == null) {
            arrayList.add(aSTNode.findPath(databaseDefinition.getOffset()).getLeaf());
        }
        for (DatabaseUsage databaseUsage : databaseDefinition.getUsages()) {
            arrayList.add(aSTNode.findPath(databaseUsage.getOffset()).getLeaf());
        }
        return arrayList;
    }

    static void removeHighlights(JTextComponent jTextComponent) {
        WeakReference<MarkOccurrencesSupport> weakReference = editorToMOS.get(jTextComponent);
        if (weakReference == null) {
            return;
        }
        MarkOccurrencesSupport markOccurrencesSupport = (MarkOccurrencesSupport)weakReference.get();
        if (markOccurrencesSupport == null) {
            return;
        }
        markOccurrencesSupport.removeHighlights();
    }

    private void removeHighlights() {
        if (this.highlights == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MarkOccurrencesSupport.this.highlights == null) {
                    return;
                }
                NbEditorDocument nbEditorDocument = (NbEditorDocument)MarkOccurrencesSupport.this.editor.getDocument();
                Iterator iterator = MarkOccurrencesSupport.this.highlights.iterator();
                while (iterator.hasNext()) {
                    ((Highlighting.Highlight)iterator.next()).remove();
                }
                Iterator iterator2 = MarkOccurrencesSupport.this.annotations.iterator();
                while (iterator2.hasNext()) {
                    nbEditorDocument.removeAnnotation((Annotation)iterator2.next());
                }
                MarkOccurrencesSupport.this.highlights = null;
                MarkOccurrencesSupport.this.annotations = null;
            }
        });
    }

    private static AttributeSet getHighlightAS() {
        if (highlightAS == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.Background, new Color(236, 235, 163));
            highlightAS = simpleAttributeSet;
        }
        return highlightAS;
    }
}

