/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.LanguagesNavigatorModel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class LanguagesNavigator
implements NavigatorPanel {
    private JComponent panelUI;
    private JTree tree;
    private MyLookupListener lookupListener;
    private DataObject dataObject;
    private JEditorPane lastEditor;
    private MyCaretListener caretListener;

    public String getDisplayHint() {
        return "This is Navigator";
    }

    public String getDisplayName() {
        return "Navigator";
    }

    public JComponent getComponent() {
        if (this.panelUI == null) {
            this.tree = new JTree(){

                public String getToolTipText(MouseEvent mouseEvent) {
                    TreePath treePath = LanguagesNavigator.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return null;
                    }
                    Object object = treePath.getLastPathComponent();
                    LanguagesNavigatorModel languagesNavigatorModel = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
                    return languagesNavigatorModel.getTooltip(object);
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            Listener listener = new Listener();
            this.tree.addMouseListener(listener);
            this.tree.addKeyListener(listener);
            this.tree.setToggleClickCount(Integer.MAX_VALUE);
            this.tree.setModel(new LanguagesNavigatorModel());
            this.tree.setCellRenderer(new Renderer());
            this.panelUI = new JScrollPane(this.tree);
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup lookup) {
        this.getComponent();
        Lookup.Result result = lookup.lookupResult(DataObject.class);
        DataObject dataObject = (DataObject)result.allInstances().iterator().next();
        if (this.lookupListener != null) {
            this.lookupListener.remove();
        }
        this.lookupListener = new MyLookupListener((Lookup.Result<DataObject>)result);
        this.setDataObject(dataObject);
    }

    public void panelDeactivated() {
        if (this.lastEditor != null) {
            this.lastEditor.removeCaretListener(this.caretListener);
        }
        this.lastEditor = null;
    }

    public Lookup getLookup() {
        return null;
    }

    private void setDataObject(DataObject dataObject) {
        if (this.dataObject == dataObject) {
            return;
        }
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return;
        }
        LanguagesNavigatorModel languagesNavigatorModel = (LanguagesNavigatorModel)this.tree.getModel();
        try {
            NbEditorDocument nbEditorDocument = (NbEditorDocument)editorCookie.openDocument();
            String string = (String)nbEditorDocument.getProperty((Object)"mimeType");
            if (string == null) {
                return;
            }
            if (!LanguagesManager.getDefault().isSupported(string)) {
                return;
            }
            languagesNavigatorModel.setContext(nbEditorDocument);
        }
        catch (IOException iOException) {
            languagesNavigatorModel.setContext(null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (editorCookie.getOpenedPanes() != null && editorCookie.getOpenedPanes().length > 0) {
                    LanguagesNavigator.this.setCurrentEditor(editorCookie.getOpenedPanes()[0]);
                } else {
                    LanguagesNavigator.this.setCurrentEditor(null);
                }
            }
        });
    }

    private void setCurrentEditor(JEditorPane jEditorPane) {
        if (this.caretListener == null) {
            this.caretListener = new MyCaretListener();
        }
        if (this.lastEditor != null) {
            this.lastEditor.removeCaretListener(this.caretListener);
        }
        this.lastEditor = jEditorPane;
        if (this.lastEditor != null) {
            this.lastEditor.addCaretListener(this.caretListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyLookupListener
    implements LookupListener {
        private Lookup.Result<DataObject> result;

        MyLookupListener(Lookup.Result<DataObject> result) {
            this.result = result;
            result.addLookupListener((LookupListener)this);
        }

        void remove() {
            this.result.removeLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Iterator iterator = this.result.allInstances().iterator();
            if (!iterator.hasNext()) {
                LanguagesNavigator.this.setDataObject(null);
            } else {
                LanguagesNavigator.this.setDataObject((DataObject)iterator.next());
            }
        }
    }

    class MyCaretListener
    implements CaretListener {
        MyCaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            LanguagesNavigatorModel languagesNavigatorModel = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
            TreePath treePath = languagesNavigatorModel.getTreePath(caretEvent.getDot());
            if (treePath == null) {
                return;
            }
            LanguagesNavigator.this.tree.setSelectionPath(treePath);
            LanguagesNavigator.this.tree.scrollPathToVisible(treePath);
        }
    }

    class Listener
    implements MouseListener,
    KeyListener {
        Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            TreePath treePath = LanguagesNavigator.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            LanguagesNavigatorModel languagesNavigatorModel = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
            languagesNavigatorModel.show(object);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 10) {
                return;
            }
            TreePath treePath = LanguagesNavigator.this.tree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            LanguagesNavigatorModel languagesNavigatorModel = (LanguagesNavigatorModel)LanguagesNavigator.this.tree.getModel();
            languagesNavigatorModel.show(object);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        private static Map<String, Icon> icons = new HashMap<String, Icon>();

        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode) {
                jLabel.setIcon(null);
                jLabel.setText((String)((DefaultMutableTreeNode)object).getUserObject());
                return jLabel;
            }
            LanguagesNavigatorModel languagesNavigatorModel = (LanguagesNavigatorModel)jTree.getModel();
            jLabel.setIcon(Renderer.getCIcon(languagesNavigatorModel.getIcon(object)));
            jLabel.setText(languagesNavigatorModel.getDisplayName(object));
            return jLabel;
        }

        private static Icon getCIcon(String string) {
            if (string == null) {
                return null;
            }
            if (!icons.containsKey(string)) {
                Image image = ImageUtilities.loadImage((String)string);
                if (image == null) {
                    image = ImageUtilities.loadImage((String)"org/netbeans/modules/languages/resources/node.gif");
                }
                icons.put(string, new ImageIcon(image));
            }
            return icons.get(string);
        }
    }
}

