/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Language;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.LanguagesManager;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorTokenInput
extends TokenInput {
    private TokenSequence tokenSequence;
    private Language language;
    private List tokens = new ArrayList();
    private int index = 0;
    private Set<Integer> filter;
    private StyledDocument doc;
    private String mimeType;

    public static EditorTokenInput create(Set<Integer> set, StyledDocument styledDocument) {
        return new EditorTokenInput(set, styledDocument);
    }

    private EditorTokenInput(Set<Integer> set, StyledDocument styledDocument) {
        this.tokenSequence = TokenHierarchy.get((Document)styledDocument).tokenSequence();
        this.mimeType = this.tokenSequence.language().mimeType();
        try {
            this.language = LanguagesManager.get().getLanguage(this.mimeType);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        this.filter = set;
        this.doc = styledDocument;
    }

    @Override
    public ASTToken next(int n) {
        while (this.index + n - 1 >= this.tokens.size()) {
            ASTToken aSTToken = this.nextToken();
            if (aSTToken == null) {
                return null;
            }
            this.tokens.add(aSTToken);
        }
        return (ASTToken)this.tokens.get(this.index + n - 1);
    }

    private ASTToken nextToken() {
        do {
            if (this.tokenSequence.moveNext()) continue;
            return null;
        } while (this.filter.contains(this.tokenSequence.token().id().ordinal()));
        Token token = this.tokenSequence.token();
        return ASTToken.create(this.language, token.id().ordinal(), ((Object)token.text()).toString(), this.tokenSequence.offset());
    }

    @Override
    public boolean eof() {
        return this.next(1) == null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getOffset() {
        ASTToken aSTToken = null;
        if (this.eof()) {
            if (this.getIndex() == 0) {
                return 0;
            }
            aSTToken = (ASTToken)this.tokens.get(this.tokens.size() - 1);
            return aSTToken.getOffset() + aSTToken.getLength();
        }
        aSTToken = this.next(1);
        return aSTToken.getOffset();
    }

    @Override
    public ASTToken read() {
        ASTToken aSTToken = this.next(1);
        ++this.index;
        return aSTToken;
    }

    @Override
    public void setIndex(int n) {
        this.index = n;
    }

    public String getString(int n) {
        throw new InternalError();
    }

    public String toString() {
        int n = this.next(1) == null ? this.doc.getLength() : this.next(1).getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)this.doc, (int)n);
        return (String)this.doc.getProperty("title") + ":" + (n2 + 1) + "," + (n - NbDocument.findLineOffset((StyledDocument)this.doc, (int)n2) + 1);
    }
}

