/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Selector;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.Pattern;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feature {
    private String featureName;
    private Selector selector;
    private Object value;
    private Map<String, Evaluator> evaluators;
    private Map<String, Pattern> patterns;

    public static Feature create(String string, Selector selector) {
        return new Feature(string, selector, null, Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature createMethodCallFeature(String string, Selector selector, String string2) {
        return new Feature(string, selector, new Method(string2), Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature createExpressionFeature(String string, Selector selector, String string2) {
        return new Feature(string, selector, new Expression(string2), Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature createExpressionFeature(String string, Selector selector, Pattern pattern) {
        return new Feature(string, selector, pattern, Collections.<String, Evaluator>emptyMap(), Collections.<String, Pattern>emptyMap());
    }

    public static Feature create(String string, Selector selector, Map<String, String> map, Map<String, String> map2, Map<String, Pattern> map3) {
        HashMap<String, Evaluator> hashMap = new HashMap<String, Evaluator>();
        for (String string2 : map.keySet()) {
            hashMap.put(string2, new Expression(map.get(string2)));
        }
        for (String string2 : map2.keySet()) {
            hashMap.put(string2, new Method(map2.get(string2)));
        }
        return new Feature(string, selector, null, hashMap, map3);
    }

    private Feature(String string, Selector selector, Object object, Map<String, Evaluator> map, Map<String, Pattern> map2) {
        this.featureName = string;
        this.selector = selector;
        this.value = object;
        this.evaluators = map;
        this.patterns = map2;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean hasSingleValue() {
        return this.value != null;
    }

    public Type getType() {
        if (this.value == null) {
            return Type.NOT_SET;
        }
        if (this.value instanceof Pattern) {
            return Type.PATTERN;
        }
        if (this.value instanceof Method) {
            return Type.METHOD_CALL;
        }
        return Type.STRING;
    }

    public Object getValue() {
        if (this.value instanceof Evaluator) {
            return ((Evaluator)this.value).evaluate();
        }
        return this.value;
    }

    public Pattern getPattern() {
        return (Pattern)this.value;
    }

    public Object getValue(Context context) {
        if (this.value == null) {
            return null;
        }
        return ((Evaluator)this.value).evaluate(context);
    }

    public Object getValue(Object[] objectArray) {
        if (this.value == null) {
            return null;
        }
        return ((Method)this.value).evaluate(objectArray);
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object = this.getValue(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean((String)object);
    }

    public boolean getBoolean(String string, Context context, boolean bl) {
        Object object = this.getValue(string, context);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean((String)object);
    }

    public Object getValue(String string) {
        Evaluator evaluator = this.evaluators.get(string);
        if (evaluator != null) {
            return evaluator.evaluate();
        }
        return this.patterns.get(string);
    }

    public Object getValue(String string, Context context) {
        Evaluator evaluator = this.evaluators.get(string);
        if (evaluator == null) {
            return null;
        }
        return evaluator.evaluate(context);
    }

    public Object getValue(String string, Object[] objectArray) {
        Method method = (Method)this.evaluators.get(string);
        if (method == null) {
            return null;
        }
        return method.evaluate(objectArray);
    }

    public Pattern getPattern(String string) {
        return this.patterns.get(string);
    }

    public Type getType(String string) {
        if (this.patterns.containsKey(string)) {
            return Type.PATTERN;
        }
        Evaluator evaluator = this.evaluators.get(string);
        if (evaluator == null) {
            return Type.NOT_SET;
        }
        if (evaluator instanceof Method) {
            return Type.METHOD_CALL;
        }
        return Type.STRING;
    }

    public String getMethodName() {
        return ((Method)this.value).getMethodName();
    }

    public String getMethodName(String string) {
        Method method = (Method)this.evaluators.get(string);
        if (method == null) {
            return null;
        }
        return method.getMethodName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Feature ");
        if (this.featureName != null) {
            stringBuilder.append(this.featureName).append(' ');
        }
        if (this.selector != null) {
            stringBuilder.append(this.selector).append(' ');
        }
        if (this.value != null) {
            stringBuilder.append(this.value).append(' ');
        }
        return stringBuilder.toString();
    }

    private static class Method
    extends Evaluator {
        private String methodName;
        private java.lang.reflect.Method method;
        private boolean resolved = false;

        private Method(String string) {
            this.methodName = string;
        }

        public Object evaluate() {
            return this.evaluate(new Object[0]);
        }

        public Object evaluate(Context context) {
            return this.evaluate(new Object[]{context});
        }

        public Object evaluate(Object[] objectArray) {
            if (!this.resolved) {
                this.resolved = true;
                int n = this.methodName.lastIndexOf(46);
                if (n < 1) {
                    throw new IllegalArgumentException(this.methodName);
                }
                String string = this.methodName.substring(0, n);
                String string2 = this.methodName.substring(n + 1);
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    java.lang.reflect.Method[] methodArray = clazz.getMethods();
                    int n2 = methodArray.length;
                    for (int i = 0; i < n2; ++i) {
                        int n3;
                        if (!methodArray[i].getName().equals(string2) || methodArray[i].getParameterTypes().length != objectArray.length) continue;
                        Class<?>[] classArray = methodArray[i].getParameterTypes();
                        int n4 = objectArray.length;
                        for (n3 = 0; n3 < n4 && (objectArray[n3] == null || classArray[n3].isAssignableFrom(objectArray[n3].getClass())); ++n3) {
                        }
                        if (n3 < n4) continue;
                        this.method = methodArray[i];
                        break;
                    }
                    if (this.method == null) {
                        throw new NoSuchMethodException(this.methodName);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
                }
            }
            if (this.method != null) {
                try {
                    return this.method.invoke(null, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().notify((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
                }
            }
            return null;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    private static class Expression
    extends Evaluator {
        private String[] names;
        private String expression;

        private Expression(String string) {
            int n;
            this.expression = string;
            if (string == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            do {
                int n3;
                if ((n3 = string.indexOf(36, n2)) < 0) {
                    arrayList.add(string.substring(n2, string.length()));
                    break;
                }
                arrayList.add(string.substring(n2, n3));
                n = string.indexOf(36, ++n3);
                if (n < 0) {
                    n = string.length();
                }
                arrayList.add(string.substring(n3, n));
            } while ((n2 = n + 1) < string.length());
            this.names = arrayList.toArray(new String[arrayList.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evaluate(Context context) {
            if (context instanceof SyntaxContext) {
                ASTItem aSTItem = ((SyntaxContext)context).getASTPath().getLeaf();
                if (aSTItem instanceof ASTNode) {
                    return this.evaluate((ASTNode)aSTItem);
                }
                if (aSTItem instanceof ASTToken) {
                    return this.evaluate((ASTToken)aSTItem);
                }
            } else {
                AbstractDocument abstractDocument = (AbstractDocument)context.getDocument();
                abstractDocument.readLock();
                ASTToken aSTToken = null;
                try {
                    TokenSequence tokenSequence = Utils.getTokenSequence(abstractDocument, context.getOffset());
                    Token token = tokenSequence.token();
                    if (token != null) {
                        aSTToken = ASTToken.create(null, token.id().ordinal(), ((Object)token.text()).toString(), tokenSequence.offset());
                    }
                }
                finally {
                    abstractDocument.readUnlock();
                }
                return this.evaluate(aSTToken);
            }
            throw new IllegalArgumentException();
        }

        public Object evaluate() {
            return this.expression;
        }

        private Object evaluate(ASTNode aSTNode) {
            if (this.names == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.names.length;
            for (int i = 0; i < n; i += 2) {
                stringBuilder.append(this.names[i]);
                if (i + 1 >= this.names.length) break;
                if (this.names[i + 1].equals("")) {
                    stringBuilder.append(aSTNode.getAsText());
                    continue;
                }
                ASTItem aSTItem = Expression.get(aSTNode, this.names[i + 1]);
                if (aSTItem instanceof ASTToken) {
                    stringBuilder.append(((ASTToken)aSTItem).getIdentifier());
                    continue;
                }
                if (!(aSTItem instanceof ASTNode)) continue;
                stringBuilder.append(((ASTNode)aSTItem).getAsText());
            }
            return stringBuilder.toString();
        }

        private static ASTItem get(ASTNode aSTNode, String string) {
            int n = string.indexOf(46);
            if (n > 0) {
                String string2 = string.substring(0, n);
                ASTNode aSTNode2 = aSTNode.getNode(string2);
                if (aSTNode2 != null) {
                    return Expression.get(aSTNode2, string.substring(n + 1));
                }
                return null;
            }
            ASTNode aSTNode3 = aSTNode.getNode(string);
            if (aSTNode3 != null) {
                return aSTNode3;
            }
            return aSTNode.getTokenType(string);
        }

        private String evaluate(ASTToken aSTToken) {
            if (this.names == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.names.length;
            for (int i = 0; i < n; i += 2) {
                stringBuilder.append(this.names[i]);
                if (i + 1 >= this.names.length) break;
                if (this.names[i + 1].equals("identifier")) {
                    stringBuilder.append(aSTToken.getIdentifier());
                    continue;
                }
                if (this.names[i + 1].equals("")) {
                    stringBuilder.append(aSTToken.getIdentifier());
                    continue;
                }
                if (!this.names[i + 1].equals("type")) continue;
                stringBuilder.append(aSTToken.getTypeName());
            }
            return stringBuilder.toString();
        }
    }

    private static abstract class Evaluator {
        private Evaluator() {
        }

        public abstract Object evaluate();

        public abstract Object evaluate(Context var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STRING,
        METHOD_CALL,
        PATTERN,
        NOT_SET;

    }
}

